/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.AboutWindow;
import com.limegroup.gnutella.gui.FinalizeListener;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.LimeButtonUI;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.MonitorView;
import com.limegroup.gnutella.gui.PasswordDialog;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.RefreshTimer;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.ShoppingView;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.connection.ConnectionMediator;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.menu.MenuMediator;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.statistics.StatisticsMediator;
import com.limegroup.gnutella.gui.upload.UploadMediator;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Launcher;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;

public final class GUIMediator {
    private static GUIMediator _instance = null;
    private static boolean HAS_DONATED = true;
    public static final int YES_OPTION = 101;
    public static final int NO_OPTION = 102;
    public static final int SEARCH_INDEX = 0;
    public static final int MONITOR_INDEX = 1;
    public static final int CONNECTIONS_INDEX = 2;
    public static final int LIBRARY_INDEX = 3;
    public static final int SHOPPING_INDEX = 4;
    private static final SettingsManager SETTINGS = SettingsManager.instance();
    private static final JFrame FRAME = new JFrame();
    private static MessageService MESSAGE_SERVICE = null;
    private final MainFrame MAIN_FRAME = new MainFrame(FRAME);
    private final SearchMediator SEARCH_MEDIATOR = this.MAIN_FRAME.getSearchMediator();
    private final DownloadMediator DOWNLOAD_MEDIATOR = this.MAIN_FRAME.getDownloadMediator();
    private final MonitorView MONITOR_VIEW = this.MAIN_FRAME.getMonitorView();
    private final UploadMediator UPLOAD_MEDIATOR = this.MAIN_FRAME.getUploadMediator();
    private final ConnectionMediator CONNECTION_MEDIATOR = this.MAIN_FRAME.getConnectionMediator();
    private final ShoppingView SHOPPING_VIEW = this.MAIN_FRAME.getShoppingView();
    private final LibraryMediator LIBRARY_MEDIATOR = this.MAIN_FRAME.getLibraryMediator();
    private final StatisticsMediator STATISTICS_MEDIATOR = this.MAIN_FRAME.getStatisticsMediator();
    private static OptionsMediator _optionsMediator;
    private final MenuMediator MENU_MEDIATOR = this.MAIN_FRAME.getMenuMediator();
    private final StatusLine STATUS_LINE = this.MAIN_FRAME.getStatusLine();
    private static final Component HORIZONTAL_SEPARATOR;
    private static final Component VERTICAL_SEPARATOR;
    private static final String APP_TITLE;
    private RouterService _routerService;
    private static final List REFRESH_LIST;
    private static final List THEME_OBSERVERS;
    private static final List THEME_COMPONENTS;
    static /* synthetic */ Class class$java$awt$Frame;

    public static synchronized GUIMediator instance() {
        if (_instance == null) {
            _instance = new GUIMediator();
        }
        return _instance;
    }

    private GUIMediator() {
        FRAME.setTitle(APP_TITLE);
        _optionsMediator = this.MAIN_FRAME.getOptionsMediator();
        GUIMediator.addRefreshListener(this.STATISTICS_MEDIATOR);
    }

    public final void startTimer() {
        RefreshTimer refreshTimer = new RefreshTimer();
        refreshTimer.startTimer();
    }

    public static final boolean getAppVisible() {
        return FRAME.isShowing();
    }

    public static final void setAppVisible(boolean bl) {
        ((Component)FRAME).setVisible(bl);
    }

    private final void setStatistics(String string) {
        this.getRouter();
        if (RouterService.hasClientSupernodeConnection()) {
            FRAME.setTitle(APP_TITLE);
        } else {
            FRAME.setTitle(APP_TITLE + "  (" + string + ")");
        }
    }

    public static final Dimension getAppSize() {
        return FRAME.getSize();
    }

    public static final Point getAppLocation() {
        return FRAME.getLocation();
    }

    public final MainFrame getMainFrame() {
        return this.MAIN_FRAME;
    }

    public void wakeupShoppingView() {
        this.getMainFrame().getShoppingView().wakeupComponent();
    }

    public static final JFrame getAppFrame() {
        return FRAME;
    }

    public final RouterService getRouter() {
        return this._routerService;
    }

    public final void setRouterService(RouterService routerService) {
        this._routerService = routerService;
    }

    public final void refreshGUI() {
        try {
            int n = 0;
            while (n < REFRESH_LIST.size()) {
                ((RefreshListener)REFRESH_LIST.get(n)).refresh();
                ++n;
            }
            int n2 = (int)RouterService.getNumHosts();
            long l = RouterService.getNumFiles();
            long l2 = RouterService.getTotalFileSize();
            int n3 = RouterService.getNumSharedFiles();
            int n4 = RouterService.getNumPendingShared();
            String string = this.STATUS_LINE.setStatistics(n2, l, l2, n3, n4);
            this.setStatistics(string);
            RouterService.updateHorizon();
            this.getRouter();
            this.setConnectedUI(RouterService.isConnected());
        }
        catch (Exception exception) {
            GUIMediator.showInternalError(exception);
        }
    }

    public static void setOptionsVisible(boolean bl) {
        if (_optionsMediator == null) {
            return;
        }
        _optionsMediator.setOptionsVisible(bl);
    }

    public static boolean isOptionsVisible() {
        if (_optionsMediator == null) {
            return false;
        }
        return _optionsMediator.isOptionsVisible();
    }

    public static Component getMainOptionsComponent() {
        if (_optionsMediator == null) {
            return null;
        }
        return _optionsMediator.getMainOptionsComponent();
    }

    public final void setStatisticsVisible(boolean bl) {
        this.STATISTICS_MEDIATOR.setStatisticsVisible(bl);
    }

    public final int showPasswordDialog(PasswordDialog passwordDialog) {
        return passwordDialog.showDialog();
    }

    public final void handleTabSelection(int n) {
        switch (n) {
            case 0: {
                this.MENU_MEDIATOR.handleStandardSelection();
                break;
            }
            case 1: {
                this.MENU_MEDIATOR.handleStandardSelection();
                break;
            }
            case 2: {
                this.MENU_MEDIATOR.handleStandardSelection();
                break;
            }
            case 3: {
                this.MENU_MEDIATOR.handleLibrarySelection();
                break;
            }
            case 4: {
                this.SHOPPING_VIEW.prepareComponent();
            }
        }
    }

    public void setWindow(int n) {
        this.MAIN_FRAME.setSelectedIndex(n);
    }

    public void updateTabIcon(int n) {
        this.MAIN_FRAME.updateTabIcon(n);
    }

    public void clearConnections() {
        this.CONNECTION_MEDIATOR.clearConnections();
    }

    public void setKeepAliveText(String string) {
        this.CONNECTION_MEDIATOR.setKeepAliveText(string);
    }

    public byte[] triggerSearch(String string) {
        byte[] byArray = SearchMediator.triggerSearch(string);
        this.MAIN_FRAME.setSelectedIndex(0);
        return byArray;
    }

    private void setConnectedUI(boolean bl) {
        SearchMediator.setConnected(bl);
        this.MENU_MEDIATOR.setConnected(bl);
        this.STATUS_LINE.setConnected(bl);
        if (!bl) {
            this.setSearching(false);
        }
    }

    public int getTotalUploads() {
        return this.UPLOAD_MEDIATOR.getTotalUploads();
    }

    public int getCurrentUploads() {
        return this.UPLOAD_MEDIATOR.getCurrentUploads();
    }

    public final int getTotalDownloads() {
        return this.DOWNLOAD_MEDIATOR.getTotalDownloads();
    }

    public final int getCurrentDownloads() {
        return this.DOWNLOAD_MEDIATOR.getCurrentDownloads();
    }

    public final void addSharedLibraryFolder() {
        this.LIBRARY_MEDIATOR.addSharedLibraryFolder();
    }

    public final void addNewLibraryFolder() {
        this.LIBRARY_MEDIATOR.addNewLibraryFolder();
    }

    public final void unshareLibraryFolder() {
        this.LIBRARY_MEDIATOR.unshareLibraryFolder();
    }

    public final void renameLibraryFolder() {
        this.LIBRARY_MEDIATOR.renameLibraryFolder();
    }

    public final void launchLibraryFile() {
        this.LIBRARY_MEDIATOR.launch();
    }

    public final void deleteLibraryFile() {
        this.LIBRARY_MEDIATOR.deleteLibraryFile();
    }

    public final void refreshLibrary() {
        this.LIBRARY_MEDIATOR.refresh();
    }

    public final void clearLibrary() {
        this.LIBRARY_MEDIATOR.clearLibrary();
    }

    private static void hideView() {
        if (CommonUtils.isJava118()) {
            GUIMediator.setAppVisible(false);
            return;
        }
        int n = GUIMediator.getIconifiedFrameState();
        int n2 = GUIMediator.getFrameState();
        if (n == -1 || n2 == -1) {
            GUIMediator.setAppVisible(false);
        } else {
            try {
                GUIMediator.setFrameState(n);
            }
            catch (IOException iOException) {
                GUIMediator.setAppVisible(false);
            }
        }
        if (CommonUtils.supportsTray()) {
            GUIMediator.setAppVisible(false);
            GUIMediator.addNotify();
        }
    }

    public static void restoreView() {
        if (CommonUtils.supportsTray()) {
            GUIMediator.setAppVisible(true);
            GUIMediator.hideNotify();
        }
        Finalizer.cancelShutdown();
        if (CommonUtils.isJava118()) {
            GUIMediator.setAppVisible(true);
            return;
        }
        int n = GUIMediator.getNormalFrameState();
        int n2 = GUIMediator.getFrameState();
        if (n == -1 || n2 == -1) {
            GUIMediator.setAppVisible(true);
            return;
        }
        if (n2 != n) {
            try {
                GUIMediator.setFrameState(n);
            }
            catch (IOException iOException) {
                GUIMediator.setAppVisible(true);
                return;
            }
        }
    }

    private static int getNormalFrameState() {
        try {
            Field field = (class$java$awt$Frame == null ? (class$java$awt$Frame = GUIMediator.class$("java.awt.Frame")) : class$java$awt$Frame).getField("NORMAL");
            return field.getInt(class$java$awt$Frame == null ? (class$java$awt$Frame = GUIMediator.class$("java.awt.Frame")) : class$java$awt$Frame);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static int getIconifiedFrameState() {
        try {
            Field field = (class$java$awt$Frame == null ? (class$java$awt$Frame = GUIMediator.class$("java.awt.Frame")) : class$java$awt$Frame).getField("ICONIFIED");
            return field.getInt(class$java$awt$Frame == null ? (class$java$awt$Frame = GUIMediator.class$("java.awt.Frame")) : class$java$awt$Frame);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static int getFrameState() {
        try {
            Class clazz = class$java$awt$Frame == null ? (class$java$awt$Frame = GUIMediator.class$("java.awt.Frame")) : class$java$awt$Frame;
            Method method = clazz.getDeclaredMethod("getState", new Class[0]);
            return (Integer)method.invoke((Object)FRAME, new Object[0]);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    private static void setFrameState(int n) throws IOException {
        try {
            Class clazz = class$java$awt$Frame == null ? (class$java$awt$Frame = GUIMediator.class$("java.awt.Frame")) : class$java$awt$Frame;
            Method method = clazz.getDeclaredMethod("setState", Integer.TYPE);
            method.invoke((Object)FRAME, new Integer(n));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close() {
        if (SETTINGS.getMinimizeToTray()) {
            GUIMediator.hideView();
        } else if (SETTINGS.getShutdownAfterTransfers() && !CommonUtils.isMacClassic()) {
            GUIMediator.shutdownAfterTransfers();
        } else {
            GUIMediator.shutdown();
        }
    }

    public static void shutdown() {
        Finalizer.shutdown();
    }

    public static void shutdownAfterTransfers() {
        Finalizer.shutdownAfterTransfers();
        GUIMediator.hideView();
    }

    public static final void showAboutWindow() {
        AboutWindow aboutWindow = new AboutWindow();
        aboutWindow.showDialog();
    }

    public static void updateNotifyImage(String string) {
        NotifyUserProxy.instance().updateImage(string);
    }

    public static void updateNotifyText(String string) {
        NotifyUserProxy.instance().updateDesc(string);
    }

    public static void updateNotify(String string, String string2) {
        NotifyUserProxy.instance().updateNotify(string, string2);
    }

    public static void hideNotify() {
        NotifyUserProxy.instance().hideNotify();
    }

    public static void addNotify() {
        NotifyUserProxy.instance().addNotify();
    }

    public static final ImageIcon getThemeImage(String string) {
        return ResourceManager.getThemeImage(string);
    }

    public static URL getURLResource(String string) {
        return ResourceManager.getURLResource(string);
    }

    public static final String getStringResource(String string) {
        return ResourceManager.getStringResource(string);
    }

    public static final int showYesNoMessage(String string) {
        return GUIMediator._showYesNoMessage(GUIMediator.getStringResource(string));
    }

    public static final int showYesNoMessage(String string, String string2) {
        return GUIMediator._showYesNoMessage(GUIMediator.getStringResource(string) + " " + string2);
    }

    public static final int showYesNoMessage(String string, String string2, String string3) {
        return GUIMediator._showYesNoMessage(GUIMediator.getStringResource(string) + " " + string2 + " " + GUIMediator.getStringResource(string3));
    }

    public static final void showMessage(String string) {
        GUIMediator._showMessage(GUIMediator.getStringResource(string));
    }

    public static final void showMessage(String string, String string2) {
        GUIMediator._showMessage(GUIMediator.getStringResource(string) + " " + string2);
    }

    public static final void showMessage(String string, String string2, String string3) {
        GUIMediator._showMessage(GUIMediator.getStringResource(string) + " " + string2 + " " + GUIMediator.getStringResource(string3));
    }

    public static final void showConfirmMessage(String string) {
        GUIMediator._showConfirmMessage(GUIMediator.getStringResource(string));
    }

    public static final void showConfirmMessage(String string, String string2) {
        GUIMediator._showConfirmMessage(GUIMediator.getStringResource(string) + " " + string2);
    }

    public static final void showConfirmMessage(String string, String string2, String string3) {
        GUIMediator._showConfirmMessage(GUIMediator.getStringResource(string) + " " + string2 + " " + GUIMediator.getStringResource(string3));
    }

    public static final void showError(String string) {
        GUIMediator._showError(GUIMediator.getStringResource(string));
    }

    public static final void showError(String string, String string2) {
        GUIMediator._showError(GUIMediator.getStringResource(string) + " " + string2);
    }

    public static final void showError(String string, String string2, String string3) {
        GUIMediator._showError(GUIMediator.getStringResource(string) + " " + string2 + " " + GUIMediator.getStringResource(string3));
    }

    public static final void showInternalError(String string, Throwable throwable) {
        GUIMediator._showInternalError(GUIMediator.getStringResource(string), throwable);
    }

    public static final void showInternalError(Throwable throwable) {
        GUIMediator._showInternalError(GUIMediator.getStringResource("ERROR_INTERNAL"), throwable);
    }

    private static final int _showYesNoMessage(String string) {
        if (MESSAGE_SERVICE == null) {
            MESSAGE_SERVICE = new MessageService();
        }
        return MESSAGE_SERVICE.showYesNoMessage(string);
    }

    private static final void _showMessage(String string) {
        if (MESSAGE_SERVICE == null) {
            MESSAGE_SERVICE = new MessageService();
        }
        MESSAGE_SERVICE.showMessage(string);
    }

    private static final void _showConfirmMessage(String string) {
        if (MESSAGE_SERVICE == null) {
            MESSAGE_SERVICE = new MessageService();
        }
        MESSAGE_SERVICE.showConfirmMessage(string);
    }

    private static final void _showError(String string) {
        if (MESSAGE_SERVICE == null) {
            MESSAGE_SERVICE = new MessageService();
        }
        MESSAGE_SERVICE.showError(string);
    }

    private static final void _showInternalError(String string, Throwable throwable) {
        if (MESSAGE_SERVICE == null) {
            MESSAGE_SERVICE = new MessageService();
        }
        MESSAGE_SERVICE.showInternalError(string, throwable);
    }

    public static final int openURL(String string) throws IOException {
        return Launcher.openURL(string);
    }

    public static final int launchFile(File file) throws IOException {
        try {
            return Launcher.launchFile(file);
        }
        catch (SecurityException securityException) {
            GUIMediator.showError("MESSAGE_FILE_LAUNCHING_SECURITY_MESSAGE");
            return -1;
        }
    }

    public static final Component getHorizontalSeparator() {
        return HORIZONTAL_SEPARATOR;
    }

    public static final Component getVerticalSeparator() {
        return VERTICAL_SEPARATOR;
    }

    public void connect() {
        RouterService.connect();
        this.setConnectedUI(true);
    }

    public void disconnect() {
        RouterService.disconnect();
        this.setConnectedUI(false);
    }

    public static boolean hasDonated() {
        return HAS_DONATED;
    }

    public void setTabVisible(int n, boolean bl) {
        this.MAIN_FRAME.setTabVisible(n, bl);
    }

    public static void setSplashScreenString(String string) {
        SplashWindow.setStatusText(string);
    }

    public static Point getScreenCenterPoint(Component component) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = Math.min(dimension2.width, dimension.width);
        int n2 = Math.min(dimension2.height - 40, dimension.height);
        return new Point((dimension2.width - n) / 2, (dimension2.height - n2) / 2);
    }

    public static void addFinalizeListener(FinalizeListener finalizeListener) {
        Finalizer.addFinalizeListener(finalizeListener);
    }

    public void setSearching(boolean bl) {
        this.MAIN_FRAME.setSearching(bl);
    }

    public static void addRefreshListener(RefreshListener refreshListener) {
        REFRESH_LIST.add(refreshListener);
    }

    public static JFileChooser getDirectoryChooser() {
        return ResourceManager.getDirectoryChooser();
    }

    public static FileDialog getOSXDirectoryChooser() {
        return ResourceManager.getOSXDirectoryChooser();
    }

    public boolean isConnected() {
        this.getRouter();
        return RouterService.isConnected();
    }

    static Locale getLocale() {
        return ResourceManager.getLocale();
    }

    public static LookAndFeel getInitialLookAndFeel() {
        return ResourceManager.getInitialLookAndFeel();
    }

    public void launchAudio(File file) {
        this.STATUS_LINE.launchAudio(file);
    }

    public void audioFileDoubleClicked() {
        this.STATUS_LINE.audioFileDoubleClicked();
    }

    public static boolean isBrowserPageLoaded() {
        return ResourceManager.isBrowserPageLoaded();
    }

    public static void addThemeObserver(ThemeObserver themeObserver) {
        THEME_OBSERVERS.add(themeObserver);
    }

    public static void addThemeComponent(Component component) {
        THEME_COMPONENTS.add(component);
    }

    public void setCurrentTheme(File file) {
        Object object;
        LimeButtonUI.updateTheme();
        ResourceManager.instance().setCurrentTheme(file);
        SwingUtilities.updateComponentTreeUI(GUIMediator.getMainOptionsComponent());
        SwingUtilities.updateComponentTreeUI(this.STATISTICS_MEDIATOR.getMainStatisticsComponent());
        SwingUtilities.updateComponentTreeUI(FRAME);
        Iterator iterator = THEME_COMPONENTS.iterator();
        while (iterator.hasNext()) {
            object = (Component)iterator.next();
            SwingUtilities.updateComponentTreeUI((Component)object);
        }
        iterator = THEME_OBSERVERS.iterator();
        while (iterator.hasNext()) {
            object = (ThemeObserver)iterator.next();
            object.updateTheme();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        HORIZONTAL_SEPARATOR = Box.createRigidArea(new Dimension(6, 0));
        VERTICAL_SEPARATOR = Box.createRigidArea(new Dimension(0, 6));
        APP_TITLE = GUIMediator.getStringResource("APP_TITLE");
        REFRESH_LIST = new ArrayList();
        THEME_OBSERVERS = new LinkedList();
        THEME_COMPONENTS = new LinkedList();
    }
}

