/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MultiLineLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;

public final class GUIUtils {
    private static final NumberFormat NUMBER_FORMAT0 = NumberFormat.getNumberInstance();
    private static final NumberFormat NUMBER_FORMAT1;
    private static final DateFormat DATETIME_FORMAT;
    public static final String GENERAL_UNIT_KILOBYTES;
    public static final String GENERAL_UNIT_MEGABYTES;
    public static final String GENERAL_UNIT_GIGABYTES;
    public static final String GENERAL_UNIT_TERABYTES;
    public static final String GENERAL_UNIT_KBPSEC;

    private GUIUtils() {
    }

    public static String toLocalizedInteger(long l) {
        return NUMBER_FORMAT0.format(l);
    }

    public static String toKilobytes(long l) {
        if (l < 0L) {
            return "? " + GENERAL_UNIT_KILOBYTES;
        }
        long l2 = l / 1024L;
        if ((l & 0x200L) != 0L || l > 0L && l < 1024L) {
            ++l2;
        }
        return NUMBER_FORMAT0.format(l2) + GENERAL_UNIT_KILOBYTES;
    }

    public static String toUnitbytes(long l) {
        String string;
        long l2;
        if (l < 0L) {
            return "? " + GENERAL_UNIT_KILOBYTES;
        }
        if (l < 0x6400000L) {
            l2 = 1024L;
            string = GENERAL_UNIT_KILOBYTES;
        } else if (l < 0x1900000000L) {
            l2 = 0x100000L;
            string = GENERAL_UNIT_MEGABYTES;
        } else if (l < 0x640000000000L) {
            l2 = 0x40000000L;
            string = GENERAL_UNIT_GIGABYTES;
        } else {
            l2 = 0x10000000000L;
            string = GENERAL_UNIT_TERABYTES;
        }
        NumberFormat numberFormat = (double)l * 100.0 / (double)l2 < 99995.0 ? NUMBER_FORMAT1 : NUMBER_FORMAT0;
        return numberFormat.format((double)l / (double)l2) + " " + string;
    }

    public static String toUnitnumber(double d, boolean bl) {
        String string;
        long l;
        double d2;
        double d3 = d2 = d < 0.0 ? -d : d;
        if (d2 < 100000.0) {
            l = 1L;
            string = "";
        } else if (d2 < 1.0E8) {
            l = 1000L;
            string = "k";
            bl = true;
        } else if (d2 < 1.0E11) {
            l = 1000000L;
            string = "M";
            bl = true;
        } else if (d2 < 1.0E14) {
            l = 1000000000L;
            string = "G";
            bl = true;
        } else {
            l = 1000000000000L;
            string = "T";
            bl = true;
        }
        NumberFormat numberFormat = bl && d2 * 100.0 / (double)l < 99995.0 ? NUMBER_FORMAT1 : NUMBER_FORMAT0;
        return numberFormat.format(d / (double)l) + string;
    }

    public static MultiLineLabel getSizedLabel(String string) {
        Dimension dimension = new Dimension();
        MultiLineLabel multiLineLabel = new MultiLineLabel(string);
        FontMetrics fontMetrics = ((Component)multiLineLabel).getFontMetrics(multiLineLabel.getFont());
        int n = fontMetrics.stringWidth(string);
        dimension.setSize(Integer.MAX_VALUE, n / 9);
        multiLineLabel.setPreferredSize(dimension);
        return multiLineLabel;
    }

    public static String speed2name(int n) {
        if (n <= 56) {
            return GUIConstants.MODEM_SPEED;
        }
        if (n <= 350) {
            return GUIConstants.CABLE_SPEED;
        }
        if (n <= 1000) {
            return GUIConstants.T1_SPEED;
        }
        return GUIConstants.T3_SPEED;
    }

    public static String rate2speed(double d) {
        return NUMBER_FORMAT0.format(d) + GENERAL_UNIT_KBPSEC;
    }

    public static String seconds2time(int n) {
        int n2 = n / 60;
        n -= n2 * 60;
        int n3 = n2 / 60;
        n2 -= n3 * 60;
        int n4 = n3 / 24;
        n3 -= n4 * 24;
        StringBuffer stringBuffer = new StringBuffer();
        if (n4 != 0) {
            stringBuffer.append(Integer.toString(n4));
            stringBuffer.append(":");
            if (n3 < 10) {
                stringBuffer.append("0");
            }
        }
        if (n4 != 0 || n3 != 0) {
            stringBuffer.append(Integer.toString(n3));
            stringBuffer.append(":");
            if (n2 < 10) {
                stringBuffer.append("0");
            }
        }
        stringBuffer.append(Integer.toString(n2));
        stringBuffer.append(":");
        if (n < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(Integer.toString(n));
        return stringBuffer.toString();
    }

    public static String msec2DateTime(long l) {
        Date date = new Date(l);
        return DATETIME_FORMAT.format(date);
    }

    static {
        NUMBER_FORMAT0.setMaximumFractionDigits(0);
        NUMBER_FORMAT0.setMinimumFractionDigits(0);
        NUMBER_FORMAT0.setGroupingUsed(true);
        NUMBER_FORMAT1 = NumberFormat.getNumberInstance();
        NUMBER_FORMAT1.setMaximumFractionDigits(1);
        NUMBER_FORMAT1.setMinimumFractionDigits(1);
        NUMBER_FORMAT1.setGroupingUsed(true);
        DATETIME_FORMAT = DateFormat.getDateTimeInstance();
        GENERAL_UNIT_KILOBYTES = GUIMediator.getStringResource("GENERAL_UNIT_KILOBYTES");
        GENERAL_UNIT_MEGABYTES = GUIMediator.getStringResource("GENERAL_UNIT_MEGABYTES");
        GENERAL_UNIT_GIGABYTES = GUIMediator.getStringResource("GENERAL_UNIT_GIGABYTES");
        GENERAL_UNIT_TERABYTES = GUIMediator.getStringResource("GENERAL_UNIT_TERABYTES");
        GENERAL_UNIT_KBPSEC = GUIMediator.getStringResource("GENERAL_UNIT_KBPSEC");
    }
}

