/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.MediaButton;
import com.limegroup.gnutella.settings.ThemeSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalScrollButton;

public class LimeButtonUI
extends BasicButtonUI {
    private static final LimeButtonUI limeButtonUI = new LimeButtonUI();
    private static ImageIcon _default0;
    private static ImageIcon _default1;
    private static ImageIcon _default2;
    private static ImageIcon _default3;
    private static ImageIcon _pressed0;
    private static ImageIcon _pressed1;
    private static ImageIcon _pressed2;
    private static ImageIcon _pressed3;

    public static void updateTheme() {
        _default0 = LimeButtonUI.getImageResource("button1.gif");
        _default1 = LimeButtonUI.getImageResource("button2.gif");
        _default2 = LimeButtonUI.getImageResource("button3.gif");
        _default3 = LimeButtonUI.getImageResource("button4.gif");
        _pressed0 = LimeButtonUI.getImageResource("button1_press.gif");
        _pressed1 = LimeButtonUI.getImageResource("button2_press.gif");
        _pressed2 = LimeButtonUI.getImageResource("button3_press.gif");
        _pressed3 = LimeButtonUI.getImageResource("button4_press.gif");
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return limeButtonUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (!(!(abstractButton instanceof JButton) || abstractButton instanceof MediaButton || abstractButton instanceof MetalComboBoxButton || abstractButton instanceof BasicArrowButton || abstractButton instanceof MetalScrollButton || abstractButton.getText() == null || abstractButton.getText().equals("") || !LimeButtonUI.shouldInstallUI(abstractButton))) {
            LimeButtonUI.setButtonValues(abstractButton);
            this.setIcons(abstractButton);
        }
    }

    private static void setButtonValues(AbstractButton abstractButton) {
        abstractButton.setBorderPainted(false);
        abstractButton.setContentAreaFilled(false);
        abstractButton.setHorizontalTextPosition(0);
        abstractButton.setFocusPainted(false);
    }

    private static boolean shouldInstallUI(AbstractButton abstractButton) {
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            return true;
        }
        if (icon == _default0) {
            return false;
        }
        if (icon == _default1) {
            return false;
        }
        if (icon == _default2) {
            return false;
        }
        if (icon == _default3) {
            return false;
        }
        Icon icon2 = abstractButton.getPressedIcon();
        if (icon2 == null) {
            return true;
        }
        if (icon2 == _pressed0) {
            return false;
        }
        if (icon2 == _pressed1) {
            return false;
        }
        if (icon2 == _pressed2) {
            return false;
        }
        return icon2 != _pressed3;
    }

    private void setIcons(AbstractButton abstractButton) {
        ImageIcon imageIcon;
        ImageIcon imageIcon2;
        FontMetrics fontMetrics = ((Component)abstractButton).getFontMetrics(abstractButton.getFont());
        int n = fontMetrics.stringWidth(abstractButton.getText());
        if (n < 30) {
            imageIcon2 = _default0;
            imageIcon = _pressed0;
        } else if (n < 53) {
            imageIcon2 = _default1;
            imageIcon = _pressed1;
        } else if (n < 72) {
            imageIcon2 = _default2;
            imageIcon = _pressed2;
        } else {
            imageIcon2 = _default3;
            imageIcon = _pressed3;
        }
        abstractButton.setIcon(imageIcon2);
        abstractButton.setDisabledIcon(imageIcon2);
        abstractButton.setPressedIcon(imageIcon);
        abstractButton.setDisabledSelectedIcon(imageIcon);
        abstractButton.setPreferredSize(new Dimension(imageIcon2.getIconWidth(), imageIcon2.getIconHeight()));
    }

    private static ImageIcon getImageResource(String string) {
        File file = ThemeSettings.THEME_DIR.getValue();
        return new ImageIcon(LimeButtonUI.toURL(new File(file, string)));
    }

    private static URL toURL(File file) {
        try {
            return new URL("file", "", LimeButtonUI.slashify(file.getAbsolutePath(), file.isDirectory(), file));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    private static String slashify(String string, boolean bl, File file) {
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && file.isDirectory()) {
            string2 = string2 + "/";
        }
        return string2;
    }

    static {
        LimeButtonUI.updateTheme();
    }
}

