/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.LimeTheme;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.util.CommonUtils;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.plaf.metal.MetalLookAndFeel;

final class LimeLookAndFeel
extends MetalLookAndFeel {
    LimeLookAndFeel() {
        MetalLookAndFeel.setCurrentTheme(new LimeTheme());
    }

    public String getDescription() {
        return "Lime Look and Feel";
    }

    public String getID() {
        return "GoLime";
    }

    public String getName() {
        return "Lime Look and Feel";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        String string = "com.limegroup.gnutella.gui.";
        uIDefaults.put("ButtonUI", string + "LimeButtonUI");
        if (!CommonUtils.isMacClassic()) {
            uIDefaults.put("ClassLoader", this.getClass().getClassLoader());
        }
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        ImageIcon imageIcon = ResourceManager.getThemeImage("question.gif");
        ImageIcon imageIcon2 = ResourceManager.getThemeImage("warning.gif");
        ImageIcon imageIcon3 = ResourceManager.getThemeImage("notsearching.gif");
        ImageIcon imageIcon4 = ResourceManager.getThemeImage("dir_open.gif");
        ImageIcon imageIcon5 = ResourceManager.getThemeImage("dir_closed.gif");
        uIDefaults.put("OptionPane.questionIcon", imageIcon);
        uIDefaults.put("OptionPane.errorIcon", imageIcon2);
        uIDefaults.put("OptionPane.informationIcon", imageIcon3);
        uIDefaults.put("Table.foreground", MetalLookAndFeel.getUserTextColor());
        uIDefaults.put("Table.selectionForeground", MetalLookAndFeel.getUserTextColor());
        uIDefaults.put("Table.selectionBackground", new ColorUIResource(ThemeFileHandler.SECONDARY3_COLOR.getValue()));
        uIDefaults.put("Table.focusCellForeground", MetalLookAndFeel.getUserTextColor());
        uIDefaults.put("Table.focusCellBackground", new ColorUIResource(ThemeFileHandler.SECONDARY3_COLOR.getValue()));
        uIDefaults.put("TableHeader.background", new ColorUIResource(ThemeFileHandler.TABLE_HEADER_BACKGROUND_COLOR.getValue()));
        uIDefaults.put("TableHeader.cellBorder", new BorderUIResource(BorderFactory.createRaisedBevelBorder()));
        uIDefaults.put("TableHeader.cellPressedBorder", new BorderUIResource(BorderFactory.createLoweredBevelBorder()));
        uIDefaults.put("Tree.expandedIcon", imageIcon4);
        uIDefaults.put("Tree.collapsedIcon", imageIcon5);
        uIDefaults.put("Tree.leafIcon", MetalIconFactory.getTreeFolderIcon());
        uIDefaults.put("Tree.rightChildIndent", new Integer(6));
        uIDefaults.put("CheckBox.foreground", MetalLookAndFeel.getSystemTextColor());
        uIDefaults.put("TextField.background", new ColorUIResource(ThemeFileHandler.WINDOW7_COLOR.getValue()));
        uIDefaults.put("ToolTip.foreground", MetalLookAndFeel.getControlTextColor());
        uIDefaults.put("ToolTip.background", MetalLookAndFeel.getControl());
        uIDefaults.put("Tree.foreground", MetalLookAndFeel.getUserTextColor());
        String string = System.getProperty("os.name");
        if (!string.startsWith("Windows")) {
            FontUIResource fontUIResource = new FontUIResource("Dialog", 0, 11);
            uIDefaults.put("Label.font", fontUIResource);
            uIDefaults.put("Button.font", fontUIResource);
        }
    }
}

