/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.sun.java.util.collections.Vector;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListEditor
extends JPanel {
    protected Vector model;
    protected DefaultListModel realModel;
    protected Vector listeners = new Vector();
    private static final int DEFAULT_COLUMNS = 10;
    protected JTextField editor;
    protected JButton addButton;
    protected JButton removeButton;
    protected JList list;
    private boolean addTail = true;

    public ListEditor() {
        this(new Vector());
    }

    public ListEditor(Vector vector) {
        JPanel jPanel = new JPanel();
        this.editor = new JTextField("");
        this.editor.setColumns(10);
        this.editor.setPreferredSize(new Dimension(500, 20));
        this.editor.setMaximumSize(new Dimension(500, 20));
        this.addButton = new JButton(GUIMediator.getStringResource("LIST_EDITOR_ADD_BUTTON_2"));
        this.addButton.addActionListener(new AddListener());
        this.removeButton = new JButton(GUIMediator.getStringResource("LIST_EDITOR_REMOVE_BUTTON"));
        this.removeButton.addActionListener(new RemoveListener());
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.editor);
        jPanel.add(this.addButton);
        jPanel.add(this.removeButton);
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListListener());
        JScrollPane jScrollPane = new JScrollPane(this.list, 22, 30);
        this.setModel(vector);
        jScrollPane.setPreferredSize(new Dimension(500, 50));
        jScrollPane.setMaximumSize(new Dimension(500, 50));
        this.setLayout(new BoxLayout(this, 1));
        this.add(jPanel);
        this.add(jScrollPane);
    }

    public Vector getModel() {
        return this.model;
    }

    public synchronized void setModel(Vector vector) {
        this.model = vector;
        this.realModel = new DefaultListModel();
        int n = 0;
        while (n < vector.size()) {
            this.realModel.addElement(vector.get(n));
            ++n;
        }
        this.list.setModel(this.realModel);
    }

    public void setAddTail(boolean bl) {
        this.addTail = bl;
    }

    public boolean getAddTail() {
        return this.addTail;
    }

    public synchronized void addListDataListener(ListDataListener listDataListener) {
        this.listeners.add(listDataListener);
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ListEditor.this.list.getSelectedIndex();
            if (n != -1) {
                ListEditor.this.model.remove(n);
                ListEditor.this.realModel.remove(n);
                ListEditor.this.editor.setText("");
                ListDataEvent listDataEvent = new ListDataEvent(ListEditor.this.model, 2, n, n);
                int n2 = 0;
                while (n2 < ListEditor.this.listeners.size()) {
                    ListDataListener listDataListener = (ListDataListener)ListEditor.this.listeners.get(n2);
                    listDataListener.intervalRemoved(listDataEvent);
                    ++n2;
                }
            }
        }
    }

    private class AddListener
    implements ActionListener {
        private AddListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ListEditor.this.editor.getText();
            if (string.trim().equals("")) {
                return;
            }
            int n = ListEditor.this.list.getSelectedIndex();
            if (n != -1) {
                ListEditor.this.model.setElementAt(string, n);
                ListEditor.this.realModel.setElementAt(string, n);
                ListDataEvent listDataEvent = new ListDataEvent(ListEditor.this.model, 0, n, n);
                int n2 = 0;
                while (n2 < ListEditor.this.listeners.size()) {
                    ListDataListener listDataListener = (ListDataListener)ListEditor.this.listeners.get(n2);
                    listDataListener.contentsChanged(listDataEvent);
                    ++n2;
                }
            } else {
                int n3;
                if (ListEditor.this.addTail) {
                    ListEditor.this.model.addElement(string);
                    ListEditor.this.realModel.addElement(string);
                    n3 = ListEditor.this.model.size() - 1;
                } else {
                    ListEditor.this.model.add(0, string);
                    ListEditor.this.realModel.add(0, string);
                    n3 = 0;
                }
                ListDataEvent listDataEvent = new ListDataEvent(ListEditor.this.model, 1, n3, n3);
                int n4 = 0;
                while (n4 < ListEditor.this.listeners.size()) {
                    ListDataListener listDataListener = (ListDataListener)ListEditor.this.listeners.get(n4);
                    listDataListener.intervalAdded(listDataEvent);
                    ++n4;
                }
            }
            ListEditor.this.editor.setText("");
            ListEditor.this.list.clearSelection();
        }
    }

    private class ListListener
    implements ListSelectionListener {
        private ListListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object e = ListEditor.this.list.getSelectedValue();
            if (e == null) {
                return;
            }
            ListEditor.this.editor.setText((String)e);
        }
    }
}

