/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LogoPanel;
import com.limegroup.gnutella.gui.MacEventHandler;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.MonitorView;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.ShoppingView;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.connection.ConnectionMediator;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.menu.MenuMediator;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.statistics.StatisticsMediator;
import com.limegroup.gnutella.gui.tabs.ConnectionsTab;
import com.limegroup.gnutella.gui.tabs.LibraryPlayListTab;
import com.limegroup.gnutella.gui.tabs.MonitorUploadTab;
import com.limegroup.gnutella.gui.tabs.SearchDownloadTab;
import com.limegroup.gnutella.gui.tabs.ShoppingBrowserTab;
import com.limegroup.gnutella.gui.tabs.Tab;
import com.limegroup.gnutella.gui.upload.UploadMediator;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

final class MainFrame
implements ComponentListener,
RefreshListener,
ThemeObserver {
    private static final int APP_WIDTH = 840;
    private static final int APP_HEIGHT = 600;
    private final SettingsManager SETTINGS = SettingsManager.instance();
    private final JTabbedPane TABBED_PANE = new JTabbedPane();
    private final SearchMediator SEARCH_MEDIATOR = new SearchMediator();
    private final DownloadMediator DOWNLOAD_MEDIATOR = DownloadMediator.instance();
    private final MonitorView MONITOR_VIEW = new MonitorView();
    private final UploadMediator UPLOAD_MEDIATOR = UploadMediator.instance();
    private final ShoppingView SHOPPING_VIEW = new ShoppingView();
    private final ConnectionMediator CONNECTION_MEDIATOR = ConnectionMediator.instance();
    private final LibraryMediator LIBRARY_MEDIATOR = LibraryMediator.instance();
    private final PlayListGUI PLAYLIST_VIEW = PlayListGUI.instance();
    private final StatisticsMediator STATISTICS_MEDIATOR = StatisticsMediator.instance();
    private final OptionsMediator OPTIONS_MEDIATOR = OptionsMediator.instance();
    private final StatusLine STATUS_LINE = new StatusLine();
    private final MenuMediator MENU_MEDIATOR = MenuMediator.instance();
    private final JFrame FRAME;
    private JSplitPane searchDownloadDivider;
    private boolean isDownloadViewVisible = false;
    private final LogoPanel LOGO_PANEL = new LogoPanel();
    private Tab[] TABS = null;

    MainFrame(JFrame jFrame) {
        this.FRAME = jFrame;
        this.buildTabs();
        this.TABBED_PANE.setPreferredSize(new Dimension(10000, 10000));
        ImageIcon imageIcon = GUIMediator.getThemeImage("plug.gif");
        ((Frame)this.FRAME).setIconImage(imageIcon.getImage());
        this.FRAME.addWindowListener(new WindowAdapter(){

            public void windowDeiconified(WindowEvent windowEvent) {
                GUIMediator.restoreView();
            }

            public void windowClosing(WindowEvent windowEvent) {
                Dimension dimension = GUIMediator.getAppSize();
                Point point = GUIMediator.getAppLocation();
                MainFrame.this.SETTINGS.setAppWidth(dimension.width);
                MainFrame.this.SETTINGS.setAppHeight(dimension.height);
                MainFrame.this.SETTINGS.setWindowX(point.x);
                MainFrame.this.SETTINGS.setWindowY(point.y);
                MainFrame.this.SETTINGS.writeProperties();
                GUIMediator.close();
            }
        });
        this.FRAME.addComponentListener(this);
        this.FRAME.setDefaultCloseOperation(0);
        this.setFrameDimensions();
        int n = 0;
        while (n < this.TABS.length) {
            this.addTab(this.TABS[n]);
            ++n;
        }
        this.TABBED_PANE.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                GUIMediator.instance().handleTabSelection(MainFrame.this.getIndex(jTabbedPane.getSelectedComponent()));
            }
        });
        if (CommonUtils.isAnyMac()) {
            new MacEventHandler();
        }
        if (!CommonUtils.isMacClassic()) {
            if (!this.SETTINGS.getMonitorViewEnabled()) {
                this.setTabVisible(1, false);
            }
            if (!this.SETTINGS.getConnectionViewEnabled()) {
                this.setTabVisible(2, false);
            }
            if (!this.SETTINGS.getLibraryViewEnabled()) {
                this.setTabVisible(3, false);
            }
            if (!this.SETTINGS.getShoppingViewEnabled() && this.shouldShowShoppingTab()) {
                this.setTabVisible(4, false);
            }
        }
        this.FRAME.setJMenuBar(this.MENU_MEDIATOR.getMenuBar());
        Container container = this.FRAME.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        BoxPanel boxPanel = new BoxPanel(1);
        boxPanel.add(this.TABBED_PANE);
        boxPanel.add(this.STATUS_LINE.getComponent());
        container.add(boxPanel);
        JLayeredPane jLayeredPane = JLayeredPane.getLayeredPaneAbove(this.TABBED_PANE);
        jLayeredPane.add(this.LOGO_PANEL, JLayeredPane.PALETTE_LAYER, 0);
        GUIMediator.addRefreshListener(this);
        this.configureMenusforShopping();
        GUIMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        this.FRAME.setJMenuBar(this.MENU_MEDIATOR.getMenuBar());
    }

    private boolean shouldShowShoppingTab() {
        return !GUIMediator.hasDonated() && CommonUtils.isWindows();
    }

    private void buildTabs() {
        if (this.shouldShowShoppingTab() && ResourceManager.isBrowserPageLoaded()) {
            this.TABS = new Tab[5];
            this.TABS[0] = new SearchDownloadTab(this.SEARCH_MEDIATOR, this.DOWNLOAD_MEDIATOR);
            this.TABS[1] = new MonitorUploadTab(this.MONITOR_VIEW, this.UPLOAD_MEDIATOR);
            this.TABS[2] = new ConnectionsTab(this.CONNECTION_MEDIATOR);
            this.TABS[3] = new LibraryPlayListTab(this.LIBRARY_MEDIATOR, this.PLAYLIST_VIEW);
            this.TABS[4] = new ShoppingBrowserTab(this.SHOPPING_VIEW);
        } else {
            this.TABS = new Tab[4];
            this.TABS[0] = new SearchDownloadTab(this.SEARCH_MEDIATOR, this.DOWNLOAD_MEDIATOR);
            this.TABS[1] = new MonitorUploadTab(this.MONITOR_VIEW, this.UPLOAD_MEDIATOR);
            this.TABS[2] = new ConnectionsTab(this.CONNECTION_MEDIATOR);
            this.TABS[3] = new LibraryPlayListTab(this.LIBRARY_MEDIATOR, this.PLAYLIST_VIEW);
        }
        int n = 0;
        while (n < this.TABS.length) {
            GUIMediator.addThemeComponent(this.TABS[n].getComponent());
            ++n;
        }
    }

    private void configureMenusforShopping() {
        if (this.shouldShowShoppingTab()) {
            int n = this.MENU_MEDIATOR.getMenuBar().getMenuCount();
            class MenuChangeListener
            implements MenuListener {
                private final /* synthetic */ MainFrame this$0;

                MenuChangeListener(MainFrame mainFrame) {
                    this.this$0 = mainFrame;
                }

                public void menuCanceled(MenuEvent menuEvent) {
                }

                public void menuDeselected(MenuEvent menuEvent) {
                }

                public void menuSelected(MenuEvent menuEvent) {
                    int n = MainFrame.access$200(this.this$0).getMenuBar().getMenuCount();
                    if (n > 1 && MainFrame.access$300(this.this$0) != null && MainFrame.access$400(this.this$0).getSelectedComponent() == MainFrame.access$300(this.this$0)) {
                        this.this$0.setSelectedIndex(0);
                    }
                }
            }
            MenuChangeListener menuChangeListener = new MenuChangeListener(this);
            int n2 = 0;
            while (n2 < n) {
                this.MENU_MEDIATOR.getMenuBar().getMenu(n2).addMenuListener(menuChangeListener);
                ++n2;
            }
        }
    }

    private void addTab(Tab tab) {
        this.TABBED_PANE.addTab(tab.getTitle(), tab.getIcon(), tab.getComponent(), tab.getToolTip());
    }

    private void insertTab(Tab tab, int n) {
        this.TABBED_PANE.insertTab(tab.getTitle(), tab.getIcon(), tab.getComponent(), tab.getToolTip(), n);
    }

    final void setSelectedIndex(int n) {
        int n2 = this.getTabIndex(n);
        if (n2 == -1) {
            return;
        }
        this.TABBED_PANE.setSelectedIndex(n2);
    }

    void updateTabIcon(int n) {
        int n2 = this.getTabIndex(n);
        if (n2 == -1) {
            return;
        }
        this.TABBED_PANE.setIconAt(n2, this.TABS[n].getIcon());
    }

    private final void setFrameDimensions() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 0;
        int n2 = 0;
        if (this.SETTINGS.getRunOnce()) {
            n = this.SETTINGS.getAppWidth();
            n2 = this.SETTINGS.getAppHeight();
            ((Component)this.FRAME).setLocation(this.SETTINGS.getWindowX(), this.SETTINGS.getWindowY());
        } else {
            n = Math.min(dimension.width, 840);
            n2 = Math.min(dimension.height - 40, 600);
            ((Component)this.FRAME).setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
        }
        ((Component)this.FRAME).setSize(new Dimension(n, n2));
    }

    void setTabVisible(int n, boolean bl) {
        if (n == 0 || n > this.TABS.length - 1) {
            throw new IllegalArgumentException("Invalid tab index: " + n);
        }
        Tab tab = this.TABS[n];
        JComponent jComponent = tab.getComponent();
        int n2 = this.TABBED_PANE.getTabCount();
        if (!bl) {
            int n3 = 0;
            while (n3 < n2) {
                if (jComponent.equals(this.TABBED_PANE.getComponentAt(n3))) {
                    this.TABBED_PANE.remove(n3);
                    break;
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n2) {
                Component component = this.TABBED_PANE.getComponentAt(n4);
                int n5 = this.getIndex(component);
                if (n5 == -1) {
                    return;
                }
                if (n5 > n) {
                    this.insertTab(this.TABS[n], n4);
                    break;
                }
                if (n4 == n2 - 1) {
                    this.insertTab(this.TABS[n], n4 + 1);
                }
                ++n4;
            }
            int n6 = this.TABBED_PANE.getSelectedIndex();
            if (n6 >= n) {
                this.TABBED_PANE.setSelectedIndex(++n6);
            }
        }
        this.MENU_MEDIATOR.setNavMenuItemEnabled(n, bl);
        tab.storeState(bl);
    }

    private int getIndex(Component component) {
        int n = 0;
        while (n < this.TABS.length) {
            if (component.equals(this.TABS[n].getComponent())) {
                return this.TABS[n].getIndex();
            }
            ++n;
        }
        return -1;
    }

    private int getTabIndex(int n) {
        int n2 = this.TABBED_PANE.getTabCount();
        JComponent jComponent = this.TABS[n].getComponent();
        int n3 = 0;
        while (n3 < n2) {
            Component component = this.TABBED_PANE.getComponentAt(n3);
            if (component.equals(jComponent)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public void refresh() {
        int n;
        if (this.DOWNLOAD_MEDIATOR.getActiveDownloads() == 0 && this.isDownloadViewVisible) {
            ((SearchDownloadTab)this.TABS[0]).setDividerLocation(1000);
            this.isDownloadViewVisible = false;
        } else if (this.DOWNLOAD_MEDIATOR.getActiveDownloads() > 0 && !this.isDownloadViewVisible && (n = this.DOWNLOAD_MEDIATOR.getActiveDownloads()) > 0) {
            double d = 1.0 - (n > 6 ? 0.4 : 0.3);
            ((SearchDownloadTab)this.TABS[0]).setDividerLocation(d);
            ((SearchDownloadTab)this.TABS[0]).getComponent().revalidate();
            this.TABBED_PANE.revalidate();
            this.isDownloadViewVisible = true;
        }
    }

    final SearchMediator getSearchMediator() {
        return this.SEARCH_MEDIATOR;
    }

    final DownloadMediator getDownloadMediator() {
        return this.DOWNLOAD_MEDIATOR;
    }

    final MonitorView getMonitorView() {
        return this.MONITOR_VIEW;
    }

    final UploadMediator getUploadMediator() {
        return this.UPLOAD_MEDIATOR;
    }

    final ConnectionMediator getConnectionMediator() {
        return this.CONNECTION_MEDIATOR;
    }

    final LibraryMediator getLibraryMediator() {
        return this.LIBRARY_MEDIATOR;
    }

    final ShoppingView getShoppingView() {
        return this.SHOPPING_VIEW;
    }

    final StatusLine getStatusLine() {
        return this.STATUS_LINE;
    }

    final MenuMediator getMenuMediator() {
        return this.MENU_MEDIATOR;
    }

    final OptionsMediator getOptionsMediator() {
        return this.OPTIONS_MEDIATOR;
    }

    final StatisticsMediator getStatisticsMediator() {
        return this.STATISTICS_MEDIATOR;
    }

    final void setSearching(boolean bl) {
        this.LOGO_PANEL.setSearching(bl);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.setSearchIconLocation();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.setSearchIconLocation();
    }

    private void setSearchIconLocation() {
        this.LOGO_PANEL.setLocation(this.FRAME.getSize().width - this.LOGO_PANEL.getSize().width - 12, this.MENU_MEDIATOR.getMenuBarHeight());
    }

    static /* synthetic */ MenuMediator access$200(MainFrame mainFrame) {
        return mainFrame.MENU_MEDIATOR;
    }

    static /* synthetic */ ShoppingView access$300(MainFrame mainFrame) {
        return mainFrame.SHOPPING_VIEW;
    }

    static /* synthetic */ JTabbedPane access$400(MainFrame mainFrame) {
        return mainFrame.TABBED_PANE;
    }
}

