/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

final class MessageService {
    public static final int YES_OPTION = 101;
    public static final int NO_OPTION = 102;

    MessageService() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_MESSAGE_SERVICE"));
    }

    final void showError(String string) {
        JOptionPane.showMessageDialog(MessageService.getParentComponent(), new MultiLineLabel(string), GUIMediator.getStringResource("MESSAGE_ERROR_CAPTION"), 0);
    }

    final void showMessage(String string) {
        JOptionPane.showMessageDialog(MessageService.getParentComponent(), new MultiLineLabel(string), GUIMediator.getStringResource("MESSAGE_CAPTION"), 1);
    }

    final void showConfirmMessage(String string) {
        JOptionPane.showConfirmDialog(MessageService.getParentComponent(), new MultiLineLabel(string), GUIMediator.getStringResource("MESSAGE_CAPTION"), 1);
    }

    final int showYesNoMessage(String string) {
        int n = JOptionPane.showConfirmDialog(MessageService.getParentComponent(), new MultiLineLabel(string), GUIMediator.getStringResource("MESSAGE_CAPTION"), 0);
        if (n == 0) {
            return 101;
        }
        return 102;
    }

    private static Component getParentComponent() {
        if (GUIMediator.isOptionsVisible()) {
            return GUIMediator.getMainOptionsComponent();
        }
        return GUIMediator.getAppFrame();
    }

    final void showInternalError(String string, Throwable throwable) {
        Object object;
        throwable.printStackTrace();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("LimeWire version ");
        printWriter.println(CommonUtils.getLimeWireVersion());
        printWriter.print("Java version ");
        printWriter.print(CommonUtils.getJavaVersion());
        printWriter.print(" from ");
        printWriter.println(this.prop("java.vendor"));
        printWriter.print(CommonUtils.getOS());
        printWriter.print(" v. ");
        printWriter.print(this.prop("os.version"));
        printWriter.print(" on ");
        printWriter.println(this.prop("os.arch"));
        Runtime runtime = Runtime.getRuntime();
        printWriter.println("Free/total memory: " + runtime.freeMemory() + "/" + runtime.totalMemory());
        printWriter.println();
        throwable.printStackTrace(printWriter);
        printWriter.println();
        File file = new File(CommonUtils.getUserSettingsDir(), "limewire.props");
        Properties properties = new Properties();
        try {
            object = new FileInputStream(file);
            properties.load((InputStream)object);
            ((FileInputStream)object).close();
            properties.list(printWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        printWriter.println("");
        printWriter.println("");
        printWriter.println("");
        printWriter.println("FILES IN CURRENT DIRECTORY:");
        object = CommonUtils.getCurrentDirectory();
        String[] stringArray = ((File)object).list();
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File((File)object, stringArray[n]);
            printWriter.println(file2.toString());
            printWriter.println("LAST MODIFIED: " + file2.lastModified());
            printWriter.println("SIZE: " + file2.length());
            printWriter.println();
            ++n;
        }
        printWriter.flush();
        this.displayError(string, stringWriter.toString());
        if (throwable instanceof ExceptionInInitializerError) {
            this.showInternalError("ExceptionInInitializerError::getException()", ((ExceptionInInitializerError)throwable).getException());
        }
    }

    private final String prop(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return "?";
        }
        return string2;
    }

    private final void displayError(String string, String string2) {
        final JDialog jDialog = new JDialog((Frame)GUIMediator.getAppFrame(), true);
        Dimension dimension = new Dimension(260, 120);
        Dimension dimension2 = new Dimension(220, 100);
        ((Component)jDialog).setSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        MultiLineLabel multiLineLabel = new MultiLineLabel(string, 400);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(multiLineLabel);
        jPanel3.add(Box.createVerticalStrut(6));
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createHorizontalGlue());
        final JTextArea jTextArea = new JTextArea(string2);
        jTextArea.selectAll();
        jTextArea.copy();
        jTextArea.setColumns(50);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jScrollPane.setPreferredSize(dimension2);
        JPanel jPanel4 = new JPanel();
        JButton jButton = new JButton("Copy Selection");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jTextArea.copy();
            }
        });
        JButton jButton2 = new JButton("Ok");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel.add(jPanel2);
        jPanel.add(jScrollPane);
        jPanel.add(jPanel4);
        jDialog.getContentPane().add(jPanel);
        if (GUIMediator.getAppVisible()) {
            jDialog.setLocationRelativeTo(MessageService.getParentComponent());
        } else {
            Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)jDialog).setLocation((dimension3.width - dimension.width) / 2, (dimension3.height - dimension.height) / 2);
        }
        jDialog.pack();
        jDialog.show();
    }
}

