/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.BufferListModel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MonitorView
extends PaddedPanel
implements ThemeObserver {
    private int listSize;
    private JTextField showText;
    private JCheckBox monitorCheckBox;
    private JList listBox;
    private JScrollPane scrollPane;
    private boolean bypassCountChange = false;
    private BufferListModel model = new BufferListModel(32);

    public MonitorView() {
        super(GUIMediator.getStringResource("MONITOR_VIEW_INCOMING_SEARCHES"));
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_MONITOR_WINDOW"));
        this.listBox = new JList(this.model);
        this.listBox.setPrototypeCellValue("                                      ");
        this.listBox.setFixedCellHeight(16);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.monitorCheckBox = new JCheckBox(GUIMediator.getStringResource("MONITOR_VIEW_ENABLE"));
        this.monitorCheckBox.addItemListener(new CheckBoxListener());
        jPanel.add(this.monitorCheckBox);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(new JLabel(GUIMediator.getStringResource("MONITOR_VIEW_SHOW_LAST")));
        this.showText = new WholeNumberField(32, 3);
        Dimension dimension = new Dimension(10, 20);
        this.showText.setPreferredSize(dimension);
        this.showText.setMaximumSize(dimension);
        this.listSize = 32;
        jPanel.add(this.showText);
        jPanel.add(new JLabel(GUIMediator.getStringResource("MONITOR_VIEW_SEARCHES")));
        this.scrollPane = new JScrollPane(this.listBox);
        this.scrollPane.setPreferredSize(new Dimension(340, 180));
        this.add(jPanel);
        this.add(this.scrollPane);
        this.showText.getDocument().addDocumentListener(new CountDocumentListener());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    int n = MonitorView.this.listBox.locationToIndex(mouseEvent.getPoint());
                    String string = (String)MonitorView.this.model.getElementAt(n);
                    MonitorView.this.triggerSearch(string);
                }
            }
        };
        this.listBox.addMouseListener(mouseAdapter);
        this.updateTheme();
        GUIMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        Color color = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        this.scrollPane.getViewport().setBackground(color);
        this.listBox.setBackground(color);
    }

    private void triggerSearch(String string) {
        GUIMediator.instance().triggerSearch(string);
    }

    private void setShowCount(String string) {
        this.bypassCountChange = true;
        this.showText.setText(string);
        this.bypassCountChange = false;
    }

    private void handleCountChange() {
        if (this.bypassCountChange) {
            return;
        }
        String string = this.showText.getText();
        if (string != null && !string.equals("")) {
            int n = Integer.parseInt(string);
            if (n > 10000) {
                this.listSize = 32;
                this.delayedSetText("32");
            } else {
                this.listSize = n;
            }
            this.model.changeSize(this.listSize);
            this.scrollPane.validate();
        }
    }

    private void delayedSetText(String string) {
        DelayedSetText delayedSetText = new DelayedSetText(string);
        SwingUtilities.invokeLater(delayedSetText);
    }

    private void doSearch() {
        String string = (String)this.listBox.getSelectedValue();
        if (string == null || string.equals("")) {
            return;
        }
    }

    private void clearAll() {
        this.model.removeAllElements();
        this.scrollPane.validate();
    }

    public void handleQueryString(String string) {
        if (this.monitorCheckBox.isSelected()) {
            if (string.length() == 0) {
                return;
            }
            char c = string.charAt(string.length() - 1);
            if (Character.isISOControl(c) || !Character.isDefined(c)) {
                string = string.substring(0, string.length() - 1);
            }
            this.model.addFirst(string);
        }
    }

    private class DelayedSetText
    implements Runnable {
        String val;

        public DelayedSetText(String string) {
            this.val = string;
        }

        public void run() {
            MonitorView.this.setShowCount(this.val);
        }
    }

    private class CountDocumentListener
    implements DocumentListener {
        private CountDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            MonitorView.this.handleCountChange();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            MonitorView.this.handleCountChange();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    private class CheckBoxListener
    implements ItemListener {
        private CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            GUIMediator gUIMediator = GUIMediator.instance();
            if (itemEvent.getStateChange() == 1) {
                gUIMediator.getRouter();
                if (RouterService.hasClientSupernodeConnection()) {
                    GUIMediator.showMessage("MONITOR_VIEW_LEAF_MESSAGE");
                }
            }
        }
    }
}

