/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import java.awt.Component;
import java.awt.FontMetrics;
import java.util.StringTokenizer;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;

public class MultiLineLabel
extends JTextArea {
    private static final int DEFAULT_LABEL_WIDTH = 200;

    public MultiLineLabel(String string) {
        if (string == null) {
            throw new NullPointerException("null string in multilinelabel");
        }
        this.setOpaque(false);
        this.setText(string);
    }

    public MultiLineLabel(String string, int n) {
        if (string == null) {
            throw new NullPointerException("null string in multilinelabel");
        }
        this.setOpaque(false);
        this.setText(string, n);
    }

    public MultiLineLabel(String[] stringArray) {
        this.setOpaque(false);
        super.setText(this.createSizedString(stringArray));
    }

    public MultiLineLabel(String string, int n, int n2, int n3) {
        super(n2, n3);
        if (string == null) {
            throw new NullPointerException("null string in multilinelabel");
        }
        this.setOpaque(false);
        this.setText(string, n);
    }

    public void setText(String string, int n) {
        super.setText(this.createSizedString(string, n));
    }

    public void setText(String string) {
        super.setText(this.createSizedString(string, 200));
    }

    public void updateUI() {
        super.updateUI();
        this.setWrapStyleWord(true);
        this.setHighlighter(null);
        this.setEditable(false);
        LookAndFeel.installBorder(this, "Label.border");
        LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foreground", "Label.font");
    }

    private String createSizedString(String string, int n) {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (fontMetrics.stringWidth(stringBuffer2.toString() + string2) > n) {
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer.append("\n");
                stringBuffer2 = new StringBuffer();
            }
            stringBuffer2.append(string2);
            stringBuffer2.append(" ");
        }
        stringBuffer.append(stringBuffer2.toString());
        return stringBuffer.toString();
    }

    private String createSizedString(String[] stringArray) {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

