/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ResourceManager;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

final class NonWindowsCBanner {
    private static ImageURLPair[] _images = new ImageURLPair[0];
    private static int _curImageIndex = 0;
    private static ImageURLPair _currentImageURLPair;
    private static final Timer TIMER;
    private static final CardLayout CARD_LAYOUT;
    private static final JPanel MAIN_PANEL;

    NonWindowsCBanner() {
        MAIN_PANEL.setLayout(CARD_LAYOUT);
        try {
            NonWindowsCBanner.loadAds();
        }
        catch (IOException iOException) {
            return;
        }
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                NonWindowsCBanner.handleLinkClick();
            }
        };
        MAIN_PANEL.addMouseListener(mouseAdapter);
        TIMER.start();
    }

    static void loadAds() throws IOException {
        Object object;
        Object object2;
        try {
            ResourceManager.unpackWarFiles();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Properties properties = new Properties();
        try {
            object2 = new File(System.getProperty("user.dir") + "/lib/ads/ads.props");
            object = new FileInputStream((File)object2);
            properties.load((InputStream)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException();
        }
        catch (IOException iOException) {
            GUIMediator.showInternalError(iOException);
            return;
        }
        object2 = properties.getProperty("AD_ID");
        SettingsManager.instance().setAdVersion((String)object2);
        object = properties.getProperty("AD_COUNT");
        int n = 0;
        try {
            n = Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageURLPair[] imageURLPairArray = new ImageURLPair[n];
        int n2 = 0;
        while (n2 < n) {
            String string = properties.getProperty("AD_IMG" + n2);
            String string2 = properties.getProperty("AD_URL" + n2);
            imageURLPairArray[n2] = new ImageURLPair(string, string2);
            MAIN_PANEL.add(imageURLPairArray[n2].getComponent(), imageURLPairArray[n2].getKey());
            ++n2;
        }
        _images = imageURLPairArray;
        if (_images.length > 0) {
            _currentImageURLPair = _images[0];
        }
    }

    private static ImageIcon getImageResource(String string) {
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage("lib/ads/" + string));
    }

    private static void handleLinkChange() {
        _currentImageURLPair = NonWindowsCBanner.getNextImageURLPair();
        CARD_LAYOUT.show(MAIN_PANEL, NonWindowsCBanner._currentImageURLPair.getKey());
    }

    private static void handleLinkClick() {
        try {
            GUIMediator.openURL(NonWindowsCBanner._currentImageURLPair.getURL());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static ImageURLPair getNextImageURLPair() {
        if (_curImageIndex == _images.length - 1) {
            _curImageIndex = 0;
            return _images[_curImageIndex];
        }
        return _images[++_curImageIndex];
    }

    Component getComponent() {
        return MAIN_PANEL;
    }

    static {
        TIMER = new Timer(60000, new ImageTimerListener());
        CARD_LAYOUT = new CardLayout();
        MAIN_PANEL = new JPanel();
    }

    private static final class ImageURLPair {
        private final String URL;
        private final JLabel LABEL;
        private final String IMAGE_NAME;

        private ImageURLPair(String string, String string2) {
            this.IMAGE_NAME = string;
            this.LABEL = new JLabel(NonWindowsCBanner.getImageResource(string));
            this.URL = string2;
        }

        private Component getComponent() {
            return this.LABEL;
        }

        private String getKey() {
            return this.IMAGE_NAME;
        }

        private String getURL() {
            return this.URL;
        }

        public String toString() {
            return "IMAGE_NAME: " + this.IMAGE_NAME + "\n" + "URL: " + this.URL + "\n";
        }
    }

    private static class ImageTimerListener
    implements ActionListener {
        private ImageTimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NonWindowsCBanner.handleLinkChange();
        }
    }
}

