/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LimeLookAndFeel;
import com.limegroup.gnutella.settings.ThemeSettings;
import com.limegroup.gnutella.updates.UpdateManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Expand;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;

final class ResourceManager {
    private static ResourceManager _instance;
    private final String WINDOWS_LIBRARY_NAME = "LimeWire20";
    private final String WINDOWS_LIBRARY_FULL_NAME = "LimeWire20.dll";
    private final String BROWSER_LIBRARY_NAME = "BrowserPage";
    private final String BROWSER_LIBRARY_FULL_NAME = "BrowserPage.dll";
    private static final String GUI_PATH = "com/limegroup/gnutella/gui/";
    private static final String IMAGES_PATH = "com/limegroup/gnutella/gui/images/";
    private static final String RESOURCES_PATH = "com/limegroup/gnutella/gui/resources/";
    private static ResourceBundle _resourceBundle;
    private static Locale _locale;
    private static boolean _browserPageLoaded;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$ResourceManager;

    static final ResourceManager instance() {
        if (_instance == null) {
            _instance = new ResourceManager();
        }
        return _instance;
    }

    private ResourceManager() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_RESOURCE_MANAGER"));
        try {
            if (CommonUtils.isMacOSX() && ThemeSettings.isDefaultTheme()) {
                String string = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(string);
                UIManager.put("Tree.leafIcon", UIManager.getIcon("Tree.closedIcon"));
                Font font = UIManager.getFont("Label.font");
                FontUIResource fontUIResource = new FontUIResource(font.getName(), font.getStyle(), font.getSize() - 2);
                UIManager.put("Label.font", fontUIResource);
            } else {
                UIManager.setLookAndFeel(new LimeLookAndFeel());
            }
        }
        catch (Exception exception) {
            GUIMediator.showInternalError(exception);
            GUIMediator.shutdown();
        }
        if (CommonUtils.isWindows()) {
            CommonUtils.copyResourceFile("LimeWire20.dll");
            this.loadLibrary("LimeWire20");
        }
        if (!GUIMediator.hasDonated() && CommonUtils.isWindows()) {
            CommonUtils.copyResourceFile("BrowserPage.dll");
            this.loadLibrary("BrowserPage");
        }
        ResourceManager.unpackWarFiles();
        this.unpackVersionFile();
    }

    void setCurrentTheme(File file) {
        try {
            UIManager.setLookAndFeel(new LimeLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            GUIMediator.showInternalError(unsupportedLookAndFeelException);
        }
    }

    static boolean isBrowserPageLoaded() {
        return _browserPageLoaded;
    }

    static LookAndFeel getInitialLookAndFeel() {
        return new LimeLookAndFeel();
    }

    static final ImageIcon getThemeImage(String string) {
        return new ImageIcon(ResourceManager.toURL(new File(ThemeSettings.THEME_DIR.getValue(), string)));
    }

    static final String getStringResource(String string) {
        return _resourceBundle.getString(string);
    }

    static final boolean useBold() {
        return new Boolean(ResourceManager.getStringResource("DISABLE_BOLD_CHARACTERS")) == false;
    }

    static URL getURLResource(String string) {
        return ResourceManager.getURL(RESOURCES_PATH + string);
    }

    private static URL getURL(String string) {
        ClassLoader classLoader = (class$com$limegroup$gnutella$gui$ResourceManager == null ? (class$com$limegroup$gnutella$gui$ResourceManager = ResourceManager.class$("com.limegroup.gnutella.gui.ResourceManager")) : class$com$limegroup$gnutella$gui$ResourceManager).getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            return ClassLoader.getSystemResource(string);
        }
        return uRL;
    }

    static Locale getLocale() {
        return _locale;
    }

    private void loadLibrary(String string) {
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            if (string.equals("BrowserPage")) {
                _browserPageLoaded = false;
                return;
            }
            GUIMediator.showInternalError(unsatisfiedLinkError);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void unpackWarFiles() {
        File file = CommonUtils.getCurrentDirectory();
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".war");
            }
        });
        if (stringArray == null) {
            return;
        }
        File file2 = new File("lib");
        int n = 0;
        while (true) {
            block7: {
                File file3;
                Object var6_5;
                if (n >= stringArray.length) {
                    return;
                }
                try {
                    try {
                        Expand.expandFile(new File(stringArray[n]), file2);
                    }
                    catch (IOException iOException) {
                        var6_5 = null;
                        file3 = new File(file, stringArray[n]);
                        file3.delete();
                        break block7;
                    }
                    var6_5 = null;
                    file3 = new File(file, stringArray[n]);
                    file3.delete();
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    file3 = new File(file, stringArray[n]);
                    file3.delete();
                    throw throwable;
                }
            }
            ++n;
        }
    }

    private void unpackVersionFile() {
        String string;
        File file = CommonUtils.getUserSettingsDir();
        File file2 = new File(file, "update.xml");
        File file3 = new File("update.ver");
        if (!file2.exists()) {
            try {
                Expand.expandFile(file3, file);
            }
            catch (IOException iOException) {
                return;
            }
        }
        String string2 = CommonUtils.getLimeWireVersion();
        if (UpdateManager.isGreaterVersion(string2, string = this.parseVersion(file2)) || string.equals("@version@") && !string2.equals("@version@")) {
            try {
                Expand.expandFile(file3, file);
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    private String parseVersion(File file) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.read(byArray);
            randomAccessFile.close();
            String string = new String(byArray, "UTF8");
            int n = string.indexOf("<version>");
            int n2 = string.indexOf("</version>");
            String string2 = string.substring(n + 9, n2);
            return string2;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static JFileChooser getDirectoryChooser() {
        if (CommonUtils.isMacOSX()) {
            throw new RuntimeException("OS X systems should use the native file chooser");
        }
        JFileChooser jFileChooser = new JFileChooser(CommonUtils.getCurrentDirectory());
        jFileChooser.setFileSelectionMode(1);
        String string = GUIMediator.getStringResource("FILE_CHOOSER_DIRECTORY_TITLE");
        jFileChooser.setDialogTitle(string);
        String string2 = GUIMediator.getStringResource("FILE_CHOOSER_DIRECTORY_BUTTON_LABEL");
        jFileChooser.setApproveButtonText(string2);
        return jFileChooser;
    }

    static FileDialog getOSXDirectoryChooser() {
        if (!CommonUtils.isMacOSX()) {
            throw new RuntimeException("non-OS X systems should use the getOSXDirectoryChooser method");
        }
        return new FileDialog((Frame)GUIMediator.getAppFrame(), "", 3);
    }

    private static URL toURL(File file) {
        try {
            return new URL("file", "", ResourceManager.slashify(file.getAbsolutePath(), file.isDirectory(), file));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    private static String slashify(String string, boolean bl, File file) {
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && file.isDirectory()) {
            string2 = string2 + "/";
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _browserPageLoaded = true;
        SettingsManager settingsManager = SettingsManager.instance();
        _locale = new Locale(settingsManager.getLanguage(), settingsManager.getCountry(), settingsManager.getLocaleVariant());
        _resourceBundle = ResourceBundle.getBundle("MessagesBundle", _locale);
    }
}

