/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.event.HyperlinkListener;

public final class ScrollingTextPane
extends JScrollPane {
    private final JEditorPane EDITOR_PANE;
    protected Timer _timer;

    public ScrollingTextPane(String string) {
        URL uRL = GUIMediator.getURLResource(string);
        if (uRL == null) {
            throw new NullPointerException("FILE COULD NOT BE LOADED");
        }
        try {
            this.EDITOR_PANE = new JEditorPane(uRL);
        }
        catch (IOException iOException) {
            throw new NullPointerException("FILE COULD NOT BE LOADED");
        }
        this.EDITOR_PANE.setMargin(new Insets(5, 5, 5, 5));
        this.EDITOR_PANE.setEditable(false);
        JViewport jViewport = this.getViewport();
        jViewport.add(this.EDITOR_PANE);
        this.setDoubleBuffered(true);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScrollingTextPane.this.scroll();
            }
        };
        this._timer = new Timer(30, abstractAction);
    }

    public void showFile(String string) {
        URL uRL = GUIMediator.getURLResource(string);
        if (uRL == null) {
            throw new NullPointerException("FILE COULD NOT BE LOADED");
        }
        try {
            this.EDITOR_PANE.setPage(uRL);
        }
        catch (IOException iOException) {
            throw new NullPointerException("FILE COULD NOT BE LOADED");
        }
    }

    public void startScroll() {
        this._timer.start();
    }

    public void stopScroll() {
        this._timer.stop();
    }

    protected void scroll() {
        Rectangle rectangle = this.EDITOR_PANE.getVisibleRect();
        int n = rectangle.x;
        int n2 = this.getVerticalScrollBar().getValue();
        if (n2 + rectangle.height >= this.EDITOR_PANE.getHeight()) {
            return;
        }
        Rectangle rectangle2 = new Rectangle(n, ++n2, n + rectangle.width, n2 + rectangle.height);
        this.EDITOR_PANE.scrollRectToVisible(rectangle2);
    }

    public void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.EDITOR_PANE.addHyperlinkListener(hyperlinkListener);
    }
}

