/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

final class SplashWindow
extends JWindow {
    private static final SplashGlassPane GLASS_PANE = new SplashGlassPane();

    SplashWindow() {
        ResourceManager.instance();
        ImageIcon imageIcon = ResourceManager.getThemeImage("splash.gif");
        Image image = imageIcon.getImage();
        Dimension dimension = new Dimension(image.getWidth(null) + 2, image.getHeight(null) + 2);
        ((Component)this).setSize(dimension);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.setGlassPane(GLASS_PANE);
        this.getContentPane().add((Component)jLabel, "Center");
        this.pack();
        ((Component)this).setVisible(true);
        GLASS_PANE.setVisible(true);
    }

    static void setStatusText(String string) {
        SplashGlassPane.setText(string);
    }

    private static final class SplashGlassPane
    extends JPanel {
        private static JPanel TEXT_PANEL = new JPanel();
        private static JLabel TEXT_LABEL = new JLabel();

        private SplashGlassPane() {
            this.setOpaque(false);
            this.setLayout(new BoxLayout(this, 1));
            this.add(Box.createVerticalGlue());
            TEXT_PANEL.setOpaque(false);
            TEXT_PANEL.setLayout(new BoxLayout(TEXT_PANEL, 0));
            TEXT_PANEL.add(Box.createHorizontalGlue());
            TEXT_LABEL.setMinimumSize(new Dimension(40, 3));
            TEXT_PANEL.add(TEXT_LABEL);
            TEXT_PANEL.add(GUIMediator.getHorizontalSeparator());
            this.add(TEXT_PANEL);
            this.add(GUIMediator.getVerticalSeparator());
        }

        private static void setText(String string) {
            FontMetrics fontMetrics = ((Component)TEXT_LABEL).getFontMetrics(TEXT_LABEL.getFont());
            TEXT_LABEL.setPreferredSize(new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight()));
            TEXT_LABEL.setText(string);
        }
    }
}

