/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.InputFieldDialog;
import com.sun.java.util.collections.Vector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class StandardListEditor {
    private final BoxPanel MAIN_PANEL = new BoxPanel(0);
    private final String INPUT_FIELD_KEY;
    private final JList LIST = new JList();
    private final JButton REMOVE_BUTTON;
    private final JButton ADD_BUTTON;
    private ActionListener _defaultAddListener;
    private boolean _listChanged = false;

    public StandardListEditor(String string) {
        this("LIST_EDITOR_ADD_BUTTON", "LIST_EDITOR_REMOVE_BUTTON", string);
    }

    public StandardListEditor(ActionListener actionListener) {
        this("LIST_EDITOR_ADD_BUTTON", "LIST_EDITOR_REMOVE_BUTTON", "");
        this.setAddActionListener(actionListener);
    }

    public StandardListEditor(String string, String string2, String string3) {
        this.INPUT_FIELD_KEY = string3;
        BoxPanel boxPanel = new BoxPanel(0);
        String[] stringArray = new String[]{string, string2};
        String[] stringArray2 = new String[]{"LIST_EDITOR_ADD_BUTTON_TIP", "LIST_EDITOR_REMOVE_BUTTON_TIP"};
        this._defaultAddListener = new AddActionListener(string3);
        ActionListener[] actionListenerArray = new ActionListener[]{this._defaultAddListener, new RemoveListener()};
        ButtonRow buttonRow = new ButtonRow(stringArray, stringArray2, actionListenerArray, 1, 11);
        this.ADD_BUTTON = buttonRow.getButtonAtIndex(0);
        this.REMOVE_BUTTON = buttonRow.getButtonAtIndex(1);
        this.REMOVE_BUTTON.setEnabled(false);
        this.LIST.setSelectionMode(0);
        this.LIST.addListSelectionListener(new ListEditorSelectionListener());
        JScrollPane jScrollPane = new JScrollPane(this.LIST);
        this.MAIN_PANEL.add(jScrollPane);
        this.MAIN_PANEL.add(buttonRow);
    }

    public Component getComponent() {
        return this.MAIN_PANEL;
    }

    private void addElement(Object object) {
        DefaultListModel defaultListModel = (DefaultListModel)this.LIST.getModel();
        defaultListModel.addElement(object);
    }

    public void addFile(File file) {
        this.addElement(file);
    }

    public void addString(String string) {
        this.addElement(string);
    }

    public void setListData(Vector vector) {
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        int n = 0;
        while (n < vector.size()) {
            defaultListModel.addElement(vector.get(n));
            ++n;
        }
        this.LIST.setModel(defaultListModel);
    }

    private void setListDataObjects(Object[] objectArray) {
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        int n = 0;
        while (n < objectArray.length) {
            defaultListModel.addElement(objectArray[n]);
            ++n;
        }
        this.LIST.setModel(defaultListModel);
    }

    public void setListData(File[] fileArray) {
        this.setListDataObjects(fileArray);
    }

    public void setListData(String[] stringArray) {
        this.setListDataObjects(stringArray);
    }

    public void clearSelection() {
        this.LIST.clearSelection();
    }

    public String[] getDataAsStringArray() {
        DefaultListModel defaultListModel = (DefaultListModel)this.LIST.getModel();
        Object[] objectArray = defaultListModel.toArray();
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = objectArray[n].toString();
            ++n;
        }
        return stringArray;
    }

    public File[] getDataAsFileArray() {
        DefaultListModel defaultListModel = (DefaultListModel)this.LIST.getModel();
        Object[] objectArray = defaultListModel.toArray();
        File[] fileArray = new File[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            fileArray[n] = (File)objectArray[n];
            ++n;
        }
        return fileArray;
    }

    public Object[] getDataAsObjectArray() {
        DefaultListModel defaultListModel = (DefaultListModel)this.LIST.getModel();
        return defaultListModel.toArray();
    }

    private void setAddActionListener(ActionListener actionListener) {
        this.ADD_BUTTON.removeActionListener(this._defaultAddListener);
        this.ADD_BUTTON.addActionListener(actionListener);
    }

    public boolean getListChanged() {
        return this._listChanged;
    }

    public void resetList() {
        this._listChanged = false;
    }

    private class ListEditorSelectionListener
    implements ListSelectionListener {
        private ListEditorSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            if (StandardListEditor.this.LIST.isSelectionEmpty()) {
                StandardListEditor.this.REMOVE_BUTTON.setEnabled(false);
            } else {
                StandardListEditor.this.REMOVE_BUTTON.setEnabled(true);
            }
        }
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StandardListEditor.this._listChanged = true;
            if (StandardListEditor.this.LIST.isSelectionEmpty()) {
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)StandardListEditor.this.LIST.getModel();
            defaultListModel.remove(StandardListEditor.this.LIST.getSelectedIndex());
            if (StandardListEditor.this.LIST.isSelectionEmpty()) {
                StandardListEditor.this.REMOVE_BUTTON.setEnabled(false);
            }
        }
    }

    private class AddActionListener
    implements ActionListener {
        private final String INPUT_FIELD_KEY;

        public AddActionListener(String string) {
            this.INPUT_FIELD_KEY = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InputFieldDialog inputFieldDialog = new InputFieldDialog(this.INPUT_FIELD_KEY);
            int n = inputFieldDialog.showDialog();
            if (n == 79) {
                StandardListEditor.this._listChanged = true;
                StandardListEditor.this.addElement(inputFieldDialog.getText());
            }
        }
    }
}

