/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.StatusLinkHandler;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.mp3.MediaPlayerComponent;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class StatusLine
implements ThemeObserver {
    private JPanel switchedPanel;
    private CardLayout switcher;
    private JLabel sharingLabel;
    private MediaPlayerComponent _mediaPlayer;
    private final JPanel PANEL = new BoxPanel(0);
    private final JLabel CONNECTED_LABEL = new JLabel();
    private final JLabel DISCONNECTED_LABEL = new JLabel();
    private String STATS_AVAILABLE_STRING = GUIMediator.getStringResource("STATISTICS_AVAILABLE");
    private String STATS_FILE_STRING = GUIMediator.getStringResource("STATISTICS_FILES");
    private String STATS_DISCONNECTED_STRING = GUIMediator.getStringResource("STATISTICS_DISCONNECTED");
    private String STATS_SHARING_STRING = GUIMediator.getStringResource("STATISTICS_SHARING");

    public StatusLine() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_STATUS_WINDOW"));
        this.createConnectPanel();
        this.sharingLabel = new JLabel("           ");
        this.sharingLabel.setHorizontalAlignment(0);
        this.sharingLabel.setMinimumSize(new Dimension(20, 3));
        String string = GUIMediator.getStringResource("STATISTICS_SHARING_TOOLTIP");
        this.sharingLabel.setToolTipText(string);
        this.setConnected(false);
        this.PANEL.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.switchedPanel);
        jPanel.add(this.sharingLabel);
        this.PANEL.add(jPanel);
        BoxPanel boxPanel = new BoxPanel(0);
        if (!GUIMediator.hasDonated()) {
            boxPanel.add(Box.createHorizontalGlue());
            boxPanel.add(new StatusLinkHandler().getComponent());
            boxPanel.add(Box.createHorizontalGlue());
        }
        this.PANEL.add(boxPanel);
        if (!CommonUtils.isMacClassic()) {
            this._mediaPlayer = new MediaPlayerComponent();
            JPanel jPanel2 = this._mediaPlayer.getMediaPanel();
            this.PANEL.add(jPanel2);
        }
        GUIMediator.addThemeObserver(this);
    }

    private void createConnectPanel() {
        this.updateTheme();
        this.switchedPanel = new JPanel();
        this.switcher = new CardLayout();
        this.switchedPanel.setLayout(this.switcher);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(this.CONNECTED_LABEL);
        this.switchedPanel.add("connect", jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.DISCONNECTED_LABEL);
        this.switchedPanel.add("disconnect", jPanel2);
        this.switchedPanel.setMaximumSize(new Dimension(60, 30));
    }

    public void updateTheme() {
        ImageIcon imageIcon = GUIMediator.getThemeImage("connected.gif");
        ImageIcon imageIcon2 = GUIMediator.getThemeImage("disconnected.gif");
        this.CONNECTED_LABEL.setIcon(imageIcon);
        this.DISCONNECTED_LABEL.setIcon(imageIcon2);
        if (this._mediaPlayer != null) {
            this._mediaPlayer.updateTheme();
        }
    }

    public void setConnected(boolean bl) {
        if (bl) {
            JPanel jPanel = this.switchedPanel;
            synchronized (jPanel) {
                this.switcher.first(this.switchedPanel);
            }
        }
        JPanel jPanel = this.switchedPanel;
        synchronized (jPanel) {
            this.switcher.last(this.switchedPanel);
        }
    }

    public String setStatistics(long l, long l2, long l3, int n, int n2) {
        String string = l == 0L ? this.STATS_DISCONNECTED_STRING : GUIUtils.toUnitnumber(l2, false) + " " + this.STATS_FILE_STRING + " / " + GUIUtils.toUnitbytes(l3 * 1024L) + " " + this.STATS_AVAILABLE_STRING;
        if (n2 == 0) {
            this.sharingLabel.setText(this.STATS_SHARING_STRING + " " + String.valueOf(n) + " " + this.STATS_FILE_STRING);
        } else {
            this.sharingLabel.setText(this.STATS_SHARING_STRING + " " + String.valueOf(n) + " / " + String.valueOf(n2 + n) + " " + this.STATS_FILE_STRING);
        }
        if (n == 0) {
            Color color = ThemeFileHandler.NOT_SHARING_LABEL_COLOR.getValue();
            this.sharingLabel.setForeground(color);
        } else {
            this.sharingLabel.setForeground((Color)UIManager.get("Label.foreground"));
        }
        return string;
    }

    public void audioFileDoubleClicked() {
        MediaPlayerComponent.audioFileDoubleClicked();
    }

    public void launchAudio(File file) {
        MediaPlayerComponent.launchAudio(file);
    }

    public JComponent getComponent() {
        return this.PANEL;
    }
}

