/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.plaf.metal.MetalLabelUI;

final class StatusLinkHandler {
    private final LabelURLPair[] LABEL_URLS = new LabelURLPair[]{new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_01"), "http://www.limewire.com/index.jsp/pro&11"), new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_02"), "http://www.limewire.com/index.jsp/pro&12"), new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_03"), "http://www.limewire.com/index.jsp/pro&13"), new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_04"), "http://www.limewire.com/index.jsp/pro&14"), new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_05"), "http://www.limewire.com/index.jsp/pro&15"), new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_06"), "http://www.limewire.com/index.jsp/pro&16"), new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_07"), "http://www.limewire.com/index.jsp/pro&17"), new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_08"), "http://www.limewire.com/index.jsp/pro&18"), new LabelURLPair(GUIMediator.getStringResource("SUPPORT_LIMEWIRE_09"), "http://www.limewire.com/index.jsp/pro&19")};
    private int _curLabelIndex = 0;
    private final JLabel LABEL = new JLabel("", 0);

    StatusLinkHandler() {
        this.LABEL.setUI(new LinkLabelUI());
        FontMetrics fontMetrics = ((Component)this.LABEL).getFontMetrics(this.LABEL.getFont());
        int n = fontMetrics.stringWidth("123456789/123456789/1");
        if (this.LABEL_URLS != null) {
            int n2 = this.LABEL_URLS.length;
            while (--n2 >= 0) {
                n = Math.max(n, fontMetrics.stringWidth(this.LABEL_URLS[n2].getLabel()));
            }
        }
        Dimension dimension = new Dimension(n, fontMetrics.getHeight());
        this.LABEL.setForeground(Color.blue);
        this.LABEL.setPreferredSize(dimension);
        this.LABEL.setMaximumSize(dimension);
        this.LABEL.setText(this.getNextLabelURLPair().getLabel());
        this.LABEL.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                StatusLinkHandler.this.handleLinkClick();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }

            public void mouseExited(MouseEvent mouseEvent) {
                mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        });
        if (this.LABEL_URLS.length > 1) {
            new Timer(30000, new LabelTimerListener()).start();
        }
    }

    Component getComponent() {
        return this.LABEL;
    }

    private LabelURLPair getNextLabelURLPair() {
        if (this._curLabelIndex == this.LABEL_URLS.length - 1) {
            this._curLabelIndex = -1;
        }
        ++this._curLabelIndex;
        return this.LABEL_URLS[this._curLabelIndex];
    }

    private void handleLinkChange() {
        this.LABEL.setText(this.getNextLabelURLPair().getLabel());
    }

    private void handleLinkClick() {
        try {
            GUIMediator.openURL(this.LABEL_URLS[this._curLabelIndex].getURL());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class LinkLabelUI
    extends MetalLabelUI {
        private LinkLabelUI() {
        }

        protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
            super.paintEnabledText(jLabel, graphics, string, n, n2);
            if (StatusLinkHandler.this.LABEL.getText() == null) {
                return;
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.fillRect(n, fontMetrics.getAscent() + 2, fontMetrics.stringWidth(StatusLinkHandler.this.LABEL.getText()) - ((StatusLinkHandler)StatusLinkHandler.this).LABEL.getInsets().right, 1);
        }
    }

    private static final class LabelURLPair {
        private final String LABEL_STRING;
        private final String URL;

        private LabelURLPair(String string, String string2) {
            this.LABEL_STRING = string;
            this.URL = string2;
        }

        private String getLabel() {
            return this.LABEL_STRING;
        }

        private String getURL() {
            return this.URL;
        }
    }

    private class LabelTimerListener
    implements ActionListener {
        private LabelTimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StatusLinkHandler.this.handleLinkChange();
        }
    }
}

