/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.MonitorView;
import com.limegroup.gnutella.gui.PasswordDialog;
import com.limegroup.gnutella.gui.chat.ChatUIManager;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.tables.ComponentMediator;
import com.limegroup.gnutella.security.User;
import com.limegroup.gnutella.update.gui.UpdateCallback;
import com.sun.java.util.collections.Vector;
import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;

public final class VisualConnectionCallback
implements ActivityCallback {
    private final GUIMediator MEDIATOR = GUIMediator.instance();
    private final String ENGLISH_MESSGE = "LimeWire has detected a new version on the network. Please update to version ";
    private final HandleQueryString HANDLE_QUERY_STRING = new HandleQueryString();
    private final SearchMediator SEARCH_MEDIATOR;
    private final ComponentMediator DOWNLOAD_MEDIATOR;
    private final MonitorView MONITOR_VIEW;
    private final ComponentMediator UPLOAD_MEDIATOR;
    private final ComponentMediator CONNECTION_MEDIATOR;
    private final LibraryMediator LIBRARY_MEDIATOR;

    VisualConnectionCallback() {
        MainFrame mainFrame = this.MEDIATOR.getMainFrame();
        this.SEARCH_MEDIATOR = mainFrame.getSearchMediator();
        this.DOWNLOAD_MEDIATOR = mainFrame.getDownloadMediator();
        this.MONITOR_VIEW = mainFrame.getMonitorView();
        this.UPLOAD_MEDIATOR = mainFrame.getUploadMediator();
        this.CONNECTION_MEDIATOR = mainFrame.getConnectionMediator();
        this.LIBRARY_MEDIATOR = mainFrame.getLibraryMediator();
    }

    public void connectionInitializing(Connection connection) {
        ConnectionInitializing connectionInitializing = new ConnectionInitializing(connection);
        SwingUtilities.invokeLater(connectionInitializing);
    }

    public void connectionInitialized(Connection connection) {
        ConnectionInitialized connectionInitialized = new ConnectionInitialized(connection);
        SwingUtilities.invokeLater(connectionInitialized);
    }

    public void connectionClosed(Connection connection) {
        ConnectionClosed connectionClosed = new ConnectionClosed(connection);
        SwingUtilities.invokeLater(connectionClosed);
    }

    public void knownHost(Endpoint endpoint) {
        KnownHost knownHost = new KnownHost(endpoint);
        SwingUtilities.invokeLater(knownHost);
    }

    public void handleQueryReply(QueryReply queryReply) {
        SearchMediator.handleQueryResult(queryReply);
    }

    public void handleQueryString(String string) {
        this.HANDLE_QUERY_STRING.addQueryString(string);
    }

    public void addSharedDirectory(final File file, final File file2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    VisualConnectionCallback.this.LIBRARY_MEDIATOR.addSharedDirectory(file, file2);
                }
                catch (Throwable throwable) {
                    GUIMediator.showInternalError(throwable);
                }
            }
        });
    }

    public void addSharedFile(final FileDesc fileDesc, final File file) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    VisualConnectionCallback.this.LIBRARY_MEDIATOR.addSharedFile(fileDesc, file);
                }
                catch (Throwable throwable) {
                    GUIMediator.showInternalError(throwable);
                }
            }
        });
    }

    public void handleSharedFileUpdate(File file) {
        this.LIBRARY_MEDIATOR.updateSharedFile(file);
    }

    public void clearSharedFiles() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    VisualConnectionCallback.this.LIBRARY_MEDIATOR.clearLibrary();
                }
                catch (Throwable throwable) {
                    GUIMediator.showInternalError(throwable);
                }
            }
        });
    }

    public void setAnnotateEnabled(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    VisualConnectionCallback.this.LIBRARY_MEDIATOR.setAnnotateEnabled(bl);
                }
                catch (Throwable throwable) {
                    GUIMediator.showInternalError(throwable);
                }
            }
        });
    }

    public void error(int n) {
        Error error = new Error(n, null);
        SwingUtilities.invokeLater(error);
    }

    public void error(int n, Throwable throwable) {
        Error error = new Error(n, throwable);
        SwingUtilities.invokeLater(error);
    }

    public void error(Throwable throwable) {
        Error error = new Error(throwable);
        SwingUtilities.invokeLater(error);
    }

    public void addDownload(Downloader downloader) {
        AddDownload addDownload = new AddDownload(downloader);
        SwingUtilities.invokeLater(addDownload);
    }

    public void removeDownload(Downloader downloader) {
        RemoveDownload removeDownload = new RemoveDownload(downloader);
        SwingUtilities.invokeLater(removeDownload);
    }

    public void downloadsComplete() {
        Finalizer.setDownloadsComplete();
    }

    public void addUpload(Uploader uploader) {
        AddUpload addUpload = new AddUpload(uploader);
        SwingUtilities.invokeLater(addUpload);
    }

    public void removeUpload(Uploader uploader) {
        RemoveUpload removeUpload = new RemoveUpload(uploader);
        SwingUtilities.invokeLater(removeUpload);
    }

    public void uploadsComplete() {
        Finalizer.setUploadsComplete();
    }

    public void notifyUserAboutUpdate(String string, boolean bl, boolean bl2) {
        String string2 = bl2 ? GUIMediator.getStringResource("UPDATE_MESSAGE") + " " + string : "LimeWire has detected a new version on the network. Please update to version " + string;
        boolean bl3 = UpdateCallback.showUpdatePromptWithParentFrame(string2);
        if (bl3) {
            String string3 = bl ? "http://www.limewire.com/index.jsp/update" : "http://www.limewire.com/index.jsp/download";
            try {
                GUIMediator.openURL(string3);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void acceptChat(final Chatter chatter) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ChatUIManager.instance().acceptChat(chatter);
                }
                catch (Throwable throwable) {
                    GUIMediator.showInternalError(throwable);
                }
            }
        });
    }

    public void receiveMessage(final Chatter chatter) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ChatUIManager.instance().recieveMessage(chatter);
                }
                catch (Throwable throwable) {
                    GUIMediator.showInternalError(throwable);
                }
            }
        });
    }

    public void chatUnavailable(final Chatter chatter) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ChatUIManager.instance().chatUnavailable(chatter);
                }
                catch (Throwable throwable) {
                    GUIMediator.showInternalError(throwable);
                }
            }
        });
    }

    public void chatErrorMessage(final Chatter chatter, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ChatUIManager.instance().chatErrorMessage(chatter, string);
                }
                catch (Throwable throwable) {
                    GUIMediator.showInternalError(throwable);
                }
            }
        });
    }

    public void browseHostFailed(final GUID gUID) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchMediator.browseHostFailed(gUID);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User getUserAuthenticationInfo(String string) {
        Object object = new Object();
        PasswordDialogRunnable passwordDialogRunnable = new PasswordDialogRunnable(string, object);
        SwingUtilities.invokeLater(passwordDialogRunnable);
        Object object2 = object;
        synchronized (object2) {
            while (passwordDialogRunnable.notFinished()) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return passwordDialogRunnable.getUser();
        }
    }

    public void promptAboutCorruptDownload(Downloader downloader) {
        final Downloader downloader2 = downloader;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = GUIMediator.showYesNoMessage("MESSAGE_FILE_CORRUPT", downloader2.getFileName(), "MESSAGE_CONTINUE_DOWNLOAD");
                if (n == 101) {
                    downloader2.discardCorruptDownload(false);
                } else if (n == 102) {
                    downloader2.discardCorruptDownload(true);
                }
            }
        });
    }

    public String getHostValue(String string) {
        return GUIMediator.getStringResource(string);
    }

    private class Error
    implements Runnable {
        private final int messageType;
        private final Throwable problem;

        public Error(int n, Throwable throwable) {
            this.messageType = n;
            this.problem = throwable;
        }

        private Error(Throwable throwable) {
            this.messageType = 12;
            this.problem = throwable;
        }

        public void run() {
            String string = null;
            switch (this.messageType) {
                case 10: {
                    string = "ERROR_PORT";
                    break;
                }
                case 11: {
                    string = "ERROR_INCOMING_CONNECTIONS";
                    break;
                }
                case 12: {
                    string = "ERROR_INTERNAL";
                    break;
                }
                default: {
                    string = "ERROR_INTERNAL";
                }
            }
            if (this.problem == null) {
                VisualConnectionCallback.this.MEDIATOR;
                GUIMediator.showError(string);
            } else {
                VisualConnectionCallback.this.MEDIATOR;
                GUIMediator.showInternalError(string, this.problem);
            }
        }
    }

    private class PasswordDialogRunnable
    implements Runnable {
        private String _title;
        private Object _lock;
        private volatile boolean _notFinished = true;
        private PasswordDialog _passwordDialog;
        private volatile boolean _cancelled = false;

        public PasswordDialogRunnable(String string, Object object) {
            this._title = string;
            this._lock = object;
            this._passwordDialog = new PasswordDialog(string);
        }

        public void run() {
            try {
                int n = VisualConnectionCallback.this.MEDIATOR.showPasswordDialog(this._passwordDialog);
                if (n == 78) {
                    this._cancelled = true;
                }
                Object object = this._lock;
                synchronized (object) {
                    this._notFinished = false;
                    this._lock.notifyAll();
                }
            }
            catch (Throwable throwable) {
                GUIMediator.showInternalError(throwable);
            }
        }

        public boolean notFinished() {
            return this._notFinished;
        }

        public User getUser() {
            if (this._cancelled) {
                return new User("", "");
            }
            return new User(this._passwordDialog.getUsername(), this._passwordDialog.getPassword());
        }
    }

    private class RemoveUpload
    implements Runnable {
        private Uploader mgr;

        public RemoveUpload(Uploader uploader) {
            this.mgr = uploader;
        }

        public void run() {
            try {
                VisualConnectionCallback.this.UPLOAD_MEDIATOR.remove(this.mgr);
            }
            catch (Throwable throwable) {
                GUIMediator.showInternalError(throwable);
            }
        }
    }

    private class AddUpload
    implements Runnable {
        private Uploader up;

        public AddUpload(Uploader uploader) {
            this.up = uploader;
        }

        public void run() {
            try {
                VisualConnectionCallback.this.UPLOAD_MEDIATOR.add(this.up);
            }
            catch (Throwable throwable) {
                GUIMediator.showInternalError(throwable);
            }
        }
    }

    private class RemoveDownload
    implements Runnable {
        private Downloader mgr;

        public RemoveDownload(Downloader downloader) {
            this.mgr = downloader;
        }

        public void run() {
            try {
                VisualConnectionCallback.this.DOWNLOAD_MEDIATOR.remove(this.mgr);
            }
            catch (Throwable throwable) {
                GUIMediator.showInternalError(throwable);
            }
        }
    }

    private class AddDownload
    implements Runnable {
        private Downloader mgr;

        public AddDownload(Downloader downloader) {
            this.mgr = downloader;
        }

        public void run() {
            try {
                VisualConnectionCallback.this.DOWNLOAD_MEDIATOR.add(this.mgr);
            }
            catch (Throwable throwable) {
                GUIMediator.showInternalError(throwable);
            }
        }
    }

    private class HandleQueryString
    implements Runnable {
        private Vector list = new Vector();
        private boolean active = false;

        public void addQueryString(String string) {
            this.list.add(string);
            if (!this.active) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            try {
                while (this.list.size() > 0) {
                    String string = (String)this.list.elementAt(0);
                    this.list.remove(0);
                    VisualConnectionCallback.this.MONITOR_VIEW.handleQueryString(string);
                }
                this.active = false;
            }
            catch (Throwable throwable) {
                GUIMediator.showInternalError(throwable);
            }
        }
    }

    private class KnownHost
    implements Runnable {
        private Endpoint e;

        public KnownHost(Endpoint endpoint) {
            this.e = endpoint;
        }

        public void run() {
        }
    }

    private class ConnectionClosed
    implements Runnable {
        private Connection c;

        public ConnectionClosed(Connection connection) {
            this.c = connection;
        }

        public void run() {
            try {
                VisualConnectionCallback.this.CONNECTION_MEDIATOR.remove(this.c);
            }
            catch (Throwable throwable) {
                GUIMediator.showInternalError(throwable);
            }
        }
    }

    private class ConnectionInitialized
    implements Runnable {
        private Connection c;

        public ConnectionInitialized(Connection connection) {
            this.c = connection;
        }

        public void run() {
            try {
                VisualConnectionCallback.this.CONNECTION_MEDIATOR.update(this.c);
            }
            catch (Throwable throwable) {
                GUIMediator.showInternalError(throwable);
            }
        }
    }

    private class ConnectionInitializing
    implements Runnable {
        private Connection c;

        public ConnectionInitializing(Connection connection) {
            this.c = connection;
        }

        public void run() {
            try {
                VisualConnectionCallback.this.CONNECTION_MEDIATOR.add(this.c);
            }
            catch (Throwable throwable) {
                GUIMediator.showInternalError(throwable);
            }
        }
    }
}

