/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.chat;

import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.chat.ChatUIManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ChatFrame
extends JFrame
implements ThemeObserver {
    private final String BLOCK_BUTTON_LABEL = "CHAT_BLOCK_BUTTON_LABEL";
    private final String SEND_BUTTON_LABEL = "CHAT_SEND_BUTTON_LABEL";
    private final String STOP_BUTTON_LABEL = "CHAT_STOP_BUTTON_LABEL";
    private final String BLOCK_BUTTON_TIP = "CHAT_BLOCK_BUTTON_TIP";
    private final String SEND_BUTTON_TIP = "CHAT_SEND_BUTTON_TIP";
    private final String STOP_BUTTON_TIP = "CHAT_STOP_BUTTON_TIP";
    private final String WITH_LABEL = "CHAT_WITH_LABEL";
    private final String UNAVAILABLE_LABEL = "CHAT_HOST_UNAVAILABLE";
    private final String YOU_LABEL = "CHAT_YOU";
    private final int WINDOW_WIDTH = 500;
    private final int WINDOW_HEIGHT = 300;
    private boolean _connected = true;
    JTextArea _area;
    JTextField _field;
    JTextField _connectField;
    Chatter _chat;

    public ChatFrame(Chatter chatter) {
        this.setTitle(GUIMediator.getStringResource("CHAT_WITH_LABEL") + " " + chatter.getHost());
        ((Component)this).setSize(500, 300);
        this._chat = chatter;
        JFrame jFrame = GUIMediator.getAppFrame();
        int n = jFrame.getSize().width / 2;
        int n2 = jFrame.getSize().height / 2;
        int n3 = this.getSize().width / 2;
        int n4 = this.getSize().height / 2;
        int n5 = n - n3;
        int n6 = n2 - n4;
        int n7 = jFrame.getLocation().x;
        int n8 = jFrame.getLocation().y;
        ((Component)this).setLocation(n7 + n5, n8 + n6);
        EndListener endListener = new EndListener();
        SendListener sendListener = new SendListener();
        BlockListener blockListener = new BlockListener();
        String[] stringArray = new String[]{"CHAT_SEND_BUTTON_LABEL", "CHAT_STOP_BUTTON_LABEL", "CHAT_BLOCK_BUTTON_LABEL"};
        String[] stringArray2 = new String[]{"CHAT_SEND_BUTTON_TIP", "CHAT_STOP_BUTTON_TIP", "CHAT_BLOCK_BUTTON_TIP"};
        ActionListener[] actionListenerArray = new ActionListener[]{sendListener, endListener, blockListener};
        ButtonRow buttonRow = new ButtonRow(stringArray, stringArray2, actionListenerArray, 0, 14);
        TextPanel textPanel = new TextPanel();
        BoxPanel boxPanel = new BoxPanel(1);
        PaddedPanel paddedPanel = new PaddedPanel();
        paddedPanel.setPreferredSize(new Dimension(1000, 1000));
        paddedPanel.add(textPanel);
        boxPanel.add(paddedPanel);
        boxPanel.add(Box.createVerticalStrut(10));
        boxPanel.add(buttonRow);
        this.getContentPane().add(boxPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ChatFrame.this._chat.stop();
            }
        });
        this.updateTheme();
    }

    public void updateTheme() {
        ImageIcon imageIcon = GUIMediator.getThemeImage("plug.gif");
        ((Frame)this).setIconImage(imageIcon.getImage());
    }

    public void addResponse(String string) {
        String string2 = this._chat.getHost();
        this._area.setText(this._area.getText() + string2 + ": " + string + "\n");
    }

    public void setChat(Chatter chatter) {
        this._chat = chatter;
    }

    public void chatUnavailable() {
        this._area.setForeground(Color.red);
        this._area.setText(this._area.getText() + GUIMediator.getStringResource("CHAT_HOST_UNAVAILABLE") + "\n");
        this._connected = false;
    }

    public void displayErrorMessage(String string) {
        this._area.setForeground(Color.red);
        this._area.setText(string);
    }

    private void send() {
        if (!this._connected) {
            return;
        }
        String string = this._field.getText();
        this._field.setText("");
        this._area.setText(this._area.getText() + GUIMediator.getStringResource("CHAT_YOU") + ": " + string + "\n");
        try {
            this._chat.send(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ReturnKeyListener
    implements KeyListener {
        private ReturnKeyListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() != '\n') {
                return;
            }
            ChatFrame.this.send();
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    private class BlockListener
    implements ActionListener {
        private BlockListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ChatFrame.this._chat.getHost();
            ChatFrame.this._chat.blockHost(string);
            ChatFrame.this._chat.stop();
        }
    }

    private class SendListener
    implements ActionListener {
        private SendListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ChatFrame.this.send();
        }
    }

    private class EndListener
    implements ActionListener {
        private EndListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ChatFrame.this._chat.stop();
            ChatUIManager.instance().removeChat(ChatFrame.this._chat);
        }
    }

    private class TextPanel
    extends JPanel {
        public TextPanel() {
            this.setLayout(new BoxLayout(this, 1));
            BoxPanel boxPanel = new BoxPanel(0);
            ChatFrame.this._area = new JTextArea();
            ChatFrame.this._area.setLineWrap(true);
            ChatFrame.this._field = new JTextField();
            JScrollPane jScrollPane = new JScrollPane(ChatFrame.this._area);
            ChatFrame.this._area.setEditable(false);
            ChatFrame.this._field.addKeyListener(new ReturnKeyListener());
            boxPanel.add(Box.createHorizontalStrut(6));
            boxPanel.add(ChatFrame.this._field);
            boxPanel.add(Box.createHorizontalStrut(6));
            boxPanel.setPreferredSize(new Dimension(1000, 20));
            boxPanel.setMaximumSize(new Dimension(1000, 20));
            this.add(jScrollPane);
            this.add(Box.createVerticalStrut(6));
            this.add(boxPanel);
        }
    }
}

