/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.chat;

import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.gui.chat.ChatFrame;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.awt.Component;

public final class ChatUIManager {
    private static final ChatUIManager INSTANCE = new ChatUIManager();
    private Map _chats = Collections.synchronizedMap(new HashMap());

    private ChatUIManager() {
    }

    public static ChatUIManager instance() {
        return INSTANCE;
    }

    public void acceptChat(Chatter chatter) {
        ChatFrame chatFrame = new ChatFrame(chatter);
        ((Component)chatFrame).setVisible(true);
        this._chats.put(chatter, chatFrame);
    }

    public void removeChat(Chatter chatter) {
        ChatFrame chatFrame = null;
        try {
            chatFrame = (ChatFrame)this._chats.remove(chatter);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (chatFrame != null) {
            chatFrame.dispose();
            ((Component)chatFrame).setVisible(false);
        }
    }

    public void recieveMessage(Chatter chatter) {
        try {
            ChatFrame chatFrame = (ChatFrame)this._chats.get(chatter);
            chatFrame.addResponse(chatter.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void chatUnavailable(Chatter chatter) {
        try {
            ChatFrame chatFrame = (ChatFrame)this._chats.get(chatter);
            chatFrame.chatUnavailable();
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void chatErrorMessage(Chatter chatter, String string) {
        try {
            ChatFrame chatFrame = (ChatFrame)this._chats.get(chatter);
            chatFrame.displayErrorMessage(string);
        }
        catch (ClassCastException classCastException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

