/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.connection;

import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.connection.BandwidthHolder;
import com.limegroup.gnutella.gui.connection.DroppedHolder;
import com.limegroup.gnutella.gui.connection.HostsHolder;
import com.limegroup.gnutella.gui.connection.MessagesHolder;
import com.limegroup.gnutella.gui.connection.ProtocolHolder;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.TimeRemainingHolder;
import com.limegroup.gnutella.util.CommonUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public final class ConnectionDataLine
extends AbstractDataLine {
    static final int HOST_COL = 0;
    static final String HOST_NAME = GUIMediator.getStringResource("CV_COLUMN_HOST");
    static final int STATUS_COL = 1;
    static final String STATUS_NAME = GUIMediator.getStringResource("CV_COLUMN_STATUS");
    static final int MESSAGES_COL = 2;
    static final String MESSAGES_NAME = GUIMediator.getStringResource("CV_COLUMN_MESSAGE");
    static final int BANDWIDTH_COL = 3;
    static final String BANDWIDTH_NAME = GUIMediator.getStringResource("CV_COLUMN_BANDWIDTH");
    static final int DROPPED_COL = 4;
    static final String DROPPED_NAME = GUIMediator.getStringResource("CV_COLUMN_DROPPED");
    static final int HOSTS_COL = 5;
    static final String HOSTS_NAME = GUIMediator.getStringResource("CV_COLUMN_HOSTS");
    static final int PROTOCOL_COL = 6;
    static final String PROTOCOL_NAME = GUIMediator.getStringResource("CV_COLUMN_PROTOCOL");
    static final int VENDOR_COL = 7;
    static final String VENDOR_NAME = GUIMediator.getStringResource("CV_COLUMN_VENDOR");
    static final int TIME_COL = 8;
    static final String TIME_NAME = GUIMediator.getStringResource("CV_COLUMN_TIME");
    static final int NUMBER_OF_COLUMNS = 9;
    private ManagedConnection MCONNECTION;
    private final String CONNECTING_STRING = GUIMediator.getStringResource("CV_TABLE_STRING_CONNECTING");
    private final String OUTGOING_STRING = GUIMediator.getStringResource("CV_TABLE_STRING_OUTGOING");
    private final String INCOMING_STRING = GUIMediator.getStringResource("CV_TABLE_STRING_INCOMING");
    private final String CONNECTED_ON = GUIMediator.getStringResource("CV_TABLE_STRING_CONNECTED_ON");
    private volatile String _host;
    private String _status;
    private long _time;
    private boolean _isConnecting = true;
    private volatile boolean _hasResolvedAddress = false;
    private static final boolean IS_NS_LOOKUP_OS = CommonUtils.isWindows() || CommonUtils.isMacOSX() || CommonUtils.isLinux();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$connection$MessagesHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$connection$BandwidthHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$connection$DroppedHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$connection$HostsHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$connection$ProtocolHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder;

    public int getColumnCount() {
        return 9;
    }

    public void initialize(Object object) {
        super.initialize(object);
        this.MCONNECTION = (ManagedConnection)object;
        if (this.MCONNECTION.isOutgoing()) {
            String string = this.MCONNECTION.getOrigHost();
            if (string.equals(SettingsManager.DEDICATED_LIMEWIRE_ROUTER)) {
                string = "router.limewire.com";
            }
            this._host = string;
        } else {
            this._host = this.MCONNECTION.getOrigHost();
        }
        this._status = this.CONNECTING_STRING;
        this._time = System.currentTimeMillis();
    }

    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                if (!this._hasResolvedAddress && IS_NS_LOOKUP_OS && (System.currentTimeMillis() - this._time) / 1000L > 10L) {
                    this.assignHostName();
                }
                return this._host;
            }
            case 1: {
                return this._status;
            }
            case 2: {
                if (this._isConnecting) {
                    return null;
                }
                return new MessagesHolder(this.MCONNECTION.getNumMessagesReceived(), this.MCONNECTION.getNumMessagesSent());
            }
            case 3: {
                if (this._isConnecting) {
                    return null;
                }
                return new BandwidthHolder(this.MCONNECTION.getMeasuredDownstreamBandwidth(), this.MCONNECTION.getMeasuredUpstreamBandwidth());
            }
            case 4: {
                if (this._isConnecting) {
                    return null;
                }
                return new DroppedHolder((float)this.MCONNECTION.getNumReceivedMessagesDropped() / ((float)this.MCONNECTION.getNumMessagesReceived() + 1.0f), (float)this.MCONNECTION.getNumSentMessagesDropped() / ((float)this.MCONNECTION.getNumMessagesSent() + 1.0f));
            }
            case 5: {
                if (this._isConnecting) {
                    return null;
                }
                return new HostsHolder(this.MCONNECTION.isClientSupernodeConnection() ? -1L : this.MCONNECTION.getNumHosts());
            }
            case 6: {
                return new ProtocolHolder(this.MCONNECTION);
            }
            case 7: {
                if (this._isConnecting) {
                    return null;
                }
                String string = this.MCONNECTION.getUserAgent();
                return string == null ? "" : string;
            }
            case 8: {
                return new TimeRemainingHolder((int)((System.currentTimeMillis() - this._time) / 1000L));
            }
        }
        return null;
    }

    private void assignHostName() {
        Thread thread = new Thread("host discovery thread"){

            public void run() {
                try {
                    ConnectionDataLine.this._host = InetAddress.getByName(ConnectionDataLine.this._host).getHostName();
                    ConnectionDataLine.this._hasResolvedAddress = true;
                }
                catch (UnknownHostException unknownHostException) {
                    ConnectionDataLine.this._hasResolvedAddress = false;
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return HOST_NAME;
            }
            case 1: {
                return STATUS_NAME;
            }
            case 2: {
                return MESSAGES_NAME;
            }
            case 3: {
                return BANDWIDTH_NAME;
            }
            case 4: {
                return DROPPED_NAME;
            }
            case 5: {
                return HOSTS_NAME;
            }
            case 6: {
                return PROTOCOL_NAME;
            }
            case 7: {
                return VENDOR_NAME;
            }
            case 8: {
                return TIME_NAME;
            }
        }
        return null;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return class$java$lang$String == null ? (class$java$lang$String = ConnectionDataLine.class$("java.lang.String")) : class$java$lang$String;
            }
            case 1: {
                return class$java$lang$String == null ? (class$java$lang$String = ConnectionDataLine.class$("java.lang.String")) : class$java$lang$String;
            }
            case 2: {
                return class$com$limegroup$gnutella$gui$connection$MessagesHolder == null ? (class$com$limegroup$gnutella$gui$connection$MessagesHolder = ConnectionDataLine.class$("com.limegroup.gnutella.gui.connection.MessagesHolder")) : class$com$limegroup$gnutella$gui$connection$MessagesHolder;
            }
            case 3: {
                return class$com$limegroup$gnutella$gui$connection$BandwidthHolder == null ? (class$com$limegroup$gnutella$gui$connection$BandwidthHolder = ConnectionDataLine.class$("com.limegroup.gnutella.gui.connection.BandwidthHolder")) : class$com$limegroup$gnutella$gui$connection$BandwidthHolder;
            }
            case 4: {
                return class$com$limegroup$gnutella$gui$connection$DroppedHolder == null ? (class$com$limegroup$gnutella$gui$connection$DroppedHolder = ConnectionDataLine.class$("com.limegroup.gnutella.gui.connection.DroppedHolder")) : class$com$limegroup$gnutella$gui$connection$DroppedHolder;
            }
            case 5: {
                return class$com$limegroup$gnutella$gui$connection$HostsHolder == null ? (class$com$limegroup$gnutella$gui$connection$HostsHolder = ConnectionDataLine.class$("com.limegroup.gnutella.gui.connection.HostsHolder")) : class$com$limegroup$gnutella$gui$connection$HostsHolder;
            }
            case 6: {
                return class$com$limegroup$gnutella$gui$connection$ProtocolHolder == null ? (class$com$limegroup$gnutella$gui$connection$ProtocolHolder = ConnectionDataLine.class$("com.limegroup.gnutella.gui.connection.ProtocolHolder")) : class$com$limegroup$gnutella$gui$connection$ProtocolHolder;
            }
            case 7: {
                return class$java$lang$String == null ? (class$java$lang$String = ConnectionDataLine.class$("java.lang.String")) : class$java$lang$String;
            }
            case 8: {
                return class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder == null ? (class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder = ConnectionDataLine.class$("com.limegroup.gnutella.gui.tables.TimeRemainingHolder")) : class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder;
            }
        }
        return null;
    }

    public boolean isDynamic(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public void update() {
        this._isConnecting = false;
        String string = this._status = this.MCONNECTION.isOutgoing() ? this.OUTGOING_STRING : this.INCOMING_STRING;
        if (!this._host.startsWith("router.limewire.com")) {
            this._host = this.MCONNECTION.isOutgoing() ? this.MCONNECTION.getInetAddress().getHostAddress() : this.MCONNECTION.getInetAddress().getHostAddress();
        }
        this._time = System.currentTimeMillis();
    }

    public String[] getToolTipArray() {
        Properties properties = this.MCONNECTION.getHeaders();
        if (properties == null) {
            return null;
        }
        String[] stringArray = new String[((Hashtable)properties).size() + 2];
        stringArray[0] = this.CONNECTED_ON + GUIUtils.msec2DateTime(this._time);
        stringArray[1] = "";
        Enumeration<?> enumeration = properties.propertyNames();
        int n = 2;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringArray[n] = string + ": " + properties.getProperty(string);
            ++n;
        }
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

