/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.connection;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadConnectionSettingException;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.connection.ConnectionButtons;
import com.limegroup.gnutella.gui.connection.ConnectionModel;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.sun.java.util.collections.Arrays;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;

public final class ConnectionMediator
extends AbstractTableMediator {
    private static final ConnectionMediator INSTANCE = new ConnectionMediator();
    ActionListener ADD_LISTENER;
    DocumentListener KEEP_ALIVE_LISTENER;
    private static final String IS_ULTRAPEER = GUIMediator.getStringResource("CV_STRING_ULTRAPEER");
    private static final String IS_LEAF = GUIMediator.getStringResource("CV_STRING_CLIENT");
    private JTextField HOST_INPUT;
    private JTextField PORT_INPUT;
    private JTextField MIN_CONNECTIONS_INPUT;
    private JLabel SERVENT_STATUS;
    private boolean disableKeepAliveValidate;

    public static ConnectionMediator instance() {
        return INSTANCE;
    }

    protected void buildListeners() {
        super.buildListeners();
        this.ADD_LISTENER = new AddListener();
        this.KEEP_ALIVE_LISTENER = new KeepAliveListener();
    }

    protected void addListeners() {
        super.addListeners();
        this.HOST_INPUT.addActionListener(this.ADD_LISTENER);
        this.MIN_CONNECTIONS_INPUT.getDocument().addDocumentListener(this.KEEP_ALIVE_LISTENER);
    }

    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(GUIMediator.getStringResource("CV_PANEL_TITLE"));
        this.DATA_MODEL = new ConnectionModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.BUTTON_ROW = new ConnectionButtons(this).getComponent();
        this.HOST_INPUT = new JTextField(20);
        this.PORT_INPUT = new WholeNumberField(6346, 4);
        this.SERVENT_STATUS = new JLabel("");
        this.MIN_CONNECTIONS_INPUT = new WholeNumberField(0, 2);
    }

    protected Component getScrolledTablePane() {
        Component component = super.getScrolledTablePane();
        this.SCROLL_PANE.setPreferredSize(new Dimension(3000, 5000));
        return component;
    }

    protected void setPreferredWidths() {
        TableColumnModel tableColumnModel = this.TABLE.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(100);
        tableColumnModel.getColumn(1).setPreferredWidth(45);
        tableColumnModel.getColumn(5).setPreferredWidth(15);
    }

    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_CONNECTION_WINDOW"));
    }

    protected void setupMainPanel() {
        if (this.MAIN_PANEL != null) {
            this.MAIN_PANEL.add(this.getScrolledTablePane());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout());
            jPanel.add(this.BUTTON_ROW);
            jPanel.add(this.HOST_INPUT);
            jPanel.add(this.PORT_INPUT);
            this.MAIN_PANEL.add(jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout());
            jPanel2.add(this.SERVENT_STATUS);
            jPanel2.add(new JLabel(GUIMediator.getStringResource("CV_LABEL_KEEP_BEGIN") + " "));
            jPanel2.add(this.MIN_CONNECTIONS_INPUT);
            this.setKeepAliveText(Integer.toString(AbstractTableMediator.SETTINGS.getKeepAlive()));
            jPanel2.add(new JLabel(" " + GUIMediator.getStringResource("CV_LABEL_KEEP_END")));
            this.MAIN_PANEL.add(jPanel2);
            this.MAIN_PANEL.setMinimumSize(AbstractTableMediator.ZERO_DIMENSION);
        }
    }

    private ConnectionMediator() {
        GUIMediator.addRefreshListener(this);
    }

    public void removeSelection() {
        int[] nArray = this.TABLE.getSelectedRows();
        Arrays.sort(nArray);
        int n = nArray.length - 1;
        while (n >= 0) {
            int n2 = nArray[n];
            ManagedConnection managedConnection = (ManagedConnection)this.DATA_MODEL.get(n2).getInitializeObject();
            GUIMediator.instance().getRouter();
            RouterService.removeConnection(managedConnection);
            --n;
        }
        this.clearSelection();
    }

    public void handleSelection(int n) {
        this.setButtonEnabled(0, true);
    }

    public void handleNoSelection() {
        this.setButtonEnabled(0, false);
    }

    public void handleMouseDoubleClick(Point point) {
    }

    public void refresh() {
        super.refresh();
        StringBuffer stringBuffer = new StringBuffer();
        GUIMediator.instance().getRouter();
        this.SERVENT_STATUS.setText(stringBuffer.append(RouterService.isSupernode() ? IS_ULTRAPEER : IS_LEAF).append("      ").toString());
    }

    public void processKeepAliveChange(JTextField jTextField) {
        String string = jTextField.getText();
        if (string == null || string.equals("") || this.disableKeepAliveValidate) {
            return;
        }
        int n = Integer.parseInt(string);
        if (jTextField == this.MIN_CONNECTIONS_INPUT) {
            try {
                GUIMediator.instance().getRouter();
                RouterService.setKeepAlive(n);
                AbstractTableMediator.SETTINGS.setKeepAlive(n);
            }
            catch (BadConnectionSettingException badConnectionSettingException) {
                int n2 = badConnectionSettingException.getReason();
                if (n2 == 2) {
                    this.showMessage("ERROR_KEEP_ALIVE");
                } else if (n2 == 4) {
                    this.showMessage("ERROR_TOO_LOW_FOR_ULTRAPEER");
                } else if (n2 == 3) {
                    this.showMessage("ERROR_TOO_HIGH_FOR_LEAF");
                }
                this.processKeepAliveSuggestion(jTextField, badConnectionSettingException);
            }
        } else {
            Assert.that(false, "Unknown connection property");
        }
    }

    private void processKeepAliveSuggestion(JTextField jTextField, BadConnectionSettingException badConnectionSettingException) {
        final int n = badConnectionSettingException.getSuggestedOutgoing();
        AbstractTableMediator.SETTINGS.setKeepAlive(n);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConnectionMediator.this.disableKeepAliveValidate = true;
                ConnectionMediator.this.MIN_CONNECTIONS_INPUT.setText(String.valueOf(n));
                ConnectionMediator.this.disableKeepAliveValidate = false;
            }
        });
        GUIMediator.instance().getRouter();
        RouterService.forceKeepAlive(n);
    }

    public void setKeepAliveText(String string) {
        this.disableKeepAliveValidate = true;
        this.MIN_CONNECTIONS_INPUT.setText(string);
        this.disableKeepAliveValidate = false;
    }

    private void tryConnection(String string, int n) {
        GUIMediator.instance().getRouter();
        RouterService.connectToHostAsynchronously(string, n);
    }

    public void clearConnections() {
        this.DATA_MODEL.clear();
        this.setKeepAliveText("0");
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.showError(string);
            }
        });
    }

    private final class KeepAliveListener
    implements DocumentListener {
        private KeepAliveListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            ConnectionMediator.this.processKeepAliveChange(this.source(documentEvent));
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            ConnectionMediator.this.processKeepAliveChange(this.source(documentEvent));
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private JTextField source(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            if (document == ConnectionMediator.this.MIN_CONNECTIONS_INPUT.getDocument()) {
                return ConnectionMediator.this.MIN_CONNECTIONS_INPUT;
            }
            Assert.that(false, "Unknown connection property");
            return null;
        }
    }

    private final class AddListener
    implements ActionListener {
        private AddListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ConnectionMediator.this.HOST_INPUT.getText();
            String string2 = ConnectionMediator.this.PORT_INPUT.getText();
            int n = -1;
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                n = 6346;
            }
            if (!string.equals("")) {
                ConnectionMediator.this.tryConnection(string, n);
            }
        }
    }
}

