/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.tables.TimeRemainingHolder;
import com.sun.java.util.collections.Iterator;

public final class DownloadDataLine
extends AbstractDataLine {
    private Downloader DOWNLOADER;
    private static final String QUEUED_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_QUEUED");
    private static final String CONNECTING_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_CONNECTING");
    private static final String WAITING_STATE_START = GUIMediator.getStringResource("DOWNLOAD_STATUS_WAITING_START");
    private static final String WAITING_STATE_MIDDLE = GUIMediator.getStringResource("DOWNLOAD_STATUS_WAITING_MIDDLE");
    private static final String WAITING_STATE_END = GUIMediator.getStringResource("DOWNLOAD_STATUS_WAITING_END");
    private static final String COMPLETE_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_COMPLETE");
    private static final String ABORTED_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_ABORTED");
    private static final String FAILED_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_FAILED");
    private static final String DOWNLOADING_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_DOWNLOADING");
    private static final String LIBRARY_MOVE_FAILED_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_LIBRARY_MOVE_FAILED");
    private static final String CORRUPT_FILE_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_CORRUPT_FILE");
    private static final String REQUERY_WAITING_STATE_START = GUIMediator.getStringResource("DOWNLOAD_STATUS_WAITING_FOR_REQUERY_START");
    private static final String REQUERY_WAITING_STATE_END = GUIMediator.getStringResource("DOWNLOAD_STATUS_WAITING_FOR_REQUERY_END");
    private static final String REMOTE_QUEUED_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_REMOTE_QUEUED");
    private static final String HASHING_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_HASHING");
    private static final String SAVING_STATE = GUIMediator.getStringResource("DOWNLOAD_STATUS_SAVING");
    private static final String AVERAGE_BANDWIDTH = GUIMediator.getStringResource("GENERAL_AVERAGE_BANDWIDTH");
    private static final String STARTED_ON = GUIMediator.getStringResource("GENERAL_STARTED_ON");
    private static final String FINISHED_ON = GUIMediator.getStringResource("GENERAL_FINISHED_ON");
    private static final String TIME_SPENT = GUIMediator.getStringResource("GENERAL_TIME_SPENT");
    private String _fileName;
    private String _status;
    private int _amountRead = 0;
    private int _progress;
    private boolean _chatEnabled;
    private boolean _browseEnabled;
    private int _size;
    private double _speed;
    private int _timeLeft;
    private long _startTime;
    private long _endTime;
    private int _state;
    static final int FILE_INDEX = 0;
    static final String FILE_NAME = GUIMediator.getStringResource("DOWNLOAD_NAME_COLUMN");
    static final int SIZE_INDEX = 1;
    static final String SIZE_NAME = GUIMediator.getStringResource("DOWNLOAD_SIZE_COLUMN");
    static final int STATUS_INDEX = 2;
    static final String STATUS_NAME = GUIMediator.getStringResource("DOWNLOAD_STATUS_COLUMN");
    static final int CHAT_INDEX = 3;
    static final String CHAT_NAME = GUIMediator.getStringResource("DOWNLOAD_CHAT_COLUMN");
    static final int PROGRESS_INDEX = 4;
    static final String PROGRESS_NAME = GUIMediator.getStringResource("DOWNLOAD_PROGRESS_COLUMN");
    static final int SPEED_INDEX = 5;
    static final String SPEED_NAME = GUIMediator.getStringResource("DOWNLOAD_SPEED_COLUMN");
    static final int TIME_INDEX = 6;
    static final String TIME_NAME = GUIMediator.getStringResource("DOWNLOAD_TIME_REMAINING_COLUMN");
    static final int NUMBER_OF_COLUMNS = 7;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$SizeHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$ChatHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$ProgressBarHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder;

    public int getColumnCount() {
        return 7;
    }

    public void initialize(Object object) {
        super.initialize(object);
        this.DOWNLOADER = (Downloader)object;
        this._startTime = System.currentTimeMillis();
        this._endTime = -1L;
        this._size = this.DOWNLOADER.getContentLength();
        this._fileName = this.DOWNLOADER.getFileName();
        if (this._fileName == null) {
            this._fileName = "";
        }
        this._status = "";
        this._chatEnabled = false;
        this._browseEnabled = false;
        this.update();
    }

    public void cleanup() {
        this.DOWNLOADER.stop();
    }

    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return this._fileName;
            }
            case 1: {
                return new SizeHolder(this._size);
            }
            case 2: {
                return this._status;
            }
            case 3: {
                return this._chatEnabled ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return new Integer(this._progress);
            }
            case 5: {
                return this._speed == -1.0 ? "" : GUIUtils.rate2speed(this._speed);
            }
            case 6: {
                return new TimeRemainingHolder(this._timeLeft);
            }
        }
        return null;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return FILE_NAME;
            }
            case 1: {
                return SIZE_NAME;
            }
            case 2: {
                return STATUS_NAME;
            }
            case 3: {
                return CHAT_NAME;
            }
            case 4: {
                return PROGRESS_NAME;
            }
            case 5: {
                return SPEED_NAME;
            }
            case 6: {
                return TIME_NAME;
            }
        }
        return null;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return class$java$lang$String == null ? (class$java$lang$String = DownloadDataLine.class$("java.lang.String")) : class$java$lang$String;
            }
            case 1: {
                return class$com$limegroup$gnutella$gui$tables$SizeHolder == null ? (class$com$limegroup$gnutella$gui$tables$SizeHolder = DownloadDataLine.class$("com.limegroup.gnutella.gui.tables.SizeHolder")) : class$com$limegroup$gnutella$gui$tables$SizeHolder;
            }
            case 2: {
                return class$java$lang$String == null ? (class$java$lang$String = DownloadDataLine.class$("java.lang.String")) : class$java$lang$String;
            }
            case 3: {
                return class$com$limegroup$gnutella$gui$tables$ChatHolder == null ? (class$com$limegroup$gnutella$gui$tables$ChatHolder = DownloadDataLine.class$("com.limegroup.gnutella.gui.tables.ChatHolder")) : class$com$limegroup$gnutella$gui$tables$ChatHolder;
            }
            case 4: {
                return class$com$limegroup$gnutella$gui$tables$ProgressBarHolder == null ? (class$com$limegroup$gnutella$gui$tables$ProgressBarHolder = DownloadDataLine.class$("com.limegroup.gnutella.gui.tables.ProgressBarHolder")) : class$com$limegroup$gnutella$gui$tables$ProgressBarHolder;
            }
            case 5: {
                return class$java$lang$String == null ? (class$java$lang$String = DownloadDataLine.class$("java.lang.String")) : class$java$lang$String;
            }
            case 6: {
                return class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder == null ? (class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder = DownloadDataLine.class$("com.limegroup.gnutella.gui.tables.TimeRemainingHolder")) : class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder;
            }
        }
        return null;
    }

    public String[] getToolTipArray() {
        String[] stringArray = new String[this._endTime == -1L ? 4 : 5];
        String string = AVERAGE_BANDWIDTH + ": " + GUIUtils.rate2speed(this.DOWNLOADER.getAverageBandwidth());
        stringArray[0] = STARTED_ON + GUIUtils.msec2DateTime(this._startTime);
        if (this._endTime != -1L) {
            stringArray[1] = FINISHED_ON + GUIUtils.msec2DateTime(this._endTime);
            stringArray[2] = TIME_SPENT + ": " + GUIUtils.seconds2time((int)((this._endTime - this._startTime) / 1000L));
            stringArray[3] = "";
            stringArray[4] = string;
        } else {
            stringArray[1] = TIME_SPENT + ": " + GUIUtils.seconds2time((int)((System.currentTimeMillis() - this._startTime) / 1000L));
            stringArray[2] = "";
            stringArray[3] = string;
        }
        return stringArray;
    }

    public boolean isDynamic(int n) {
        switch (n) {
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    int getLength() {
        return this._size;
    }

    boolean containsDownloader(Downloader downloader) {
        return this.DOWNLOADER.equals(downloader);
    }

    Downloader getDownloader() {
        return this.DOWNLOADER;
    }

    int getState() {
        return this._state;
    }

    boolean isCompleted() {
        return this._state == 4;
    }

    boolean getChatEnabled() {
        return this._chatEnabled;
    }

    boolean getBrowseEnabled() {
        return this._browseEnabled;
    }

    public void update() {
        String string = this.DOWNLOADER.getFileName();
        if (string != null) {
            this._fileName = string;
        }
        this._speed = -1.0;
        this._size = this.DOWNLOADER.getContentLength();
        this._amountRead = this.DOWNLOADER.getAmountRead();
        this._chatEnabled = this.DOWNLOADER.hasChatEnabledHost();
        this._browseEnabled = this.DOWNLOADER.hasBrowseEnabledHost();
        this._timeLeft = 0;
        double d = (double)this._amountRead / (double)this._size;
        this._progress = (int)(d * 100.0);
        this.updateStatus();
        if (!this.isInactive()) {
            this._endTime = -1L;
        }
    }

    private void updateStatus() {
        this._state = this.DOWNLOADER.getState();
        switch (this._state) {
            case 0: {
                this._status = QUEUED_STATE;
                break;
            }
            case 1: {
                this._status = CONNECTING_STATE;
                break;
            }
            case 3: {
                int n = this.DOWNLOADER.getRemainingStateTime();
                int n2 = this.DOWNLOADER.getRetriesWaiting();
                this._status = WAITING_STATE_START + " " + n + WAITING_STATE_MIDDLE + " " + n2 + " " + WAITING_STATE_END;
                break;
            }
            case 11: {
                this._status = HASHING_STATE;
                break;
            }
            case 12: {
                this._status = SAVING_STATE;
                break;
            }
            case 4: {
                this._status = COMPLETE_STATE;
                this._progress = 100;
                break;
            }
            case 5: {
                this._status = ABORTED_STATE;
                break;
            }
            case 6: {
                this._status = FAILED_STATE;
                break;
            }
            case 2: {
                String string = DownloadDataLine.getHostDescription(this.DOWNLOADER);
                Assert.that(string != null, "Null address in downloading state");
                this._status = DOWNLOADING_STATE + " " + string;
                try {
                    this._speed = this.DOWNLOADER.getMeasuredBandwidth();
                }
                catch (InsufficientDataException insufficientDataException) {
                    this._speed = 0.0;
                }
                if (!(this._speed > 0.0)) break;
                double d = (double)this._size / 1024.0 - (double)this._amountRead / 1024.0;
                this._timeLeft = (int)(d / this._speed);
                break;
            }
            case 7: {
                this._status = LIBRARY_MOVE_FAILED_STATE;
                this._progress = 100;
                break;
            }
            case 9: {
                this._status = CORRUPT_FILE_STATE;
                break;
            }
            case 8: {
                int n = this.DOWNLOADER.getRemainingStateTime();
                this._status = REQUERY_WAITING_STATE_START + " " + n + REQUERY_WAITING_STATE_END;
                break;
            }
            case 10: {
                this._status = REMOTE_QUEUED_STATE + " " + this.DOWNLOADER.getQueuePosition();
                break;
            }
            default: {
                Assert.that(false, "Unknown status " + this.DOWNLOADER.getState() + " of downloader");
            }
        }
    }

    private static String getHostDescription(Downloader downloader) {
        int n = 0;
        Endpoint endpoint = null;
        Iterator iterator = downloader.getHosts();
        while (iterator.hasNext()) {
            endpoint = (Endpoint)iterator.next();
            ++n;
        }
        if (n == 1) {
            Assert.that(endpoint != null, "Null last");
            return endpoint.getHostname();
        }
        return n + " " + GUIMediator.getStringResource("DOWNLOAD_HOSTS_LABEL");
    }

    boolean isInactive() {
        return this._state == 4 || this._state == 5 || this._state == 6 || this._state == 7 || this._state == 9;
    }

    boolean isDownloading() {
        return this._state == 2;
    }

    void setEndTime(long l) {
        this._endTime = l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

