/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.download.BrowseListener;
import com.limegroup.gnutella.gui.download.ChatListener;
import com.limegroup.gnutella.gui.download.ClearListener;
import com.limegroup.gnutella.gui.download.DownloadButtons;
import com.limegroup.gnutella.gui.download.DownloadDataLine;
import com.limegroup.gnutella.gui.download.DownloadModel;
import com.limegroup.gnutella.gui.download.DownloadPopupMenu;
import com.limegroup.gnutella.gui.download.LaunchListener;
import com.limegroup.gnutella.gui.download.ResumeListener;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.table.TableColumnModel;

public final class DownloadMediator
extends AbstractTableMediator {
    private static int _totalDownloads = 0;
    private static boolean _audioLaunched = false;
    private static DownloadMediator _instance = new DownloadMediator();
    public ActionListener CHAT_LISTENER;
    public ActionListener CLEAR_LISTENER;
    public ActionListener BROWSE_LISTENER;
    public ActionListener LAUNCH_LISTENER;
    public ActionListener RESUME_LISTENER;

    public static DownloadMediator instance() {
        return _instance;
    }

    protected void buildListeners() {
        super.buildListeners();
        this.CHAT_LISTENER = new ChatListener(this);
        this.CLEAR_LISTENER = new ClearListener(this);
        this.BROWSE_LISTENER = new BrowseListener(this);
        this.LAUNCH_LISTENER = new LaunchListener(this);
        this.RESUME_LISTENER = new ResumeListener(this);
    }

    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(GUIMediator.getStringResource("DOWNLOAD_TITLE"));
        this.DATA_MODEL = new DownloadModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.POPUP_MENU = new DownloadPopupMenu(this).getComponent();
        this.BUTTON_ROW = new DownloadButtons(this).getComponent();
    }

    protected void setPreferredWidths() {
        TableColumnModel tableColumnModel = this.TABLE.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(160);
        tableColumnModel.getColumn(1).setPreferredWidth(15);
        tableColumnModel.getColumn(2).setPreferredWidth(120);
        tableColumnModel.getColumn(3).setPreferredWidth(10);
        tableColumnModel.getColumn(4).setPreferredWidth(25);
        tableColumnModel.getColumn(5).setPreferredWidth(15);
        tableColumnModel.getColumn(6).setPreferredWidth(15);
    }

    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_DOWNLOAD_WINDOW"));
    }

    private DownloadMediator() {
        GUIMediator.addRefreshListener(this);
    }

    public void doRefresh() {
        boolean bl = (Boolean)this.DATA_MODEL.refresh();
        this.setButtonEnabled(4, bl);
    }

    public int getTotalDownloads() {
        return _totalDownloads;
    }

    public int getCurrentDownloads() {
        return ((DownloadModel)this.DATA_MODEL).getCurrentDownloads();
    }

    public int getActiveDownloads() {
        return ((DownloadModel)this.DATA_MODEL).getRowCount();
    }

    public void add(Object object) {
        if (!this.DATA_MODEL.contains(object)) {
            ++_totalDownloads;
            super.add(object);
        }
    }

    public void remove(Object object) {
        int n = ((Downloader)object).getState();
        if (AbstractTableMediator.SETTINGS.getClearCompletedDownload() && (n == 4 || n == 5)) {
            super.remove(object);
        } else {
            DownloadDataLine downloadDataLine = (DownloadDataLine)this.DATA_MODEL.get(object);
            if (downloadDataLine != null) {
                downloadDataLine.setEndTime(System.currentTimeMillis());
            }
        }
    }

    void launchSelectedDownloads() {
        int[] nArray = this.TABLE.getSelectedRows();
        int n = 0;
        int n2 = nArray.length;
        String string = "";
        _audioLaunched = false;
        while (n < n2) {
            final int n3 = nArray[n];
            new Thread(){

                public void run() {
                    DataLine dataLine = DownloadMediator.this.DATA_MODEL.get(n3);
                    Downloader downloader = (Downloader)dataLine.getInitializeObject();
                    File file = downloader.getDownloadFragment();
                    if (file == null) {
                        return;
                    }
                    if (SettingsManager.instance().getPlayerEnabled() && !_audioLaunched && (CommonUtils.canLaunchFileWithQuickTime(file) || LimeXMLUtils.isMP3File(file))) {
                        GUIMediator.instance().launchAudio(file);
                        _audioLaunched = true;
                    } else {
                        try {
                            GUIMediator.launchFile(file);
                        }
                        catch (IOException iOException) {
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                }
            }.start();
            ++n;
        }
    }

    void resumeSelectedDownloads() {
        int[] nArray = this.TABLE.getSelectedRows();
        int n = 0;
        while (n < nArray.length) {
            DataLine dataLine = this.DATA_MODEL.get(nArray[n]);
            Downloader downloader = (Downloader)dataLine.getInitializeObject();
            try {
                downloader.resume();
            }
            catch (AlreadyDownloadingException alreadyDownloadingException) {
                GUIMediator.showError("ERROR_ALREADY_DOWNLOADING", "\"" + alreadyDownloadingException.getFilename() + "\".");
            }
            ++n;
        }
    }

    void chatWithSelectedDownloads() {
        RouterService routerService = GUIMediator.instance().getRouter();
        int[] nArray = this.TABLE.getSelectedRows();
        int n = 0;
        while (n < nArray.length) {
            DataLine dataLine = this.DATA_MODEL.get(nArray[n]);
            Downloader downloader = (Downloader)dataLine.getInitializeObject();
            Endpoint endpoint = downloader.getChatEnabledHost();
            if (endpoint != null) {
                RouterService.createChat(endpoint.getHostname(), endpoint.getPort());
            }
            ++n;
        }
    }

    void browseSelectedDownloads() {
        RouterService routerService = GUIMediator.instance().getRouter();
        int[] nArray = this.TABLE.getSelectedRows();
        int n = 0;
        while (n < nArray.length) {
            DataLine dataLine = this.DATA_MODEL.get(nArray[n]);
            Downloader downloader = (Downloader)dataLine.getInitializeObject();
            RemoteFileDesc remoteFileDesc = downloader.getBrowseEnabledHost();
            if (remoteFileDesc != null) {
                SearchMediator.doBrowseHost(remoteFileDesc);
            }
            ++n;
        }
    }

    public void handleMouseDoubleClick(Point point) {
        this.launchSelectedDownloads();
    }

    void clearCompletedDownloads() {
        ((DownloadModel)this.DATA_MODEL).clearCompleted();
        this.clearSelection();
        this.setButtonEnabled(4, false);
    }

    public void handleSelection(int n) {
        DownloadDataLine downloadDataLine = (DownloadDataLine)this.DATA_MODEL.get(n);
        boolean bl = downloadDataLine.getChatEnabled();
        boolean bl2 = downloadDataLine.getBrowseEnabled();
        this.setButtonEnabled(0, true);
        this.setButtonEnabled(1, true);
        this.setButtonEnabled(2, true);
        this.setButtonEnabled(3, bl);
        this.setPopupItemEnabled(0, true);
        this.setPopupItemEnabled(1, true);
        this.setPopupItemEnabled(2, true);
        this.setPopupItemEnabled(3, bl);
        this.setPopupItemEnabled(4, bl2);
    }

    public void handleNoSelection() {
        this.setButtonEnabled(0, false);
        this.setButtonEnabled(1, false);
        this.setButtonEnabled(2, false);
        this.setButtonEnabled(3, false);
        this.setPopupItemEnabled(0, false);
        this.setPopupItemEnabled(1, false);
        this.setPopupItemEnabled(2, false);
        this.setPopupItemEnabled(3, false);
        this.setPopupItemEnabled(4, false);
    }
}

