/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledTextField;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;

class SaveWindow
extends SetupWindow {
    private final LabeledTextField SAVE_FIELD = new LabeledTextField(GUIMediator.getStringResource("INIT_SAVE_DIRECTORY_FIELD_LABEL"), 20);
    private String _defaultSaveDir;

    SaveWindow(SetupManager setupManager) {
        super(setupManager, "SETUP_SAVE_TITLE", "SETUP_SAVE_LABEL");
        File file = SettingsManager.instance().getSaveDefault();
        try {
            this._defaultSaveDir = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            this._defaultSaveDir = file.getAbsolutePath();
        }
        BoxPanel boxPanel = new BoxPanel(1);
        String[] stringArray = new String[]{"INIT_SAVE_BROWSE_BUTTON_LABEL", "INIT_SAVE_DEFAULT_BUTTON_LABEL"};
        String[] stringArray2 = new String[]{"INIT_SAVE_BROWSE_BUTTON_TIP", "INIT_SAVE_DEFAULT_BUTTON_TIP"};
        ActionListener[] actionListenerArray = new ActionListener[]{new SaveListener(), new DefaultListener()};
        ButtonRow buttonRow = new ButtonRow(stringArray, stringArray2, actionListenerArray, 0, 12);
        this.SAVE_FIELD.setText(this._defaultSaveDir);
        boxPanel.add(this.SAVE_FIELD);
        boxPanel.add(buttonRow);
        super.addSetupComponent(boxPanel);
    }

    public void applySettings() throws ApplySettingsException {
        try {
            String string = this.SAVE_FIELD.getText();
            File file = new File(string);
            File[] fileArray = new File[]{file};
            SettingsManager.instance().setSaveDirectory(file);
            SettingsManager.instance().setDirectories(fileArray);
        }
        catch (IOException iOException) {
            String string = "MESSAGE_INVALID_SAVE_DIRECTORY";
            throw new ApplySettingsException(string);
        }
    }

    private class SaveListener
    implements ActionListener {
        private SaveListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = FileChooserHandler.getInputDirectory(SaveWindow.this);
            if (file == null || !file.isDirectory()) {
                return;
            }
            SaveWindow.this.SAVE_FIELD.setText(file.getAbsolutePath());
        }
    }

    private class DefaultListener
    implements ActionListener {
        private DefaultListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SaveWindow.this.SAVE_FIELD.setText(SaveWindow.this._defaultSaveDir);
        }
    }
}

