/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

final class SpeedWindow
extends SetupWindow {
    private ButtonGroup _speedGroup;
    private JRadioButton _modem;
    private JRadioButton _cable;
    private JRadioButton _t1;
    private JRadioButton _t3;

    SpeedWindow(SetupManager setupManager) {
        super(setupManager, "SETUP_SPEED_TITLE", "SETUP_SPEED_LABEL");
        BoxPanel boxPanel = new BoxPanel(0);
        BoxPanel boxPanel2 = new BoxPanel(1);
        this._speedGroup = new ButtonGroup();
        this._modem = new JRadioButton(GUIConstants.MODEM_SPEED);
        this._cable = new JRadioButton(GUIConstants.CABLE_SPEED);
        this._t1 = new JRadioButton(GUIConstants.T1_SPEED);
        this._t3 = new JRadioButton(GUIConstants.T3_SPEED);
        this._modem.setSelected(true);
        this._speedGroup.add(this._modem);
        this._speedGroup.add(this._cable);
        this._speedGroup.add(this._t1);
        this._speedGroup.add(this._t3);
        boxPanel2.add(this._modem);
        boxPanel2.add(this._cable);
        boxPanel2.add(this._t1);
        boxPanel2.add(this._t3);
        boxPanel.add(boxPanel2);
        boxPanel.add(Box.createHorizontalGlue());
        this.addSetupComponent(boxPanel);
    }

    public void applySettings() throws ApplySettingsException {
        int n = this.getSpeed();
        this.setDownloadSlots(n);
        SettingsManager.instance().setConnectionSpeed(n);
    }

    private int getSpeed() {
        if (this._cable.isSelected()) {
            return 350;
        }
        if (this._t1.isSelected()) {
            return 1000;
        }
        if (this._t3.isSelected()) {
            return 3000;
        }
        return 56;
    }

    private void setDownloadSlots(int n) {
        SettingsManager settingsManager = SettingsManager.instance();
        if (n == 56) {
            settingsManager.setMaxSimDownload(3);
        } else if (n == 350) {
            settingsManager.setMaxSimDownload(8);
        } else if (n == 1000) {
            settingsManager.setMaxSimDownload(12);
        } else if (n == 3000) {
            settingsManager.setMaxSimDownload(14);
        } else {
            settingsManager.setMaxSimDownload(3);
        }
    }
}

