/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.library.DragSourceListener;
import com.limegroup.gnutella.gui.library.LibraryTableMediator;
import com.limegroup.gnutella.gui.library.LibraryTree;
import com.limegroup.gnutella.gui.library.RefreshListener;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import java.awt.Color;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

final class LibraryConstructor {
    private final PaddedPanel MAIN_PANEL = new PaddedPanel();
    private final DragSourceListener MOUSE_LISTENER = new DragSourceListener();
    private final ButtonRow _mainButtons;
    private final JScrollPane TREE_SCROLL_PANE;
    private final JPanel TABLE_BACKGROUND_PANE = new BoxPanel(1);

    LibraryConstructor(LibraryTableMediator libraryTableMediator, LibraryTree libraryTree) {
        String string = GUIMediator.getStringResource("LIBRARY_TITLE");
        this.MAIN_PANEL.setTitle(string);
        libraryTableMediator.addMouseInputListener(this.MOUSE_LISTENER);
        this.TREE_SCROLL_PANE = new JScrollPane(libraryTree.getTree());
        Box box = new Box(0);
        JSplitPane jSplitPane = new JSplitPane(1, this.TREE_SCROLL_PANE, libraryTableMediator.getScrolledTablePane());
        jSplitPane.setDividerLocation(150);
        jSplitPane.setOneTouchExpandable(true);
        box.add(jSplitPane);
        String[] stringArray = new String[]{"LIBRARY_REFRESH_BUTTON_LABEL"};
        String[] stringArray2 = new String[]{"LIBRARY_REFRESH_BUTTON_TIP"};
        ActionListener[] actionListenerArray = new ActionListener[]{new RefreshListener()};
        BoxPanel boxPanel = new BoxPanel(0);
        this._mainButtons = libraryTableMediator.getButtonRow();
        ButtonRow buttonRow = new ButtonRow(stringArray, stringArray2, actionListenerArray);
        boxPanel.add(this._mainButtons);
        boxPanel.add(Box.createHorizontalStrut(18));
        boxPanel.add(buttonRow);
        this.MAIN_PANEL.add(box);
        this.MAIN_PANEL.add(Box.createVerticalStrut(6));
        this.MAIN_PANEL.add(boxPanel);
        this.updateTheme();
    }

    public void updateTheme() {
        Color color = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        this.TREE_SCROLL_PANE.getViewport().setBackground(color);
    }

    JComponent getComponent() {
        return this.MAIN_PANEL;
    }
}

