/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.library.LibraryConstructor;
import com.limegroup.gnutella.gui.library.LibraryTableMediator;
import com.limegroup.gnutella.gui.library.LibraryTree;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;

public final class LibraryMediator
implements ThemeObserver {
    private static final LibraryMediator INSTANCE = new LibraryMediator();
    private final SettingsManager SETTINGS = SettingsManager.instance();
    private static final LibraryTree LIBRARY_TREE = new LibraryTree();
    private static final LibraryTableMediator LIBRARY_TABLE = LibraryTableMediator.instance();
    private static final LibraryConstructor LIBRARY_CONSTRUCTOR = new LibraryConstructor(LIBRARY_TABLE, LIBRARY_TREE);
    private final PlayListGUI PLAY_LIST = PlayListGUI.instance();
    private final HandleFileUpdate FILE_UPDATER = new HandleFileUpdate();

    public static LibraryMediator instance() {
        return INSTANCE;
    }

    private LibraryMediator() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_LIBRARY_WINDOW"));
        GUIMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        LIBRARY_CONSTRUCTOR.updateTheme();
        LIBRARY_TREE.updateTheme();
    }

    public JComponent getComponent() {
        return LIBRARY_CONSTRUCTOR.getComponent();
    }

    public void launch() {
        LIBRARY_TABLE.launch();
    }

    public void deleteLibraryFile() {
        LIBRARY_TABLE.removeSelection();
    }

    public void clearLibrary() {
        LIBRARY_TREE.clear();
        LIBRARY_TABLE.clearTable();
    }

    public void refresh() {
        LIBRARY_TABLE.clearTable();
        if (LIBRARY_TREE.incompleteDirectoryIsSelected()) {
            this.showIncompleteFiles();
        } else {
            if (LIBRARY_TREE.getSelectedDirectory() != null) {
                this.loadShareableFiles(LIBRARY_TREE.getSelectedDirectory());
                LIBRARY_TABLE.forceResort();
            }
            RouterService routerService = GUIMediator.instance().getRouter();
            FileManager fileManager = RouterService.getFileManager();
            fileManager.loadSettings(false);
        }
    }

    public void addSharedLibraryFolder() {
        File file = FileChooserHandler.getInputDirectory();
        if (file == null || !file.isDirectory() || !file.canRead()) {
            GUIMediator.showError("ERROR_INVALID_SHARED_DIRECTORY");
            return;
        }
        try {
            this.SETTINGS.addDirectory(file);
            GUIMediator.instance().getRouter();
            RouterService.getFileManager().loadSettings(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleRootSharedDirectoryChange() {
        File[] fileArray = LIBRARY_TREE.getSharedDirectories();
        this.SETTINGS.setDirectories(fileArray);
        GUIMediator.instance().getRouter();
        RouterService.getFileManager().loadSettings(true);
    }

    public void addSharedDirectory(File file, File file2) {
        LIBRARY_TREE.addSharedDirectory(file, file2);
    }

    public void addSharedFile(FileDesc fileDesc, File file) {
        if (LIBRARY_TREE.parentIsSelected(file)) {
            LIBRARY_TABLE.add(fileDesc);
        }
    }

    public void updateSharedFile(File file) {
        File file2 = LIBRARY_TREE.getSelectedDirectory();
        if (file2 != null && file2.equals(FileManager.getParentFile(file)) && LIBRARY_TABLE.getTable().isShowing()) {
            this.FILE_UPDATER.addFileUpdate(file);
        }
    }

    public void setAnnotateEnabled(boolean bl) {
        LIBRARY_TABLE.setAnnotateEnabled(bl);
    }

    public void addNewLibraryFolder() {
        LIBRARY_TREE.addNewLibraryFolder();
    }

    public void unshareLibraryFolder() {
        LIBRARY_TREE.unshareLibraryFolder();
    }

    public void renameLibraryFolder() {
        LIBRARY_TREE.renameLibraryFolder();
    }

    void addFileToPlayList(File file) {
        this.PLAY_LIST.addFileToPlayList(file);
    }

    void launchAudio(File file) {
        this.PLAY_LIST.launchAudio(file);
    }

    void updateTableFiles(File file) {
        GUIMediator.instance().getRouter();
        FileDesc[] fileDescArray = RouterService.getSharedFileDescriptors(file);
        LIBRARY_TABLE.clearTable();
        LIBRARY_TABLE.setResumeEnabled(false);
        if (fileDescArray != null) {
            int n = 0;
            while (n < fileDescArray.length) {
                LIBRARY_TABLE.addUnsorted(fileDescArray[n]);
                ++n;
            }
        }
        GUIMediator.instance().getRouter();
        if (RouterService.getNumPendingShared() > 0) {
            this.loadShareableFiles(file);
        }
        LIBRARY_TABLE.forceResort();
    }

    void loadShareableFiles(File file) {
        File[] fileArray = FileManager.listFiles(file);
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (FileManager.isFileShareable(fileArray[n], fileArray[n].length())) {
                    LIBRARY_TABLE.addUnsorted(fileArray[n]);
                }
                ++n;
            }
        }
    }

    void showIncompleteFiles() {
        LIBRARY_TABLE.clearTable();
        File file = null;
        try {
            file = this.SETTINGS.getIncompleteDirectory();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        String[] stringArray = file.list();
        LIBRARY_TABLE.setResumeEnabled(true);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                File file2;
                if (!stringArray[n].equals("downloads.dat") && (file2 = new File(file, stringArray[n])).isFile()) {
                    LIBRARY_TABLE.add(file2);
                }
                ++n;
            }
        }
    }

    boolean canDragAndDrop() {
        return LIBRARY_TABLE.canDragAndDrop();
    }

    void setMultiSelection(boolean bl) {
        LIBRARY_TABLE.setMultiSelection(bl);
    }

    boolean getTableMultiSelection() {
        return LIBRARY_TABLE.getMultiSelection();
    }

    void handleDropToTreePoint(Point point) {
        File file = LIBRARY_TREE.getFileForPoint(point);
        boolean bl = LIBRARY_TREE.droppingToIncompleteFolder(point);
        boolean bl2 = LIBRARY_TREE.incompleteDirectoryIsSelected();
        if (file != null) {
            String string = "";
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return;
            }
            int[] nArray = LIBRARY_TABLE.getSelectedRows();
            int n = nArray.length - 1;
            while (n >= 0) {
                File file2;
                File file3 = LIBRARY_TABLE.getFile(nArray[n]);
                boolean bl3 = file3.renameTo(file2 = new File(string, file3.getName()));
                if (bl3) {
                    if (bl) {
                        this.handleDropToIncomplete(file3);
                    } else if (bl2) {
                        this.handleDragFromIncomplete(file2);
                    } else {
                        this.handleStandardDragAndDrop(file3, file2);
                    }
                }
                --n;
            }
        }
    }

    void setCursors(Cursor cursor) {
        LIBRARY_TREE.setCursor(cursor);
        LIBRARY_TABLE.setCursor(cursor);
    }

    Point getTableLocation() {
        return LIBRARY_TABLE.getTableLocation();
    }

    Point getTreeLocation() {
        return LIBRARY_TREE.getTreeLocation();
    }

    Dimension getTableSize() {
        return LIBRARY_TABLE.getTableSize();
    }

    Dimension getTreeSize() {
        return LIBRARY_TREE.getTreeSize();
    }

    int getTableIndexCandidate() {
        return LIBRARY_TABLE.getIndexCandidate();
    }

    ListSelectionModel getTableSelectionModel() {
        return LIBRARY_TABLE.getSelectionModel();
    }

    private void handleDropToIncomplete(File file) {
        GUIMediator.instance().getRouter();
        RouterService.getFileManager().removeFileIfShared(file);
        this.updateTableFiles(LIBRARY_TREE.getSelectedDirectory());
    }

    private void handleDragFromIncomplete(File file) {
        GUIMediator.instance().getRouter();
        RouterService.getFileManager().addFileIfShared(file);
        this.showIncompleteFiles();
    }

    private void handleStandardDragAndDrop(File file, File file2) {
        GUIMediator.instance().getRouter();
        RouterService.getFileManager().renameFileIfShared(file, file2);
        this.updateTableFiles(LIBRARY_TREE.getSelectedDirectory());
    }

    int getTableIndex(File file) throws FileNotFoundException {
        return LIBRARY_TABLE.getIndex(file);
    }

    public boolean incompleteDirectoryIsSelected() {
        return LIBRARY_TREE.incompleteDirectoryIsSelected();
    }

    private static final class HandleFileUpdate
    implements Runnable {
        private Vector list = new Vector();
        private boolean active = false;

        public void addFileUpdate(File file) {
            this.list.addElement(file);
            if (!this.active) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            try {
                while (this.list.size() > 0) {
                    File file = (File)this.list.firstElement();
                    this.list.removeElementAt(0);
                    LIBRARY_TABLE.update(file);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (Exception exception) {
                GUIMediator.showInternalError(exception);
            }
            this.active = false;
        }
    }
}

