/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.library.LibraryTableMediator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

final class LibraryTableCellEditor
implements TableCellEditor {
    private final JTextField _textField = new JTextField();
    private final TextFieldListener _textFieldListener = new TextFieldListener();
    private LibraryTableMediator _libraryTable;
    private CellEditorListener _cellEditorListener;

    LibraryTableCellEditor(LibraryTableMediator libraryTableMediator) {
        this._libraryTable = libraryTableMediator;
        this._cellEditorListener = null;
        this._textField.addActionListener(this._textFieldListener);
    }

    public Object getCellEditorValue() {
        String string = this._textField.getText();
        return this._libraryTable.handleNameChange(string);
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            boolean bl;
            boolean bl2 = bl = ((MouseEvent)eventObject).getClickCount() == 1;
            if (bl) {
                this._textField.selectAll();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this._cellEditorListener = cellEditorListener;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this._cellEditorListener = null;
    }

    void fireEditingStopped() {
        if (this._cellEditorListener != null) {
            this._cellEditorListener.editingStopped(new ChangeEvent(this));
        }
    }

    void fireEditingCanceled() {
        if (this._cellEditorListener != null) {
            this._cellEditorListener.editingCanceled(new ChangeEvent(this));
        }
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this._textField.setText(object != null ? object.toString() : "");
        this._textField.selectAll();
        return this._textField;
    }

    private class TextFieldListener
    implements ActionListener {
        private TextFieldListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTableCellEditor.this.fireEditingStopped();
        }
    }
}

