/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.ColoredCellImpl;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.tables.UploadCountHolder;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.MetaFileManager;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.awt.Color;
import java.io.File;
import java.io.IOException;

public final class LibraryTableDataLine
extends AbstractDataLine
implements ThemeObserver {
    private static final Integer ZERO_INTEGER = new Integer(0);
    private static final UploadCountHolder ZERO_UPLOAD_COUNT_HOLDER = new UploadCountHolder(0, 0);
    private static boolean _allowXML;
    private static String[] _schemas;
    private static MetaFileManager _mfm;
    static final int NAME_COL = 0;
    static final String NAME_STRING;
    static final int SIZE_COL = 1;
    static final String SIZE_STRING;
    static final int TYPE_COL = 2;
    static final String TYPE_STRING;
    static final int PATH_COL = 3;
    static final String PATH_STRING;
    static final int UPLOADS_COL = 4;
    static final String UPLOADS_STRING;
    static final int HITS_COL = 5;
    static final String HITS_STRING;
    static final int ALT_LOC_COL = 6;
    static final String ALT_LOC_STRING;
    static final int NUMBER_OF_COLUMNS = 7;
    private File _file;
    private String _name;
    private String _type;
    private int _size;
    private FileDesc _fileDesc;
    private String _path;
    private Color _cellColor;
    private Color _othercellColor;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$ColoredCell;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$UploadCountHolder;

    public LibraryTableDataLine() {
        this.updateTheme();
        GUIMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        this._cellColor = ThemeFileHandler.WINDOW8_COLOR.getValue();
        this._othercellColor = ThemeFileHandler.NOT_SHARING_LABEL_COLOR.getValue();
    }

    public FileDesc getFileDesc() {
        return this._fileDesc;
    }

    public int getColumnCount() {
        return 7;
    }

    public void initialize(Object object) {
        File file;
        if (object instanceof FileDesc) {
            file = ((FileDesc)object).getFile();
            this._fileDesc = (FileDesc)object;
        } else {
            file = (File)object;
            this._fileDesc = null;
        }
        super.initialize(file);
        try {
            this._file = file;
            String string = this._file.getCanonicalPath();
            this._name = this._file.getName();
            this._type = "";
            int n = this._name.lastIndexOf(".");
            int n2 = string.lastIndexOf(File.separator);
            this._path = string.substring(0, n2);
            if (n != -1 && n != 0) {
                this._type = this._name.substring(n + 1);
                this._name = this._name.substring(0, n);
            }
            this._size = (int)file.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void changeFile(File file) {
        FileDesc fileDesc = this._fileDesc;
        this.initialize(file);
        this._fileDesc = fileDesc;
    }

    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                String string = this._name;
                if (LibraryMediator.instance().incompleteDirectoryIsSelected()) {
                    try {
                        string = IncompleteFileManager.getCompletedName(this._file);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return new ColoredCellImpl(string, this._fileDesc == null ? this._othercellColor : this._cellColor);
            }
            case 1: {
                return new ColoredCellImpl(new SizeHolder(this._size), this._fileDesc == null ? this._othercellColor : this._cellColor);
            }
            case 2: {
                return new ColoredCellImpl(this._type, this._fileDesc == null ? this._othercellColor : this._cellColor);
            }
            case 5: {
                if (this._fileDesc == null) {
                    return null;
                }
                int n2 = this._fileDesc.getHitCount();
                return n2 == 0 ? ZERO_INTEGER : new Integer(n2);
            }
            case 6: {
                if (this._fileDesc == null) {
                    return null;
                }
                int n3 = this._fileDesc.numberOfAlternateLocations();
                return n3 == 0 ? ZERO_INTEGER : new Integer(n3);
            }
            case 4: {
                if (this._fileDesc == null) {
                    return null;
                }
                int n4 = this._fileDesc.getAttemptedUploads();
                int n5 = this._fileDesc.getCompletedUploads();
                return n4 == 0 && n5 == 0 ? ZERO_UPLOAD_COUNT_HOLDER : new UploadCountHolder(n4, n5);
            }
            case 3: {
                return new ColoredCellImpl(this._path, this._fileDesc == null ? this._othercellColor : this._cellColor);
            }
        }
        return null;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return NAME_STRING;
            }
            case 1: {
                return SIZE_STRING;
            }
            case 2: {
                return TYPE_STRING;
            }
            case 5: {
                return HITS_STRING;
            }
            case 6: {
                return ALT_LOC_STRING;
            }
            case 4: {
                return UPLOADS_STRING;
            }
            case 3: {
                return PATH_STRING;
            }
        }
        return null;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return class$com$limegroup$gnutella$gui$tables$ColoredCell == null ? (class$com$limegroup$gnutella$gui$tables$ColoredCell = LibraryTableDataLine.class$("com.limegroup.gnutella.gui.tables.ColoredCell")) : class$com$limegroup$gnutella$gui$tables$ColoredCell;
            }
            case 1: {
                return class$com$limegroup$gnutella$gui$tables$ColoredCell == null ? (class$com$limegroup$gnutella$gui$tables$ColoredCell = LibraryTableDataLine.class$("com.limegroup.gnutella.gui.tables.ColoredCell")) : class$com$limegroup$gnutella$gui$tables$ColoredCell;
            }
            case 2: {
                return class$com$limegroup$gnutella$gui$tables$ColoredCell == null ? (class$com$limegroup$gnutella$gui$tables$ColoredCell = LibraryTableDataLine.class$("com.limegroup.gnutella.gui.tables.ColoredCell")) : class$com$limegroup$gnutella$gui$tables$ColoredCell;
            }
            case 5: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = LibraryTableDataLine.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 6: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = LibraryTableDataLine.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 4: {
                return class$com$limegroup$gnutella$gui$tables$UploadCountHolder == null ? (class$com$limegroup$gnutella$gui$tables$UploadCountHolder = LibraryTableDataLine.class$("com.limegroup.gnutella.gui.tables.UploadCountHolder")) : class$com$limegroup$gnutella$gui$tables$UploadCountHolder;
            }
            case 3: {
                return class$com$limegroup$gnutella$gui$tables$ColoredCell == null ? (class$com$limegroup$gnutella$gui$tables$ColoredCell = LibraryTableDataLine.class$("com.limegroup.gnutella.gui.tables.ColoredCell")) : class$com$limegroup$gnutella$gui$tables$ColoredCell;
            }
        }
        return null;
    }

    public boolean isDynamic(int n) {
        switch (n) {
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    static void setXMLEnabled(boolean bl) {
        _allowXML = bl;
        if (_allowXML) {
            _schemas = LimeXMLSchemaRepository.instance().getAvailableSchemaURIs();
            GUIMediator.instance().getRouter();
            FileManager fileManager = RouterService.getFileManager();
            if (fileManager instanceof MetaFileManager) {
                _mfm = (MetaFileManager)fileManager;
            }
        } else {
            _schemas = null;
            _mfm = null;
        }
    }

    public String[] getToolTipArray() {
        if (!_allowXML || _schemas == null || _schemas.length == 0 || _mfm == null) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        boolean bl = false;
        int n = 0;
        while (n < _schemas.length) {
            LimeXMLDocument limeXMLDocument = _mfm.getDocument(_schemas[n], this._file);
            if (limeXMLDocument != null) {
                try {
                    List list = limeXMLDocument.getOrderedNameValueList();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        bl = true;
                        NameValue nameValue = (NameValue)iterator.next();
                        linkedList.add(LimeXMLUtils.processColName(nameValue.getName()) + ": " + nameValue.getValue());
                    }
                }
                catch (SchemaNotFoundException schemaNotFoundException) {
                    // empty catch block
                }
            }
            ++n;
        }
        if (bl) {
            linkedList.add(0, this._name);
            return (String[])linkedList.toArray(new String[linkedList.size()]);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        NAME_STRING = GUIMediator.getStringResource("LIBRARY_TABLE_NAME");
        SIZE_STRING = GUIMediator.getStringResource("LIBRARY_TABLE_SIZE");
        TYPE_STRING = GUIMediator.getStringResource("LIBRARY_TABLE_TYPE");
        PATH_STRING = GUIMediator.getStringResource("LIBRARY_TABLE_PATH");
        UPLOADS_STRING = GUIMediator.getStringResource("LIBRARY_TABLE_UPLOAD_COUNT");
        HITS_STRING = GUIMediator.getStringResource("LIBRARY_TABLE_HITCOUNT");
        ALT_LOC_STRING = GUIMediator.getStringResource("LIBRARY_TABLE_NUMALTLOC");
    }
}

