/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.CantResumeException;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTableButtons;
import com.limegroup.gnutella.gui.library.LibraryTableCellEditor;
import com.limegroup.gnutella.gui.library.LibraryTableDataLine;
import com.limegroup.gnutella.gui.library.LibraryTableModel;
import com.limegroup.gnutella.gui.library.LibraryTablePopupMenu;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Launcher;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.gui.MetaEditorFrame;
import com.sun.java.util.collections.Arrays;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.MouseInputListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

final class LibraryTableMediator
extends AbstractTableMediator {
    private static final LibraryMediator LIBRARY_MEDIATOR = LibraryMediator.instance();
    public static ActionListener LAUNCH_LISTENER;
    public static ActionListener ADD_PLAY_LIST_LISTENER;
    public static ActionListener ANNOTATE_LISTENER;
    public static ActionListener BITZI_LOOKUP_LISTENER;
    public static ActionListener RESUME_LISTENER;
    private boolean _shiftPressed;
    private boolean _multiSelection;
    private int _indexCandidate;
    private boolean _allowAnnotate;
    private boolean _allowResume;
    private static LibraryTableMediator _instance;

    public static LibraryTableMediator instance() {
        return _instance;
    }

    protected void buildListeners() {
        super.buildListeners();
        LAUNCH_LISTENER = new LaunchListener();
        ADD_PLAY_LIST_LISTENER = new AddPLFileListener();
        ANNOTATE_LISTENER = new AnnotateListener();
        BITZI_LOOKUP_LISTENER = new BitziLookupListener();
        RESUME_LISTENER = new ResumeListener();
    }

    protected void setupConstants() {
        this.MAIN_PANEL = null;
        this.DATA_MODEL = new LibraryTableModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        ((LibraryTableModel)this.DATA_MODEL).setTable(this.TABLE);
        this.POPUP_MENU = new LibraryTablePopupMenu(this).getComponent();
        this.BUTTON_ROW = new LibraryTableButtons(this).getComponent();
    }

    protected void setPreferredWidths() {
        TableColumnModel tableColumnModel = this.TABLE.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(150);
        tableColumnModel.getColumn(1).setPreferredWidth(30);
        tableColumnModel.getColumn(2).setPreferredWidth(10);
        tableColumnModel.getColumn(4).setPreferredWidth(10);
        tableColumnModel.getColumn(5).setPreferredWidth(10);
        tableColumnModel.getColumn(6).setPreferredWidth(10);
    }

    protected void setDefaultEditors() {
        TableColumnModel tableColumnModel = this.TABLE.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellEditor(new LibraryTableCellEditor(this));
    }

    protected void setupTable() {
        super.setupTable();
        this.TABLE.addKeyListener(new LibraryKeyListener());
        LibraryListSelectionModel libraryListSelectionModel = new LibraryListSelectionModel();
        libraryListSelectionModel.setSelectionMode(1);
        this.TABLE.setSelectionModel(libraryListSelectionModel);
    }

    public Component getScrolledTablePane() {
        return super.getScrolledTablePane();
    }

    protected void updateSplashScreen() {
    }

    private LibraryTableMediator() {
    }

    public JComponent getComponent() {
        return null;
    }

    void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.TABLE.addMouseListener(mouseInputListener);
        this.TABLE.addMouseMotionListener(mouseInputListener);
    }

    public void setAnnotateEnabled(boolean bl) {
        this._allowAnnotate = bl;
        LibraryTableDataLine.setXMLEnabled(bl);
        if (!bl) {
            this.setButtonEnabled(LibraryTableButtons.ANNOTATE_BUTTON, false);
            this.setPopupItemEnabled(2, false);
        } else if (!this.TABLE.getSelectionModel().isSelectionEmpty()) {
            this.setButtonEnabled(LibraryTableButtons.ANNOTATE_BUTTON, true);
            this.setPopupItemEnabled(2, true);
        }
    }

    public void setResumeEnabled(boolean bl) {
        this._allowResume = bl;
        if (!bl) {
            this.setButtonEnabled(LibraryTableButtons.RESUME_BUTTON, false);
            this.setPopupItemEnabled(3, false);
        } else if (!this.TABLE.getSelectionModel().isSelectionEmpty()) {
            this.setButtonEnabled(LibraryTableButtons.RESUME_BUTTON, true);
            this.setPopupItemEnabled(3, true);
        }
    }

    File getFile(int n) {
        return ((LibraryTableModel)this.DATA_MODEL).getFile(n);
    }

    int getIndex(File file) throws FileNotFoundException {
        try {
            return this.DATA_MODEL.getRow(file);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new FileNotFoundException();
        }
    }

    void setMultiSelection(boolean bl) {
        this._multiSelection = bl;
    }

    boolean getMultiSelection() {
        return this._multiSelection;
    }

    int getIndexCandidate() {
        return this._indexCandidate;
    }

    JTable getTable() {
        return this.TABLE;
    }

    ButtonRow getButtonRow() {
        return this.BUTTON_ROW;
    }

    ListSelectionModel getSelectionModel() {
        return this.TABLE.getSelectionModel();
    }

    void editMeta() {
        int[] nArray = this.TABLE.getSelectedRows();
        int n = nArray.length;
        if (n == 0) {
            return;
        }
        int n2 = nArray[n - 1];
        File file = ((LibraryTableModel)this.DATA_MODEL).getFile(n2);
        String string = "";
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return;
        }
        JFrame jFrame = GUIMediator.getAppFrame();
        MetaEditorFrame metaEditorFrame = new MetaEditorFrame(string, jFrame);
        metaEditorFrame.show();
    }

    void doBitziLookup() {
        int[] nArray = this.TABLE.getSelectedRows();
        int n = nArray.length;
        if (n == 0) {
            return;
        }
        int n2 = nArray[n - 1];
        FileDesc fileDesc = ((LibraryTableModel)this.DATA_MODEL).getFileDesc(n2);
        if (fileDesc == null) {
            return;
        }
        URN uRN = fileDesc.getSHA1Urn();
        if (uRN == null) {
            return;
        }
        String string = uRN.toString();
        int n3 = 1 + string.indexOf(":", 4);
        String string2 = "http://bitzi.com/lookup/" + string.substring(n3) + "?ref=limewire";
        try {
            Launcher.openURL(string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void removeSelection() {
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length <= 0) {
            return;
        }
        String string = "MESSAGE_CONFIRM_FILE_DELETE";
        int n = GUIMediator.showYesNoMessage(string);
        if (n != 101) {
            return;
        }
        Arrays.sort(nArray);
        if (this.TABLE.isEditing()) {
            TableCellEditor tableCellEditor = this.TABLE.getCellEditor();
            tableCellEditor.cancelCellEditing();
        }
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            File file = ((LibraryTableModel)this.DATA_MODEL).getFile(nArray[n2]);
            if (file.delete()) {
                this.DATA_MODEL.remove(nArray[n2]);
                GUIMediator.instance().getRouter();
                RouterService.getFileManager().removeFileIfShared(file);
            } else {
                String string2 = "'" + file.getName() + "'.";
                GUIMediator.showError("MESSAGE_UNABLE_TO_DELETE_FILE_START", string2, "MESSAGE_UNABLE_TO_DELETE_FILE_END");
            }
            --n2;
        }
        this.clearSelection();
    }

    public void handleMouseDoubleClick(Point point) {
        this.launch();
    }

    void resumeIncomplete() {
        RouterService routerService = GUIMediator.instance().getRouter();
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length > 0) {
            File file = ((LibraryTableModel)this.DATA_MODEL).getFile(nArray[0]);
            try {
                routerService.download(file);
                GUIMediator.instance().setWindow(0);
            }
            catch (AlreadyDownloadingException alreadyDownloadingException) {
                GUIMediator.showError("ERROR_ALREADY_DOWNLOADING", "\"" + alreadyDownloadingException.getFilename() + "\".");
            }
            catch (CantResumeException cantResumeException) {
                GUIMediator.showError("ERROR_CANT_RESUME_START", "\"" + cantResumeException.getFilename() + "\"", "ERROR_CANT_RESUME_END");
            }
        }
    }

    void launch() {
        int[] nArray = this.TABLE.getSelectedRows();
        boolean bl = false;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            try {
                File file = ((LibraryTableModel)this.DATA_MODEL).getFile(nArray[n]);
                if (SettingsManager.instance().getPlayerEnabled() && (CommonUtils.canLaunchFileWithQuickTime(file) || LimeXMLUtils.isMP3File(file))) {
                    if (!bl) {
                        LIBRARY_MEDIATOR.launchAudio(file);
                        bl = true;
                    }
                } else {
                    GUIMediator.launchFile(file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n;
        }
    }

    String handleNameChange(String string) {
        int n = this.TABLE.getEditingRow();
        File file = ((LibraryTableModel)this.DATA_MODEL).getFile(n);
        String string2 = file.getParent();
        String string3 = string;
        string = string + "." + ((LibraryTableModel)this.DATA_MODEL).getType(n);
        File file2 = new File(string2, string);
        if (!((LibraryTableModel)this.DATA_MODEL).getName(n).equals(string)) {
            boolean bl = file.renameTo(file2);
            if (bl) {
                GUIMediator.instance().getRouter();
                RouterService.getFileManager().renameFileIfShared(file, file2);
                ((LibraryTableModel)this.DATA_MODEL).handleFileChangeInternal(n, file2);
                return string3;
            }
            String string4 = "'" + ((LibraryTableModel)this.DATA_MODEL).getName(n) + "'.";
            GUIMediator.showError("MESSAGE_UNABLE_TO_RENAME_FILE_START", string4, "MESSAGE_UNABLE_TO_RENAME_FILE_END");
            return ((LibraryTableModel)this.DATA_MODEL).getName(n);
        }
        return string3;
    }

    boolean canDragAndDrop() {
        int[] nArray = this.TABLE.getSelectedRows();
        return nArray.length > 0 && !this.TABLE.isEditing();
    }

    void setCursor(Cursor cursor) {
        this.TABLE.setCursor(cursor);
    }

    Point getTableLocation() {
        return this.TABLE.getLocationOnScreen();
    }

    Dimension getTableSize() {
        return this.TABLE.getSize();
    }

    int[] getSelectedRows() {
        return this.TABLE.getSelectedRows();
    }

    public void handleSelection(int n) {
        this.setButtonEnabled(LibraryTableButtons.LAUNCH_BUTTON, true);
        this.setButtonEnabled(LibraryTableButtons.DELETE_BUTTON, true);
        if (!CommonUtils.isMacClassic()) {
            this.setButtonEnabled(LibraryTableButtons.PLAYLIST_BUTTON, true);
            this.setPopupItemEnabled(4, true);
        }
        if (this._allowAnnotate) {
            this.setButtonEnabled(LibraryTableButtons.ANNOTATE_BUTTON, true);
            this.setPopupItemEnabled(2, true);
        }
        if (this._allowResume) {
            this.setButtonEnabled(LibraryTableButtons.RESUME_BUTTON, true);
            this.setPopupItemEnabled(3, true);
        }
        this.setPopupItemEnabled(0, true);
        this.setPopupItemEnabled(1, true);
        this.setPopupItemEnabled(5, true);
    }

    public void handleNoSelection() {
        this.setButtonEnabled(LibraryTableButtons.LAUNCH_BUTTON, false);
        this.setButtonEnabled(LibraryTableButtons.DELETE_BUTTON, false);
        if (!CommonUtils.isMacClassic()) {
            this.setButtonEnabled(LibraryTableButtons.PLAYLIST_BUTTON, false);
            this.setPopupItemEnabled(4, false);
        }
        this.setButtonEnabled(LibraryTableButtons.ANNOTATE_BUTTON, false);
        this.setPopupItemEnabled(2, false);
        this.setButtonEnabled(LibraryTableButtons.RESUME_BUTTON, false);
        this.setPopupItemEnabled(3, false);
        this.setPopupItemEnabled(0, false);
        this.setPopupItemEnabled(1, false);
        this.setPopupItemEnabled(5, false);
    }

    static {
        _instance = new LibraryTableMediator();
    }

    private final class LibraryListSelectionModel
    extends DefaultListSelectionModel {
        private LibraryListSelectionModel() {
        }

        public void setSelectionInterval(int n, int n2) {
            LibraryTableMediator.this._indexCandidate = -1;
            if (LibraryTableMediator.this._multiSelection) {
                LibraryTableMediator.this._indexCandidate = n;
            }
            if (!LibraryTableMediator.this._multiSelection) {
                super.setSelectionInterval(n, n2);
            } else if (this.getMinSelectionIndex() > n || this.getMaxSelectionIndex() < n2) {
                super.setSelectionInterval(n, n2);
            } else {
                LibraryTableMediator.this._indexCandidate = n;
            }
        }

        public void setLeadSelectionIndex(int n) {
            if (LibraryTableMediator.this._shiftPressed) {
                super.setLeadSelectionIndex(n);
            }
        }
    }

    private final class AddPLFileListener
    implements ActionListener {
        private AddPLFileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int[] nArray = LibraryTableMediator.this.TABLE.getSelectedRows();
                int n = 0;
                while (n < nArray.length) {
                    int n2 = nArray[n];
                    File file = ((LibraryTableModel)LibraryTableMediator.this.DATA_MODEL).getFile(n2);
                    LIBRARY_MEDIATOR.addFileToPlayList(file);
                    ++n;
                }
            }
            catch (Exception exception) {
                GUIMediator.showInternalError(exception);
            }
        }
    }

    private final class LaunchListener
    implements ActionListener {
        private LaunchListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                LibraryTableMediator.this.launch();
            }
            catch (Exception exception) {
                GUIMediator.showInternalError(exception);
            }
        }
    }

    private final class BitziLookupListener
    implements ActionListener {
        private BitziLookupListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTableMediator.this.doBitziLookup();
        }
    }

    private final class ResumeListener
    implements ActionListener {
        private ResumeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                LibraryTableMediator.this.resumeIncomplete();
            }
            catch (Exception exception) {
                GUIMediator.showInternalError(exception);
            }
        }
    }

    private final class AnnotateListener
    implements ActionListener {
        private AnnotateListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                LibraryTableMediator.this.editMeta();
            }
            catch (Exception exception) {
                GUIMediator.showInternalError(exception);
            }
        }
    }

    private final class LibraryKeyListener
    implements KeyListener {
        private LibraryKeyListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            try {
                if (keyEvent.getKeyChar() != '\b') {
                    return;
                }
                LibraryTableMediator.this.removeSelection();
            }
            catch (Exception exception) {
                GUIMediator.showInternalError(exception);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 16) {
                LibraryTableMediator.this._shiftPressed = true;
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 16) {
                LibraryTableMediator.this._shiftPressed = false;
            }
        }
    }
}

