/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTreeCellEditor;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.ArrayList;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

final class LibraryTree {
    private final String INCOMPLETE_FILE_NAME = "Incomplete";
    private final LibraryMediator LIBRARY_MEDIATOR = LibraryMediator.instance();
    private final JTree TREE = new JTree();
    private final LibraryTreeNode ROOT_NODE = new LibraryTreeNode();
    private final DefaultTreeModel TREE_MODEL = new DefaultTreeModel(this.ROOT_NODE);
    private final SettingsManager SETTINGS = SettingsManager.instance();
    private final JPopupMenu DIRECTORY_POPUP = new JPopupMenu();
    private boolean _isFirstDirectoryAdded = true;

    LibraryTree() {
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setOpaque(false);
        this.TREE.setCellRenderer(defaultTreeCellRenderer);
        this.TREE.setModel(this.TREE_MODEL);
        this.TREE.setRootVisible(false);
        this.TREE.getSelectionModel().setSelectionMode(1);
        this.TREE.setEditable(true);
        this.TREE.setInvokesStopCellEditing(true);
        this.TREE.setShowsRootHandles(true);
        this.TREE.putClientProperty("JTree.lineStyle", "None");
        this.makePopupMenu();
        this.TREE.addTreeSelectionListener(new LibraryTreeSelectionListener());
        this.TREE.setCellEditor(new DefaultTreeCellEditor(this.TREE, (DefaultTreeCellRenderer)this.TREE.getCellRenderer(), new LibraryTreeCellEditor(this)));
        this.addIncompleteDirectory();
        this.updateTheme();
    }

    public void updateTheme() {
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.TREE.getCellRenderer();
        Color color = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        defaultTreeCellRenderer.setBackground(color);
        this.TREE.setBackground(color);
        SwingUtilities.updateComponentTreeUI(this.TREE);
    }

    void addSharedDirectory(File file, File file2) {
        LibraryTreeNode libraryTreeNode = null;
        LibraryTreeNode libraryTreeNode2 = null;
        InternalNodeFileHolder internalNodeFileHolder = null;
        if (file2 == null) {
            if (!this.ROOT_NODE.isChild(file)) {
                internalNodeFileHolder = new InternalNodeFileHolder(file);
                libraryTreeNode = new LibraryTreeNode(internalNodeFileHolder);
                this.TREE_MODEL.insertNodeInto(libraryTreeNode, this.ROOT_NODE, this.ROOT_NODE.getChildCount() - 1);
                libraryTreeNode2 = this.ROOT_NODE;
            }
        } else {
            AbstractFileHolder abstractFileHolder = null;
            Enumeration<TreeNode> enumeration = this.ROOT_NODE.breadthFirstEnumeration();
            if (enumeration.hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    libraryTreeNode = (LibraryTreeNode)enumeration.nextElement();
                    abstractFileHolder = libraryTreeNode.getFileHolder();
                    if (!abstractFileHolder.matchesFile(file2)) continue;
                    if (!libraryTreeNode.isChild(file)) {
                        internalNodeFileHolder = new InternalNodeFileHolder(file);
                        LibraryTreeNode libraryTreeNode3 = new LibraryTreeNode(internalNodeFileHolder);
                        this.TREE_MODEL.insertNodeInto(libraryTreeNode3, libraryTreeNode, libraryTreeNode.getChildCount());
                        libraryTreeNode2 = libraryTreeNode;
                    }
                    break;
                }
            } else {
                InternalNodeFileHolder internalNodeFileHolder2 = new InternalNodeFileHolder(file);
                libraryTreeNode = new LibraryTreeNode(internalNodeFileHolder2);
                this.TREE_MODEL.insertNodeInto(libraryTreeNode, this.ROOT_NODE, this.ROOT_NODE.getChildCount() - 1);
                libraryTreeNode2 = this.ROOT_NODE;
            }
        }
        if (this.TREE.isEditing()) {
            this.TREE.getCellEditor().cancelCellEditing();
        }
        this.TREE_MODEL.reload(libraryTreeNode2);
        if (this._isFirstDirectoryAdded) {
            this._isFirstDirectoryAdded = false;
            this.setSelectionRow(0);
        }
    }

    void addNewLibraryFolder() {
        LibraryTreeNode libraryTreeNode = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (libraryTreeNode == null) {
            return;
        }
        if (this.incompleteDirectoryIsSelected()) {
            this.showIncompleteFolderMessage("add a new folder to");
            return;
        }
        File file = libraryTreeNode.getFileHolder().getFile();
        File file2 = new File(file, "New Folder");
        int n = 2;
        boolean bl = false;
        while (!bl) {
            bl = file2.mkdir();
            if (bl) {
                LibraryTreeNode libraryTreeNode2 = new LibraryTreeNode(new InternalNodeFileHolder(file2));
                this.TREE_MODEL.insertNodeInto(libraryTreeNode2, libraryTreeNode, libraryTreeNode.getChildCount());
                this.TREE.expandRow(this.TREE.getLeadSelectionRow());
                this.TREE.setSelectionRow(this.TREE.getLeadSelectionRow() + libraryTreeNode.getChildCount());
                this.LIBRARY_MEDIATOR.refresh();
            } else {
                file2 = new File(file, "New Folder (" + String.valueOf(n) + ")");
            }
            ++n;
        }
    }

    void renameLibraryFolder() {
        LibraryTreeNode libraryTreeNode = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (libraryTreeNode == null) {
            return;
        }
        if (!this.incompleteDirectoryIsSelected()) {
            this.TREE.startEditingAtPath(this.TREE.getLeadSelectionPath());
        } else {
            this.showIncompleteFolderMessage("rename");
        }
    }

    void addPlayListEntries() {
        LibraryTreeNode libraryTreeNode = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (libraryTreeNode == null) {
            return;
        }
        if (this.incompleteDirectoryIsSelected()) {
            return;
        }
        final File file = libraryTreeNode.getFileHolder().getFile();
        new Thread(){

            public void run() {
                PlayListGUI playListGUI;
                String[] stringArray = new String[]{"mp3"};
                File[] fileArray = FileManager.getFilesRecursive(file, stringArray);
                PlayListGUI playListGUI2 = playListGUI = PlayListGUI.instance();
                synchronized (playListGUI2) {
                    int n = 0;
                    while (fileArray != null && n < fileArray.length) {
                        playListGUI.addFileToPlayList(fileArray[n]);
                        ++n;
                    }
                }
            }
        }.start();
    }

    File getFileForPoint(Point point) {
        TreePath treePath = this.TREE.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return null;
        }
        LibraryTreeNode libraryTreeNode = (LibraryTreeNode)treePath.getLastPathComponent();
        AbstractFileHolder abstractFileHolder = libraryTreeNode.getFileHolder();
        File file = abstractFileHolder.getFile();
        if (file.isDirectory()) {
            return file;
        }
        return null;
    }

    boolean droppingToIncompleteFolder(Point point) {
        TreePath treePath = this.TREE.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return false;
        }
        LibraryTreeNode libraryTreeNode = (LibraryTreeNode)treePath.getLastPathComponent();
        if (libraryTreeNode == null) {
            return false;
        }
        return this.isIncompleteDirectory(libraryTreeNode.getFileHolder());
    }

    File getSelectedDirectory() {
        LibraryTreeNode libraryTreeNode = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (libraryTreeNode == null) {
            return null;
        }
        return libraryTreeNode.getFileHolder().getFile();
    }

    File[] getSharedDirectories() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        int n = this.ROOT_NODE.getChildCount();
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < n) {
            LibraryTreeNode libraryTreeNode = (LibraryTreeNode)this.ROOT_NODE.getChildAt(n2);
            object = libraryTreeNode.getFileHolder();
            if (!this.isIncompleteDirectory((AbstractFileHolder)object)) {
                File file = object.getFile();
                String string2 = "";
                if (file.isDirectory()) {
                    arrayList.add(file);
                }
            }
            ++n2;
        }
        object = new File[arrayList.size()];
        int n3 = 0;
        while (n3 < arrayList.size()) {
            object[n3] = (File)arrayList.get(n3);
            ++n3;
        }
        return object;
    }

    void setSelectionRow(int n) {
        this.TREE.setSelectionRow(n);
    }

    boolean parentIsSelected(File file) {
        LibraryTreeNode libraryTreeNode = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (libraryTreeNode == null) {
            return false;
        }
        return libraryTreeNode.getFileHolder().matchesFile(file);
    }

    void clear() {
        this.ROOT_NODE.removeAllChildren();
        this._isFirstDirectoryAdded = true;
        this.addIncompleteDirectory();
    }

    Object handleNameChange(String string) {
        LibraryTreeNode libraryTreeNode = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (libraryTreeNode == null) {
            return null;
        }
        if (string.equals(libraryTreeNode.getFileHolder().toString())) {
            return libraryTreeNode.getFileHolder();
        }
        File file = libraryTreeNode.getFileHolder().getFile();
        String string2 = file.getParent();
        if (string2 == null) {
            return null;
        }
        File file2 = new File(string2, string);
        boolean bl = file.renameTo(file2);
        if (!bl) {
            return null;
        }
        InternalNodeFileHolder internalNodeFileHolder = new InternalNodeFileHolder(file2);
        libraryTreeNode.setUserObject(internalNodeFileHolder);
        this.TREE_MODEL.nodeChanged(libraryTreeNode);
        if (!libraryTreeNode.isLeaf()) {
            libraryTreeNode.removeAllChildren();
        }
        this.handleDirectoryChange(libraryTreeNode);
        return libraryTreeNode.getFileHolder();
    }

    void unshareLibraryFolder() {
        LibraryTreeNode libraryTreeNode = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (libraryTreeNode == null) {
            return;
        }
        if (this.incompleteDirectoryIsSelected()) {
            this.showIncompleteFolderMessage("delete");
        } else if (!libraryTreeNode.getLibraryTreeNodeParent().isRoot()) {
            GUIMediator.showMessage("MESSAGE_CANNOT_UNSHARE_SUBDIRS");
        } else {
            String string = "MESSAGE_CONFIRM_UNSHARE_DIRECTORY";
            int n = GUIMediator.showYesNoMessage(string);
            if (n != 101) {
                return;
            }
            this.TREE_MODEL.removeNodeFromParent(libraryTreeNode);
            this.LIBRARY_MEDIATOR.handleRootSharedDirectoryChange();
        }
    }

    boolean incompleteDirectoryIsSelected() {
        LibraryTreeNode libraryTreeNode = (LibraryTreeNode)this.TREE.getLastSelectedPathComponent();
        if (libraryTreeNode == null) {
            return false;
        }
        return this.isIncompleteDirectory(libraryTreeNode.getFileHolder());
    }

    void setCursor(Cursor cursor) {
        this.TREE.setCursor(cursor);
    }

    Point getTreeLocation() {
        return this.TREE.getLocationOnScreen();
    }

    Dimension getTreeSize() {
        return this.TREE.getSize();
    }

    JTree getTree() {
        return this.TREE;
    }

    private boolean isIncompleteDirectory(AbstractFileHolder abstractFileHolder) {
        return abstractFileHolder.toString().equals("Incomplete");
    }

    private void addIncompleteDirectory() {
        try {
            File file = this.SETTINGS.getIncompleteDirectory();
            InternalNodeFileHolder internalNodeFileHolder = new InternalNodeFileHolder(file);
            LibraryTreeNode libraryTreeNode = new LibraryTreeNode(internalNodeFileHolder);
            this.TREE_MODEL.insertNodeInto(libraryTreeNode, this.ROOT_NODE, 0);
            this.TREE_MODEL.reload(this.ROOT_NODE);
        }
        catch (FileNotFoundException fileNotFoundException) {
            GUIMediator.showInternalError(fileNotFoundException);
        }
    }

    private void showIncompleteFolderMessage(String string) {
        String string2 = "MESSAGE_INCOMPLETE_DIRECTORY_START";
        String string3 = "MESSAGE_INCOMPLETE_DIRECTORY_END";
        GUIMediator.showError(string2, string, string3);
    }

    private void showFolderDeletionError(String string) {
        String string2 = "'" + string + "'.";
        GUIMediator.showError("MESSAGE_UNABLE_TO_DELETE_DIRECTORY_START", string2, "MESSAGE_UNABLE_TO_DELETE_DIRECTORY_END");
    }

    private void handleDirectoryChange(LibraryTreeNode libraryTreeNode) {
        if (libraryTreeNode.getLibraryTreeNodeParent().isRoot()) {
            this.LIBRARY_MEDIATOR.handleRootSharedDirectoryChange();
        } else {
            this.LIBRARY_MEDIATOR.refresh();
        }
    }

    private void makePopupMenu() {
        JMenuItem jMenuItem = new JMenuItem(GUIMediator.getStringResource("LIBRARY_TREE_NEW_FOLDER_LABEL"));
        JMenuItem jMenuItem2 = new JMenuItem(GUIMediator.getStringResource("LIBRARY_TREE_UNSHARE_FOLDER_LABEL"));
        JMenuItem jMenuItem3 = new JMenuItem(GUIMediator.getStringResource("LIBRARY_TREE_RENAME_FOLDER_LABEL"));
        JMenuItem jMenuItem4 = new JMenuItem(GUIMediator.getStringResource("LIBRARY_TREE_TO_PLAYLIST_FOLDER_LABEL"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    LibraryTree.this.addNewLibraryFolder();
                }
                catch (Exception exception) {
                    GUIMediator.showInternalError(exception);
                }
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    LibraryTree.this.unshareLibraryFolder();
                }
                catch (Exception exception) {
                    GUIMediator.showInternalError(exception);
                }
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    LibraryTree.this.renameLibraryFolder();
                }
                catch (Exception exception) {
                    GUIMediator.showInternalError(exception);
                }
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    LibraryTree.this.addPlayListEntries();
                }
                catch (Exception exception) {
                    GUIMediator.showInternalError(exception);
                }
            }
        });
        this.DIRECTORY_POPUP.add(jMenuItem);
        this.DIRECTORY_POPUP.add(jMenuItem2);
        this.DIRECTORY_POPUP.add(jMenuItem3);
        if (!CommonUtils.isMacClassic()) {
            this.DIRECTORY_POPUP.add(jMenuItem4);
        }
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    int n = LibraryTree.this.TREE.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (n == -1) {
                        return;
                    }
                    LibraryTree.this.TREE.setSelectionRow(n);
                    if ((mouseEvent.isPopupTrigger() || SwingUtilities.isRightMouseButton(mouseEvent)) && !LibraryTree.this.incompleteDirectoryIsSelected()) {
                        LibraryTree.this.DIRECTORY_POPUP.show(LibraryTree.this.TREE, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
                catch (Exception exception) {
                    GUIMediator.showInternalError(exception);
                }
            }
        };
        this.TREE.addMouseListener(mouseAdapter);
    }

    private class RootNodeFileHolder
    extends AbstractFileHolder {
        private RootNodeFileHolder() {
        }

        protected File getFile() {
            return null;
        }

        protected boolean matchesFile(File file) {
            return false;
        }

        public String toString() {
            return "";
        }
    }

    private class InternalNodeFileHolder
    extends AbstractFileHolder {
        private final File FILE;

        InternalNodeFileHolder(File file) {
            this.FILE = file;
        }

        protected File getFile() {
            return this.FILE;
        }

        protected boolean matchesFile(File file) {
            return this.FILE.equals(file);
        }

        public String toString() {
            return this.FILE.getName();
        }
    }

    private abstract class AbstractFileHolder {
        private AbstractFileHolder() {
        }

        protected abstract File getFile();

        protected abstract boolean matchesFile(File var1);
    }

    private final class LibraryTreeNode
    extends DefaultMutableTreeNode {
        private AbstractFileHolder _holder;

        private LibraryTreeNode() {
            this._holder = new RootNodeFileHolder();
        }

        private LibraryTreeNode(AbstractFileHolder abstractFileHolder) {
            super(abstractFileHolder);
            this._holder = abstractFileHolder;
            if (this._holder == null) {
                throw new NullPointerException("null holder in LibraryTreeNode");
            }
        }

        private AbstractFileHolder getFileHolder() {
            return this._holder;
        }

        private boolean isChild(File file) {
            int n = this.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                LibraryTreeNode libraryTreeNode = (LibraryTreeNode)this.getChildAt(n2);
                File file2 = libraryTreeNode.getFileHolder().getFile();
                if (file2.equals(file)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void setUserObject(Object object) {
            if (object == null) {
                throw new NullPointerException("null holder param");
            }
            super.setUserObject(object);
            this._holder = (AbstractFileHolder)object;
        }

        private LibraryTreeNode getLibraryTreeNodeParent() {
            TreeNode treeNode = super.getParent();
            if (treeNode == null) {
                return null;
            }
            return (LibraryTreeNode)treeNode;
        }
    }

    private class LibraryTreeSelectionListener
    implements TreeSelectionListener {
        private LibraryTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            try {
                LibraryTreeNode libraryTreeNode = (LibraryTreeNode)LibraryTree.this.TREE.getLastSelectedPathComponent();
                if (libraryTreeNode == null) {
                    return;
                }
                if (!LibraryTree.this.incompleteDirectoryIsSelected()) {
                    LibraryTree.this.LIBRARY_MEDIATOR.updateTableFiles(libraryTreeNode.getFileHolder().getFile());
                } else {
                    LibraryTree.this.LIBRARY_MEDIATOR.showIncompleteFiles();
                }
            }
            catch (Exception exception) {
                GUIMediator.showInternalError(exception);
            }
        }
    }
}

