/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

final class FileMenu
extends AbstractMenu {
    private JMenuItem _close;
    private JMenuItem _addFolder;
    private JMenuItem _newFolder;
    private JMenuItem _unshareFolder;
    private JMenuItem _rename;
    private JMenuItem _deleteFile;
    private JMenuItem _launchFile;
    private JMenuItem _refresh;
    private JMenuItem _connect;
    private JMenuItem _disconnect;
    private boolean _connected = false;

    FileMenu(String string) {
        super(string);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.close();
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.instance().addSharedLibraryFolder();
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.instance().addNewLibraryFolder();
            }
        };
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.instance().unshareLibraryFolder();
            }
        };
        ActionListener actionListener5 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.instance().renameLibraryFolder();
            }
        };
        ActionListener actionListener6 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.instance().launchLibraryFile();
            }
        };
        ActionListener actionListener7 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.instance().deleteLibraryFile();
            }
        };
        ActionListener actionListener8 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.instance().refreshLibrary();
            }
        };
        ActionListener actionListener9 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.instance().connect();
            }
        };
        ActionListener actionListener10 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.instance().disconnect();
            }
        };
        this._close = this.getMenuItem("MENU_FILE_CLOSE", actionListener);
        this._connect = this.getMenuItem("MENU_FILE_CONNECT", actionListener9);
        this._disconnect = this.getMenuItem("MENU_FILE_DISCONNECT", actionListener10);
        this._addFolder = this.getMenuItem("MENU_FILE_LIBRARY_ADD_SHARED_FOLDER", actionListener2);
        this._newFolder = this.getMenuItem("MENU_FILE_LIBRARY_NEW_FOLDER", actionListener3);
        this._unshareFolder = this.getMenuItem("MENU_FILE_LIBRARY_UNSHARE_FOLDER", actionListener4);
        this._rename = this.getMenuItem("MENU_FILE_LIBRARY_RENAME_FOLDER", actionListener5);
        this._launchFile = this.getMenuItem("MENU_FILE_LIBRARY_LAUNCH_FILES", actionListener6);
        this._deleteFile = this.getMenuItem("MENU_FILE_LIBRARY_DELETE_FILES", actionListener7);
        this._refresh = this.getMenuItem("MENU_FILE_LIBRARY_REFRESH", actionListener8);
        this.setConnected(this._connected);
        this.MENU.add(this._connect);
        this.MENU.add(this._disconnect);
        if (!CommonUtils.isMacOSX()) {
            this.MENU.addSeparator();
            this.MENU.add(this._close);
        }
    }

    private JMenuItem getMenuItem(String string, ActionListener actionListener) {
        String string2 = GUIMediator.getStringResource(string);
        String string3 = GUIMediator.getStringResource(string + "_ACCESSIBLE");
        int n = this.getCodeForCharKey(string + "_MNEMONIC");
        JMenuItem jMenuItem = new JMenuItem(string2, n);
        jMenuItem.getAccessibleContext().setAccessibleDescription(string3);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    void handleLibrarySelection() {
        this.MENU.removeAll();
        this.MENU.add(this._connect);
        this.MENU.add(this._disconnect);
        this.MENU.addSeparator();
        this.MENU.add(this._addFolder);
        this.MENU.add(this._newFolder);
        this.MENU.add(this._rename);
        this.MENU.add(this._unshareFolder);
        this.MENU.addSeparator();
        this.MENU.add(this._launchFile);
        this.MENU.add(this._deleteFile);
        this.MENU.addSeparator();
        this.MENU.add(this._refresh);
        if (!CommonUtils.isMacOSX()) {
            this.MENU.addSeparator();
            this.MENU.add(this._close);
        }
        this.setConnected(this._connected);
    }

    void handleStandardSelection() {
        if (this.MENU.getItemCount() > 1) {
            this.MENU.removeAll();
            this.MENU.add(this._connect);
            this.MENU.add(this._disconnect);
            if (!CommonUtils.isMacOSX()) {
                this.MENU.addSeparator();
                this.MENU.add(this._close);
            }
            this.setConnected(this._connected);
        }
    }

    void setConnected(boolean bl) {
        this._connected = bl;
        this._connect.setEnabled(!bl);
        this._disconnect.setEnabled(bl);
    }
}

