/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JRadioButtonMenuItem;

final class ViewMenu
extends AbstractMenu {
    private JCheckBoxMenuItem MONITOR_ITEM = null;
    private JCheckBoxMenuItem CONNECTIONS_ITEM = null;
    private JCheckBoxMenuItem SHOPPING_ITEM = null;
    private JCheckBoxMenuItem LIBRARY_ITEM = null;
    private JRadioButtonMenuItem OSX_MONITOR_ITEM = null;
    private JRadioButtonMenuItem OSX_CONNECTIONS_ITEM = null;
    private JRadioButtonMenuItem OSX_LIBRARY_ITEM = null;

    ViewMenu(String string) {
        super(string);
        SettingsManager settingsManager = SettingsManager.instance();
        if (!CommonUtils.isMacOSX()) {
            this.MONITOR_ITEM = this.addCheckBoxMenuItem("VIEW_MONITOR", new ViewListener(1), settingsManager.getMonitorViewEnabled());
            this.CONNECTIONS_ITEM = this.addCheckBoxMenuItem("VIEW_CONNECTIONS", new ViewListener(2), settingsManager.getConnectionViewEnabled());
            this.LIBRARY_ITEM = this.addCheckBoxMenuItem("VIEW_LIBRARY", new ViewListener(3), settingsManager.getLibraryViewEnabled());
            if (!GUIMediator.hasDonated() && CommonUtils.isWindows() && GUIMediator.isBrowserPageLoaded()) {
                this.SHOPPING_ITEM = this.addCheckBoxMenuItem("VIEW_SHOPPING", new ShoppingViewListener(4), settingsManager.getShoppingViewEnabled());
            }
        } else {
            this.OSX_MONITOR_ITEM = this.addRadioButtonMenuItem("VIEW_MONITOR", new ViewListener(1), settingsManager.getMonitorViewEnabled());
            this.OSX_CONNECTIONS_ITEM = this.addRadioButtonMenuItem("VIEW_CONNECTIONS", new ViewListener(2), settingsManager.getConnectionViewEnabled());
            this.OSX_LIBRARY_ITEM = this.addRadioButtonMenuItem("VIEW_LIBRARY", new ViewListener(3), settingsManager.getLibraryViewEnabled());
        }
    }

    private JRadioButtonMenuItem addRadioButtonMenuItem(String string, ActionListener actionListener, boolean bl) {
        String string2 = "MENU_" + string;
        String string3 = "MENU_" + string + "_ACCESSIBLE";
        String string4 = "MENU_" + string + "_MNEMONIC";
        String string5 = GUIMediator.getStringResource(string2);
        String string6 = GUIMediator.getStringResource(string3);
        int n = this.getCodeForCharKey(string4);
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string5, bl);
        jRadioButtonMenuItem.setMnemonic(n);
        jRadioButtonMenuItem.getAccessibleContext().setAccessibleDescription(string6);
        jRadioButtonMenuItem.addActionListener(actionListener);
        this.MENU.add(jRadioButtonMenuItem);
        return jRadioButtonMenuItem;
    }

    private JCheckBoxMenuItem addCheckBoxMenuItem(String string, ActionListener actionListener, boolean bl) {
        String string2 = "MENU_" + string;
        String string3 = "MENU_" + string + "_ACCESSIBLE";
        String string4 = "MENU_" + string + "_MNEMONIC";
        String string5 = GUIMediator.getStringResource(string2);
        String string6 = GUIMediator.getStringResource(string3);
        int n = this.getCodeForCharKey(string4);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string5, bl);
        jCheckBoxMenuItem.setMnemonic(n);
        jCheckBoxMenuItem.getAccessibleContext().setAccessibleDescription(string6);
        jCheckBoxMenuItem.addActionListener(actionListener);
        this.MENU.add(jCheckBoxMenuItem);
        return jCheckBoxMenuItem;
    }

    private static class ShoppingViewListener
    implements ActionListener {
        private final int INDEX;

        private ShoppingViewListener(int n) {
            this.INDEX = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                GUIMediator.instance().setTabVisible(this.INDEX, abstractButton.isSelected());
                GUIMediator.instance().setWindow(this.INDEX);
                GUIMediator.instance().wakeupShoppingView();
            }
            catch (Exception exception) {
                GUIMediator.showInternalError(exception);
            }
        }
    }

    private static class ViewListener
    implements ActionListener {
        private final int INDEX;

        private ViewListener(int n) {
            this.INDEX = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                GUIMediator.instance().setTabVisible(this.INDEX, abstractButton.isSelected());
                GUIMediator.instance().setWindow(this.INDEX);
            }
            catch (Exception exception) {
                GUIMediator.showInternalError(exception);
            }
        }
    }
}

