/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MediaButton;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.mp3.AudioPlayer;
import com.limegroup.gnutella.gui.mp3.AudioPlayerListener;
import com.limegroup.gnutella.gui.mp3.BasicPlayer;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;
import com.limegroup.gnutella.gui.mp3.QuickTimeAudioPlayer;
import com.limegroup.gnutella.gui.mp3.SongProgressBar;
import com.limegroup.gnutella.settings.ThemeSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.LinkedList;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class MediaPlayerComponent
implements AudioPlayerListener,
RefreshListener,
ThemeObserver {
    private static AudioPlayer myPlayer;
    private JProgressBar myProgressBar;
    private static PlayListGUI myPlayList;
    private static PlayThread myPlayThread;
    private File myCurrentPlayingFile = null;
    private int currBeginIndex = -1;
    private static final int STRING_SIZE_TO_SHOW = 24;
    private static int lastButtonPressed;
    private static final int PLAY_BUTTON_INDEX = 0;
    private static final int PAUSE_BUTTON_INDEX = 1;
    private static final int STOP_BUTTON_INDEX = 2;
    private static final MediaButton PLAY_BUTTON;
    private static final MediaButton PAUSE_BUTTON;
    private static final MediaButton STOP_BUTTON;
    private static final MediaButton FORWARD_BUTTON;
    private static final MediaButton REWIND_BUTTON;
    private static MediaPlayerComponent myInstance;
    private JPanel myMediaPanel = null;
    private final String INITIAL_DISPLAY_STRING = GUIMediator.getStringResource("MEDIA_PLAYER_DEFAULT_STRING");
    private String currentFileName;
    private Object cfnLock = new Object();
    int iterations = 0;
    private final boolean debugOn = false;

    public MediaPlayerComponent() {
        myPlayer = CommonUtils.isMacOSX() ? new QuickTimeAudioPlayer() : new BasicPlayer();
        myPlayer.addAudioPlayerListener(this);
        myPlayThread = new PlayThread();
        myPlayThread.start();
        myInstance = this;
        GUIMediator.addRefreshListener(this);
        GUIMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        PLAY_BUTTON.updateTheme();
        PAUSE_BUTTON.updateTheme();
        STOP_BUTTON.updateTheme();
        FORWARD_BUTTON.updateTheme();
        REWIND_BUTTON.updateTheme();
        Dimension dimension = CommonUtils.isMacOSX() && ThemeSettings.THEME_FILE.getValue().equals(ThemeSettings.THEME_DEFAULT.getValue()) ? new Dimension(110, 25) : new Dimension(110, 15);
        this.myProgressBar.setMaximumSize(dimension);
        this.myProgressBar.setPreferredSize(dimension);
        this.myProgressBar.setString(this.INITIAL_DISPLAY_STRING);
    }

    private JPanel constructMediaPanel() {
        BoxPanel boxPanel = new BoxPanel(0);
        BoxPanel boxPanel2 = new BoxPanel(0);
        Object var3_3 = null;
        int n = 0;
        int n2 = 0;
        n += PLAY_BUTTON.getIcon().getIconWidth() + 2;
        n2 += PLAY_BUTTON.getIcon().getIconHeight() + 2;
        n += PAUSE_BUTTON.getIcon().getIconWidth() + 2;
        n += STOP_BUTTON.getIcon().getIconWidth() + 2;
        n += FORWARD_BUTTON.getIcon().getIconWidth() + 2;
        n += REWIND_BUTTON.getIcon().getIconWidth() + 2;
        this.myProgressBar = new SongProgressBar();
        Dimension dimension = CommonUtils.isMacOSX() ? new Dimension(110, 25) : new Dimension(110, 15);
        this.myProgressBar.setMaximumSize(dimension);
        this.myProgressBar.setPreferredSize(dimension);
        this.myProgressBar.setString(this.INITIAL_DISPLAY_STRING);
        PLAY_BUTTON.addActionListener(new PlayListener());
        PAUSE_BUTTON.addActionListener(new PauseListener());
        STOP_BUTTON.addActionListener(new StopListener());
        FORWARD_BUTTON.addActionListener(new NextListener());
        REWIND_BUTTON.addActionListener(new BackListener());
        this.myProgressBar.addChangeListener(new SeekChangeListener());
        this.updatePBValue(0);
        boxPanel2.add(Box.createHorizontalGlue());
        boxPanel2.setMaximumSize(new Dimension(n, n2));
        boxPanel2.setMinimumSize(new Dimension(n, n2));
        boxPanel2.add(REWIND_BUTTON);
        boxPanel2.add(PLAY_BUTTON);
        boxPanel2.add(PAUSE_BUTTON);
        boxPanel2.add(STOP_BUTTON);
        boxPanel2.add(FORWARD_BUTTON);
        boxPanel2.add(Box.createHorizontalGlue());
        boxPanel.add(Box.createVerticalGlue());
        boxPanel.add(boxPanel2);
        boxPanel.add(this.myProgressBar);
        boxPanel.add(Box.createVerticalGlue());
        BoxPanel boxPanel3 = boxPanel;
        boxPanel = new BoxPanel(0);
        boxPanel.add(Box.createHorizontalGlue());
        boxPanel.add(boxPanel3);
        myPlayList = PlayListGUI.instance();
        return boxPanel;
    }

    private void debug(String string) {
    }

    public JPanel getMediaPanel() {
        if (this.myMediaPanel == null) {
            this.myMediaPanel = this.constructMediaPanel();
        }
        return this.myMediaPanel;
    }

    public static void launchAudio(File file) {
        if (myInstance != null && file != null) {
            switch (myPlayer.getStatus()) {
                case 2: {
                    myPlayThread.addFileToPlay(file);
                    break;
                }
                case 0: {
                    myPlayer.stop();
                    myPlayThread.addFileToPlay(file);
                    break;
                }
                case 1: {
                    myPlayer.stop();
                    myPlayThread.addFileToPlay(file);
                }
            }
        }
    }

    void pauseSong() {
        if (myPlayer.getStatus() == 1) {
            if (myPlayer.getFrameSeek() != 0) {
                myPlayer.stop();
            } else {
                myPlayer.unpause();
            }
        } else {
            myPlayer.pause();
        }
    }

    public void playComplete() {
        this.updatePBValue(this.myProgressBar.getMaximum());
        this.updatePBString("");
        if (lastButtonPressed == 2 || !myPlayList.shouldRepeat()) {
            myPlayList.playComplete(true);
        } else {
            myPlayList.playComplete(false);
        }
        if (myPlayList.shouldRepeat() && lastButtonPressed != 2) {
            myPlayThread.addFileToPlay(myPlayList.getFileToPlay());
        }
    }

    private void playPressedAndPaused() {
        if (myPlayer.getStatus() == 1 && myPlayer.getFrameSeek() == 0) {
            myPlayer.unpause();
        }
    }

    public void setUpSeek(int n) {
        try {
            this.updatePBValue(0);
            this.updatePBMaximum(n);
            Object object = this.cfnLock;
            synchronized (object) {
                this.currentFileName = this.myCurrentPlayingFile.getName();
                if (this.currentFileName.length() > 24) {
                    this.currentFileName = this.currentFileName + " *** " + this.currentFileName + " *** ";
                }
            }
            this.updatePBString(this.currentFileName);
            this.currBeginIndex = -5;
        }
        catch (Exception exception) {
            GUIMediator.showInternalError(exception);
        }
    }

    void skipSong() {
        if (myPlayer.getStatus() == 0 && myPlayList.shouldRepeat()) {
            myPlayer.stop();
        }
    }

    public static void audioFileDoubleClicked() {
        if (myInstance == null) {
            return;
        }
        switch (myPlayer.getStatus()) {
            case 2: {
                lastButtonPressed = 0;
                myPlayThread.addFileToPlay(myPlayList.getFileToPlay());
                break;
            }
            case 0: {
                if (!myPlayList.shouldRepeat()) {
                    myPlayer.stop();
                    myPlayThread.addFileToPlay(myPlayList.getFileToPlay());
                    break;
                }
                myInstance.skipSong();
                break;
            }
            case 1: {
                if (!myPlayList.shouldRepeat()) {
                    myPlayer.stop();
                    myPlayThread.addFileToPlay(myPlayList.getFileToPlay());
                    break;
                }
                myPlayer.stop();
                myInstance.skipSong();
            }
        }
    }

    void stopSong() {
        myPlayer.stop();
    }

    private void updatePBMaximum(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MediaPlayerComponent.this.myProgressBar.setMaximum(n);
            }
        });
    }

    private void updatePBString(final String string) {
        if (string == null) {
            new Throwable().printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MediaPlayerComponent.this.myProgressBar.setString(string);
            }
        });
    }

    private void updatePBValue(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MediaPlayerComponent.this.myProgressBar.setValue(n);
            }
        });
    }

    public void updateAudioPosition(int n) {
        this.updatePBValue(n);
        Object object = this.cfnLock;
        synchronized (object) {
            if (this.currentFileName == null) {
                return;
            }
            if (this.currentFileName.length() <= 24) {
                return;
            }
            this.currBeginIndex += 5;
            if (this.currBeginIndex + 24 > this.currentFileName.length()) {
                this.currBeginIndex -= this.currentFileName.length() / 2;
            }
            this.updatePBString(this.currentFileName.substring(this.currBeginIndex, this.currBeginIndex + 24));
        }
    }

    public void refresh() {
        myPlayer.refresh();
    }

    static {
        myPlayThread = null;
        lastButtonPressed = -1;
        PLAY_BUTTON = new MediaButton("MEDIA_PLAY_BUTTON_TIP", "play_up.gif", "play_dn.gif");
        PAUSE_BUTTON = new MediaButton("MEDIA_PAUSE_BUTTON_TIP", "pause_up.gif", "pause_dn.gif");
        STOP_BUTTON = new MediaButton("MEDIA_STOP_BUTTON_TIP", "stop_up.gif", "stop_dn.gif");
        FORWARD_BUTTON = new MediaButton("MEDIA_FORWARD_BUTTON_TIP", "forward_up.gif", "forward_dn.gif");
        REWIND_BUTTON = new MediaButton("MEDIA_REWIND_BUTTON_TIP", "rewind_up.gif", "rewind_dn.gif");
    }

    private class PlayThread
    extends Thread {
        private LinkedList list = new LinkedList();
        private Object lock = new Object();
        private boolean shouldRun = true;

        private PlayThread() {
        }

        private void shutdown() {
            this.shouldRun = false;
        }

        public void run() {
            MediaPlayerComponent.this.debug("PlayThread.run(): entered.");
            while (this.shouldRun) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.list.isEmpty()) {
                        try {
                            MediaPlayerComponent.this.debug("PlayThread.run(): waiting for a file.");
                            this.lock.wait();
                            MediaPlayerComponent.this.debug("PlayThread.run(): woken up.");
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                Assert.that(!this.list.isEmpty());
                MediaPlayerComponent.this.debug("PlayThread.run(): myPlayer.getStatus() = " + myPlayer.getStatus());
                if (myPlayer.getStatus() != 2) continue;
                File file = null;
                while (!this.list.isEmpty()) {
                    file = this.getFileToPlay();
                    try {
                        if (this.list.isEmpty()) {
                            Thread.sleep(250L);
                            continue;
                        }
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                MediaPlayerComponent.this.debug("PlayThread.run(): playing file " + file);
                MediaPlayerComponent.this.myCurrentPlayingFile = file;
                myPlayer.play(file);
            }
        }

        public void addFileToPlay(File file) {
            if (file != null) {
                Object object = this.lock;
                synchronized (object) {
                    this.list.addLast(file);
                    this.lock.notify();
                }
            }
        }

        private File getFileToPlay() {
            File file = null;
            Object object = this.lock;
            synchronized (object) {
                file = (File)this.list.removeFirst();
            }
            return file;
        }
    }

    private class SeekChangeListener
    implements ChangeListener {
        private SeekChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
        }
    }

    private class PauseListener
    implements ActionListener {
        private PauseListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                MediaPlayerComponent.this.pauseSong();
            }
            catch (Exception exception) {
                GUIMediator.showInternalError(exception);
            }
        }
    }

    private class BackListener
    implements ActionListener {
        private BackListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (myPlayer.getStatus() != 2) {
                    myPlayList.setBackwardsMode();
                    if (myPlayer.getStatus() == 1) {
                        myPlayer.unpause();
                    }
                    MediaPlayerComponent.this.skipSong();
                }
            }
            catch (Exception exception) {
                GUIMediator.showInternalError(exception);
            }
        }
    }

    private class NextListener
    implements ActionListener {
        private NextListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (myPlayer.getStatus() != 2) {
                    if (myPlayer.getStatus() == 1) {
                        myPlayer.unpause();
                    }
                    MediaPlayerComponent.this.skipSong();
                }
            }
            catch (Exception exception) {
                GUIMediator.showInternalError(exception);
            }
        }
    }

    private class StopListener
    implements ActionListener {
        private StopListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                lastButtonPressed = 2;
                MediaPlayerComponent.this.stopSong();
            }
            catch (Exception exception) {
                GUIMediator.showInternalError(exception);
            }
        }
    }

    private class PlayListener
    implements ActionListener {
        private PlayListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                lastButtonPressed = 0;
                if (myPlayer.getStatus() == 1) {
                    MediaPlayerComponent.this.playPressedAndPaused();
                } else if (myPlayer.getStatus() == 2) {
                    myPlayThread.addFileToPlay(myPlayList.getFileToPlay());
                } else if (myPlayer.getStatus() == 0 && myPlayList.songIsSelected()) {
                    MediaPlayerComponent.this.skipSong();
                }
            }
            catch (Exception exception) {
                GUIMediator.showInternalError(exception);
            }
        }
    }
}

