/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.mp3.MP3Info;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Random;
import com.sun.java.util.collections.Vector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;

public class PlayList {
    private File _file;
    private Vector _songs;
    private Vector _newSongs;
    private int _currPlaying = -1;
    private boolean _songDeleted = false;
    private boolean _backwardsMode = false;
    private int _lastIndexPlayed = 0;
    private boolean _shuffleSongs = false;
    Random rand = new Random();
    private static final String M3U_HEADER = "#EXTM3U";
    private static final String SONG_DELIM = "#EXTINF";
    private static final String SEC_DELIM = ":";
    private boolean _sortAscending = true;
    private final boolean debugOn = false;

    public int getCurrSongIndex() {
        this.debug("PlayList.getCurrSongIndex(): current index = " + this._currPlaying);
        return this._currPlaying;
    }

    int setCurrSongIndex(int n) {
        this._currPlaying = n;
        return this._currPlaying;
    }

    public void setBackwardsMode() {
        this._backwardsMode = true;
    }

    public boolean isShuffled() {
        return this._shuffleSongs;
    }

    public void toggleShuffle() {
        this._shuffleSongs = !this._shuffleSongs;
        this.debug("PlayList.toggleShuffle(): shuffle? " + this._shuffleSongs);
    }

    public PlayList(String string) throws Exception {
        this.debug("PlayList(): entered.");
        this._file = new File(string);
        if (this._file.isDirectory()) {
            throw new Exception();
        }
        this._songs = new Vector();
        if (this._file.exists()) {
            this.loadM3UFile();
        }
        this._newSongs = new Vector();
        this.debug("PlayList(): songs = " + this._songs);
        this.debug("PlayList(): returning.  size is now " + this.getNumSongs());
    }

    private void loadM3UFile() throws Exception {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this._file));
            String string = null;
            string = bufferedReader.readLine();
            if (!string.startsWith(M3U_HEADER)) {
                throw new Exception();
            }
            string = bufferedReader.readLine();
            while (string != null) {
                File file;
                if (string.startsWith(SONG_DELIM) && (file = new File(string = bufferedReader.readLine())).exists() && !file.isDirectory()) {
                    this._songs.add(file);
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception();
        }
    }

    public synchronized void save() throws Exception {
        try {
            if (this._songs.size() == 0 && this._file.exists()) {
                this._file.delete();
            }
            boolean bl = this._file.exists();
            FileWriter fileWriter = new FileWriter(this._file.getCanonicalPath(), true);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            if (!bl) {
                printWriter.write(M3U_HEADER);
                printWriter.println();
            }
            int n = 0;
            while (n < this._newSongs.size()) {
                File file = (File)this._newSongs.get(n);
                printWriter.write(SONG_DELIM);
                printWriter.write(SEC_DELIM);
                try {
                    MP3Info mP3Info = new MP3Info(file.getCanonicalPath());
                    printWriter.write("" + mP3Info.getLengthInSeconds() + ",");
                }
                catch (Exception exception) {
                    printWriter.write("-1,");
                }
                printWriter.write(file.getName());
                printWriter.println();
                printWriter.write(file.getCanonicalPath());
                printWriter.println();
                this._songs.add(file);
                ++n;
            }
            printWriter.flush();
            printWriter.close();
            this._songDeleted = false;
            this._newSongs.clear();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception();
        }
    }

    public int getNumSongs() {
        return this._songs.size() + this._newSongs.size();
    }

    public int addSong(String string) {
        return this.addSong(new File(string));
    }

    public synchronized void deleteSong(int n) {
        if (!this._songDeleted) {
            Vector vector = this._newSongs;
            this._newSongs = new Vector();
            int n2 = 0;
            while (n2 < this._songs.size()) {
                this._newSongs.add(this._songs.get(n2));
                ++n2;
            }
            int n3 = 0;
            while (n3 < vector.size()) {
                this._newSongs.add(vector.get(n3));
                ++n3;
            }
            this._songs.clear();
            vector = null;
            this._songDeleted = true;
        }
        if (n >= 0 && n < this._newSongs.size()) {
            this._newSongs.remove(n);
        }
        if (this._currPlaying == n) {
            this._currPlaying = -1;
        } else if (this._currPlaying > n) {
            --this._currPlaying;
        }
        if (this._lastIndexPlayed == n) {
            this._lastIndexPlayed = 0;
        }
    }

    public int addSong(File file) {
        int n = -1;
        if (file.exists() && !file.isDirectory()) {
            n = this.getNumSongs();
            this._newSongs.add(file);
        }
        return n;
    }

    private int getNextSongIndex() {
        this.debug("PlayList.getNextSongIndex(): BEFORE _currPlaying = " + this._currPlaying);
        if (this.isShuffled()) {
            if (this._backwardsMode) {
                this._currPlaying = this._lastIndexPlayed;
                this._backwardsMode = false;
            } else {
                int n = this._currPlaying;
                if (this._currPlaying > -1) {
                    this._lastIndexPlayed = this._currPlaying;
                }
                do {
                    this._currPlaying = this.rand.nextInt(this.getNumSongs());
                } while (n == this._currPlaying && this.getNumSongs() > 1);
            }
        } else if (this._backwardsMode) {
            --this._currPlaying;
            if (this._currPlaying < 0) {
                this._currPlaying = this.getNumSongs() - 1;
            }
            this._backwardsMode = false;
        } else if (++this._currPlaying == this.getNumSongs()) {
            this._currPlaying = 0;
        }
        this.debug("PlayList.getNextSongIndex(): AFTER _currPlaying = " + this._currPlaying);
        return this._currPlaying;
    }

    public File getNextSong() {
        File file = null;
        Vector vector = this._songs;
        synchronized (vector) {
            if (this.getNumSongs() > 0) {
                int n = this.getNextSongIndex();
                file = n < this._songs.size() ? (File)this._songs.get(n) : (File)this._newSongs.get(n - this._songs.size());
            }
        }
        return file;
    }

    public File getSong(int n) {
        File file = null;
        if (n < this.getNumSongs()) {
            file = n < this._songs.size() ? (File)this._songs.get(n) : (File)this._newSongs.get(n - this._songs.size());
        }
        return file;
    }

    public int getIndexOfSong(File file) {
        int n = -1;
        if (this._songs.contains(file)) {
            n = this._songs.indexOf(file);
        } else if (this._newSongs.contains(file)) {
            n = this._songs.size() + this._newSongs.indexOf(file);
        }
        return n;
    }

    public synchronized void sortByName() {
        this.deleteSong(-1);
        this._currPlaying = -1;
        Collections.sort(this._newSongs, new PlayListSorter());
        this._sortAscending = !this._sortAscending;
    }

    private void debug(String string) {
    }

    public static void main(String[] stringArray) throws Exception {
        PlayList playList = new PlayList(stringArray[0]);
        System.out.println("Number of songs: " + playList.getNumSongs());
        System.out.println("----------------------------");
        int n = 0;
        while (n < playList.getNumSongs()) {
            System.out.println("" + playList.getSong(n));
            ++n;
        }
        System.out.println("----------------------------");
        playList.toggleShuffle();
        int n2 = 0;
        while (n2 < playList.getNumSongs()) {
            System.out.println("" + playList.getNextSong());
            ++n2;
        }
        System.out.println("----------------------------");
        if (playList.getNumSongs() > 0) {
            playList.addSong(playList.getSong(0));
        } else {
            playList.addSong(new File("./limewire.props"));
            playList.addSong(new File("./gnutella.net"));
        }
        System.out.println("" + playList.getSong(playList.getNumSongs() - 1));
        playList.save();
    }

    private class PlayListSorter
    implements Comparator {
        private PlayListSorter() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            try {
                File file = (File)object;
                File file2 = (File)object2;
                String string = file.getName();
                String string2 = file2.getName();
                n = PlayList.this._sortAscending ? string.toLowerCase().compareTo(string2.toLowerCase()) : string2.toLowerCase().compareTo(string.toLowerCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return n;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            return bl;
        }
    }
}

