/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.options.OptionsButtonPanel;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.options.OptionsPane;
import com.limegroup.gnutella.gui.options.OptionsPaneImpl;
import com.limegroup.gnutella.gui.options.OptionsPaneManager;
import com.limegroup.gnutella.gui.options.OptionsTreeManager;
import com.limegroup.gnutella.gui.options.panes.AllowMessagesPaneItem;
import com.limegroup.gnutella.gui.options.panes.AutoClearDownloadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.AutoClearUploadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.BrowserPaneItem;
import com.limegroup.gnutella.gui.options.panes.ChatActivePaneItem;
import com.limegroup.gnutella.gui.options.panes.ConnectOnStartupPaneItem;
import com.limegroup.gnutella.gui.options.panes.ConnectionPreferencingPaneItem;
import com.limegroup.gnutella.gui.options.panes.DisableSupernodeModePaneItem;
import com.limegroup.gnutella.gui.options.panes.ExtensionsPaneItem;
import com.limegroup.gnutella.gui.options.panes.ForceIPPaneItem;
import com.limegroup.gnutella.gui.options.panes.IgnoreMessagesPaneItem;
import com.limegroup.gnutella.gui.options.panes.IgnoreResultTypesPaneItem;
import com.limegroup.gnutella.gui.options.panes.IgnoreResultsPaneItem;
import com.limegroup.gnutella.gui.options.panes.MaximumDownloadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.MaximumSearchesPaneItem;
import com.limegroup.gnutella.gui.options.panes.MaximumUploadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.PerPersonUploadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.PlayerPreferencePaneItem;
import com.limegroup.gnutella.gui.options.panes.PortPaneItem;
import com.limegroup.gnutella.gui.options.panes.PurgeIncompletePaneItem;
import com.limegroup.gnutella.gui.options.panes.SaveDirPaneItem;
import com.limegroup.gnutella.gui.options.panes.SearchQualityPaneItem;
import com.limegroup.gnutella.gui.options.panes.SearchSpeedPaneItem;
import com.limegroup.gnutella.gui.options.panes.SharedDirPaneItem;
import com.limegroup.gnutella.gui.options.panes.ShutdownPaneItem;
import com.limegroup.gnutella.gui.options.panes.SoftMaximumUploadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.SpeedPaneItem;
import com.limegroup.gnutella.gui.options.panes.UploadBandwidthPaneItem;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JDialog;

public final class OptionsConstructor {
    private final JDialog DIALOG;
    private final int OPTIONS_WIDTH = 600;
    private final int OPTIONS_HEIGHT = 420;
    private final OptionsTreeManager TREE_MANAGER;
    private final OptionsPaneManager PANE_MANAGER;

    public OptionsConstructor(OptionsTreeManager optionsTreeManager, OptionsPaneManager optionsPaneManager) {
        OptionsPaneImpl optionsPaneImpl;
        this.TREE_MANAGER = optionsTreeManager;
        this.PANE_MANAGER = optionsPaneManager;
        String string = GUIMediator.getStringResource("OPTIONS_TITLE");
        this.DIALOG = new JDialog(GUIMediator.getAppFrame(), string, true);
        if (CommonUtils.isWindows() || CommonUtils.isMacClassic() || CommonUtils.isMacOSX()) {
            this.DIALOG.setResizable(false);
        }
        ((Component)this.DIALOG).setSize(600, 420);
        if (CommonUtils.isAnyMac()) {
            this.DIALOG.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    try {
                        OptionsMediator.instance().applyOptions();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        PaddedPanel paddedPanel = new PaddedPanel();
        Box box = new Box(0);
        Component component = this.TREE_MANAGER.getComponent();
        Component component2 = this.PANE_MANAGER.getComponent();
        box.add(component);
        box.add(component2);
        paddedPanel.add(box);
        paddedPanel.add(Box.createVerticalStrut(17));
        paddedPanel.add(new OptionsButtonPanel().getComponent());
        this.DIALOG.getContentPane().add(paddedPanel);
        OptionsPaneImpl optionsPaneImpl2 = new OptionsPaneImpl("OPTIONS_SAVE_MAIN_TITLE");
        optionsPaneImpl2.add(new SaveDirPaneItem("SAVE_DIR"));
        optionsPaneImpl2.add(new PurgeIncompletePaneItem("PURGE_INCOMPLETE_TIME"));
        this.addOption("OPTIONS_ROOT_NODE", optionsPaneImpl2);
        OptionsPaneImpl optionsPaneImpl3 = new OptionsPaneImpl("OPTIONS_SHARED_MAIN_TITLE");
        optionsPaneImpl3.add(new SharedDirPaneItem("SHARED_DIRS"));
        optionsPaneImpl3.add(new ExtensionsPaneItem("SHARED_EXTENSIONS"));
        this.addOption("OPTIONS_ROOT_NODE", optionsPaneImpl3);
        OptionsPaneImpl optionsPaneImpl4 = new OptionsPaneImpl("OPTIONS_SPEED_MAIN_TITLE");
        optionsPaneImpl4.add(new SpeedPaneItem("SPEED"));
        optionsPaneImpl4.add(new DisableSupernodeModePaneItem("DISABLE_SUPERNODE_MODE"));
        this.addOption("OPTIONS_ROOT_NODE", optionsPaneImpl4);
        OptionsPaneImpl optionsPaneImpl5 = new OptionsPaneImpl("OPTIONS_DOWNLOAD_MAIN_TITLE");
        optionsPaneImpl5.add(new MaximumDownloadsPaneItem("DOWNLOAD_MAX"));
        optionsPaneImpl5.add(new AutoClearDownloadsPaneItem("DOWNLOAD_CLEAR"));
        this.addOption("OPTIONS_ROOT_NODE", optionsPaneImpl5);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", "OPTIONS_UPLOAD_MAIN_TITLE");
        OptionsPaneImpl optionsPaneImpl6 = new OptionsPaneImpl("OPTIONS_UPLOAD_BASIC_MAIN_TITLE");
        optionsPaneImpl6.add(new AutoClearUploadsPaneItem("UPLOAD_CLEAR"));
        optionsPaneImpl6.add(new UploadBandwidthPaneItem("UPLOAD_BANDWIDTH"));
        this.addOption("OPTIONS_UPLOAD_MAIN_TITLE", optionsPaneImpl6);
        OptionsPaneImpl optionsPaneImpl7 = new OptionsPaneImpl("OPTIONS_UPLOAD_SLOTS_MAIN_TITLE");
        optionsPaneImpl7.add(new PerPersonUploadsPaneItem("UPLOAD_PER_PERSON"));
        optionsPaneImpl7.add(new SoftMaximumUploadsPaneItem("UPLOAD_SOFT_MAX"));
        optionsPaneImpl7.add(new MaximumUploadsPaneItem("UPLOAD_MAX"));
        this.addOption("OPTIONS_UPLOAD_MAIN_TITLE", optionsPaneImpl7);
        OptionsPaneImpl optionsPaneImpl8 = new OptionsPaneImpl("OPTIONS_CONNECTIONS_MAIN_TITLE");
        optionsPaneImpl8.add(new ConnectOnStartupPaneItem("CONNECT_ON_STARTUP"));
        this.addOption("OPTIONS_ROOT_NODE", optionsPaneImpl8);
        OptionsPaneImpl optionsPaneImpl9 = new OptionsPaneImpl("OPTIONS_SHUTDOWN_MAIN_TITLE");
        optionsPaneImpl9.add(new ShutdownPaneItem("SHUTDOWN"));
        this.addOption("OPTIONS_ROOT_NODE", optionsPaneImpl9);
        OptionsPaneImpl optionsPaneImpl10 = new OptionsPaneImpl("OPTIONS_CHAT_MAIN_TITLE");
        optionsPaneImpl10.add(new ChatActivePaneItem("CHAT_ACTIVE"));
        this.addOption("OPTIONS_ROOT_NODE", optionsPaneImpl10);
        if (!CommonUtils.isMacClassic()) {
            optionsPaneImpl = new OptionsPaneImpl("OPTIONS_PLAYER_MAIN_TITLE");
            optionsPaneImpl.add(new PlayerPreferencePaneItem("PLAYER_PREFERENCE"));
            this.addOption("OPTIONS_ROOT_NODE", optionsPaneImpl);
        }
        if (CommonUtils.isUnix()) {
            optionsPaneImpl = new OptionsPaneImpl("OPTIONS_BROWSER_MAIN_TITLE");
            optionsPaneImpl.add(new BrowserPaneItem("BROWSER_PREFERENCE"));
            this.addOption("OPTIONS_ROOT_NODE", optionsPaneImpl);
        }
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", "OPTIONS_SEARCH_MAIN_TITLE");
        optionsPaneImpl = new OptionsPaneImpl("OPTIONS_SEARCH_LIMIT_MAIN_TITLE");
        optionsPaneImpl.add(new MaximumSearchesPaneItem("SEARCH_MAX"));
        this.addOption("OPTIONS_SEARCH_MAIN_TITLE", optionsPaneImpl);
        OptionsPaneImpl optionsPaneImpl11 = new OptionsPaneImpl("OPTIONS_SEARCH_QUALITY_MAIN_TITLE");
        optionsPaneImpl11.add(new SearchQualityPaneItem("SEARCH_QUALITY"));
        this.addOption("OPTIONS_SEARCH_MAIN_TITLE", optionsPaneImpl11);
        OptionsPaneImpl optionsPaneImpl12 = new OptionsPaneImpl("OPTIONS_SEARCH_SPEED_MAIN_TITLE");
        optionsPaneImpl12.add(new SearchSpeedPaneItem("SEARCH_SPEED"));
        this.addOption("OPTIONS_SEARCH_MAIN_TITLE", optionsPaneImpl12);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", "OPTIONS_FILTERS_MAIN_TITLE");
        OptionsPaneImpl optionsPaneImpl13 = new OptionsPaneImpl("OPTIONS_RESULTS_MAIN_TITLE");
        optionsPaneImpl13.add(new IgnoreResultsPaneItem("IGNORE_RESULTS"));
        optionsPaneImpl13.add(new IgnoreResultTypesPaneItem("IGNORE_RESULT_TYPES"));
        this.addOption("OPTIONS_FILTERS_MAIN_TITLE", optionsPaneImpl13);
        OptionsPaneImpl optionsPaneImpl14 = new OptionsPaneImpl("OPTIONS_MESSAGES_MAIN_TITLE");
        optionsPaneImpl14.add(new IgnoreMessagesPaneItem("IGNORE_MESSAGES"));
        optionsPaneImpl14.add(new AllowMessagesPaneItem("ALLOW_MESSAGES"));
        this.addOption("OPTIONS_FILTERS_MAIN_TITLE", optionsPaneImpl14);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", "OPTIONS_ADVANCED_MAIN_TITLE");
        OptionsPaneImpl optionsPaneImpl15 = new OptionsPaneImpl("OPTIONS_PREFERENCING_MAIN_TITLE");
        optionsPaneImpl15.add(new ConnectionPreferencingPaneItem("CONNECT_PREF"));
        this.addOption("OPTIONS_ADVANCED_MAIN_TITLE", optionsPaneImpl15);
        OptionsPaneImpl optionsPaneImpl16 = new OptionsPaneImpl("OPTIONS_PORT_MAIN_TITLE");
        optionsPaneImpl16.add(new PortPaneItem("PORT"));
        this.addOption("OPTIONS_ADVANCED_MAIN_TITLE", optionsPaneImpl16);
        OptionsPaneImpl optionsPaneImpl17 = new OptionsPaneImpl("OPTIONS_FIREWALL_MAIN_TITLE");
        optionsPaneImpl17.add(new ForceIPPaneItem("FORCE_IP"));
        this.addOption("OPTIONS_ADVANCED_MAIN_TITLE", optionsPaneImpl17);
    }

    private final void addGroupTreeNode(String string, String string2) {
        this.TREE_MANAGER.addNode(string, string2, GUIMediator.getStringResource(string2));
    }

    private final void addOption(String string, OptionsPane optionsPane) {
        this.TREE_MANAGER.addNode(string, optionsPane.getName(), GUIMediator.getStringResource(optionsPane.getName()));
        this.PANE_MANAGER.addPane(optionsPane);
    }

    public final void setOptionsVisible(boolean bl) {
        if (bl) {
            this.DIALOG.setLocationRelativeTo(GUIMediator.getAppFrame());
            this.DIALOG.show();
        } else {
            this.DIALOG.dispose();
        }
    }

    public final boolean isOptionsVisible() {
        return this.DIALOG.isVisible();
    }

    JDialog getMainOptionsComponent() {
        return this.DIALOG;
    }
}

