/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JTextField;

public final class SaveDirPaneItem
extends AbstractPaneItem {
    private final String OPTION_LABEL = "OPTIONS_SAVE_DIR_BOX_LABEL";
    private JTextField _saveField = new SizedTextField();
    private String _saveDirectory;

    public SaveDirPaneItem(String string) {
        super(string);
        LabeledComponent labeledComponent = new LabeledComponent("OPTIONS_SAVE_DIR_BOX_LABEL", this._saveField, 13);
        String[] stringArray = new String[]{"OPTIONS_SAVE_DIR_BROWSE_BUTTON_LABEL", "OPTIONS_SAVE_DIR_DEFAULT_BUTTON_LABEL"};
        String[] stringArray2 = new String[]{"OPTIONS_SAVE_DIR_BROWSE_BUTTON_TIP", "OPTIONS_SAVE_DIR_DEFAULT_BUTTON_TIP"};
        ActionListener[] actionListenerArray = new ActionListener[]{new SelectSaveDirectoryListener(), new DefaultListener()};
        ButtonRow buttonRow = new ButtonRow(stringArray, stringArray2, actionListenerArray, 0, 12);
        this.add(labeledComponent.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(buttonRow);
    }

    public void initOptions() {
        try {
            this._saveDirectory = AbstractPaneItem.SETTINGS.getSaveDirectory().getCanonicalPath();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this._saveDirectory = "";
        }
        catch (IOException iOException) {
            this._saveDirectory = "";
        }
        this._saveField.setText(this._saveDirectory);
    }

    public void applyOptions() throws IOException {
        String string = this._saveField.getText();
        if (!string.equals(this._saveDirectory)) {
            AbstractPaneItem.MEDIATOR.setSaveDirectoryChanged(true);
            try {
                File file = new File(string);
                AbstractPaneItem.SETTINGS.setSaveDirectory(file);
                this._saveDirectory = string;
            }
            catch (IOException iOException) {
                GUIMediator.showError("ERROR_INVALID_SAVE_DIRECTORY");
                this._saveField.setText(this._saveDirectory);
                throw new IOException();
            }
            catch (NullPointerException nullPointerException) {
                GUIMediator.showError("ERROR_INVALID_SAVE_DIRECTORY");
                this._saveField.setText(this._saveDirectory);
                throw new IOException();
            }
        }
    }

    private class SelectSaveDirectoryListener
    implements ActionListener {
        private SelectSaveDirectoryListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = FileChooserHandler.getInputDirectory(AbstractPaneItem.MEDIATOR.getMainOptionsComponent());
            if (file == null) {
                return;
            }
            if (!file.isDirectory()) {
                return;
            }
            String string = "";
            try {
                string = file.getCanonicalPath();
                if (!string.equals(SaveDirPaneItem.this._saveDirectory)) {
                    AbstractPaneItem.MEDIATOR.setSaveDirectoryChanged(true);
                    SaveDirPaneItem.this._saveField.setText(string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class DefaultListener
    implements ActionListener {
        private DefaultListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SaveDirPaneItem.this._saveField.setText(AbstractPaneItem.SETTINGS.getSaveDefault().getAbsolutePath());
        }
    }
}

