/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JComboBox;

public final class SpeedPaneItem
extends AbstractPaneItem {
    private final String[] SPEED_MENU_ITEMS = new String[]{GUIConstants.MODEM_SPEED, GUIConstants.CABLE_SPEED, GUIConstants.T1_SPEED, GUIConstants.T3_SPEED};
    private final String OPTION_LABEL = "OPTIONS_SPEED_BOX_LABEL";
    private final JComboBox SPEED_BOX = new JComboBox<String>(this.SPEED_MENU_ITEMS);
    private String _speed;

    public SpeedPaneItem(String string) {
        super(string);
        this.SPEED_BOX.setMaximumSize(new Dimension(10, 25));
        LabeledComponent labeledComponent = new LabeledComponent("OPTIONS_SPEED_BOX_LABEL", this.SPEED_BOX, 120);
        this.add(labeledComponent.getComponent());
    }

    public void initOptions() {
        this._speed = this.getSpeedString(AbstractPaneItem.SETTINGS.getConnectionSpeed());
        this.SPEED_BOX.setSelectedItem(this._speed);
    }

    public void applyOptions() throws IOException {
        String string = (String)this.SPEED_BOX.getSelectedItem();
        if (!string.equals(this._speed)) {
            int n = this.getSpeedInt(string);
            AbstractPaneItem.SETTINGS.setConnectionSpeed(n);
            this._speed = string;
        }
    }

    private String getSpeedString(int n) {
        String string = n == 56 ? GUIConstants.MODEM_SPEED : (n == 350 ? GUIConstants.CABLE_SPEED : (n == 1000 ? GUIConstants.T1_SPEED : (n == 3000 ? GUIConstants.T3_SPEED : GUIConstants.MODEM_SPEED)));
        return string;
    }

    private int getSpeedInt(String string) {
        int n = string.equals(GUIConstants.MODEM_SPEED) ? 56 : (string.equals(GUIConstants.CABLE_SPEED) ? 350 : (string.equals(GUIConstants.T1_SPEED) ? 1000 : (string.equals(GUIConstants.T3_SPEED) ? 3000 : 56)));
        return n;
    }
}

