/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ThemeSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public final class ThemePaneItem
extends AbstractPaneItem {
    private final String OPTION_LABEL = "OPTIONS_THEME_BOX_LABEL";
    private JTextField _themeField = new SizedTextField();

    public ThemePaneItem(String string) {
        super(string);
        LabeledComponent labeledComponent = new LabeledComponent("OPTIONS_THEME_BOX_LABEL", this._themeField, 13);
        String[] stringArray = new String[]{"GENERAL_BROWSE_BUTTON_LABEL", "GENERAL_DEFAULT_BUTTON_LABEL"};
        String[] stringArray2 = new String[]{"OPTIONS_THEME_BROWSE_BUTTON_TIP", "OPTIONS_THEME_DEFAULT_BUTTON_TIP"};
        ActionListener[] actionListenerArray = new ActionListener[]{new SelectThemeFileListener(), new DefaultListener()};
        ButtonRow buttonRow = new ButtonRow(stringArray, stringArray2, actionListenerArray, 0, 12);
        this.add(labeledComponent.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(buttonRow);
    }

    public void initOptions() {
        this._themeField.setText(ThemeSettings.THEME_FILE.getValue().getAbsolutePath());
    }

    public void applyOptions() throws IOException {
        String string = this._themeField.getText();
        File file = new File(string);
        if (!file.isFile()) {
            throw new IOException("theme file is not a valid file");
        }
        if (!ThemeSettings.THEME_FILE.getValue().equals(file)) {
            ThemeSettings.THEME_FILE.setValue(file);
            GUIMediator.showMessage("THEME_CHANGED_MESSAGE");
        }
    }

    private static class ThemeFileFilter
    extends FileFilter {
        private ThemeFileFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            if (string.endsWith("lwtp")) {
                boolean bl = !CommonUtils.isMacOSX() ? !string.equals("default_osx_theme.lwtp") : true;
                if (bl) {
                    return true;
                }
            }
            return false;
        }

        public String getDescription() {
            return GUIMediator.getStringResource("THEME_FILE_DESCRIPTION");
        }
    }

    private class SelectThemeFileListener
    implements ActionListener {
        private SelectThemeFileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            File file = null;
            if (!CommonUtils.isMacOSX() || !ThemeSettings.isDefaultTheme()) {
                object = new JFileChooser(new File(CommonUtils.getUserSettingsDir(), "themes"));
                ((JFileChooser)object).setFileFilter(new ThemeFileFilter());
                int n = ((JFileChooser)object).showOpenDialog(AbstractPaneItem.MEDIATOR.getMainOptionsComponent());
                if (n != 0) {
                    return;
                }
                file = ((JFileChooser)object).getSelectedFile();
            } else {
                object = "OPTIONS_THEME_FILE_CHOOSER_TITLE";
                FileDialog fileDialog = new FileDialog((Frame)GUIMediator.getAppFrame(), GUIMediator.getStringResource((String)object), 0);
                ((Component)fileDialog).setVisible(true);
                String string = fileDialog.getDirectory();
                String string2 = fileDialog.getFile();
                if (string == null || string2 == null) {
                    return;
                }
                file = new File(string, string2);
            }
            if (file == null) {
                return;
            }
            if (!file.isFile()) {
                return;
            }
            object = file.getAbsolutePath();
            ThemePaneItem.this._themeField.setText((String)object);
        }
    }

    private class DefaultListener
    implements ActionListener {
        private DefaultListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ThemePaneItem.this._themeField.setText(ThemeSettings.THEME_DEFAULT.getValue().getAbsolutePath());
        }
    }
}

