/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.sun.java.util.collections.Hashtable;
import java.awt.Font;
import java.io.IOException;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class UploadBandwidthPaneItem
extends AbstractPaneItem {
    private final String LABEL_LABEL = "OPTIONS_UPLOAD_BANDWIDTH_SLIDER_LABEL_LABEL";
    private final String SLIDER_MAX_LABEL = "OPTIONS_UPLOAD_BANDWIDTH_SLIDER_MAX_LABEL";
    private WholeNumberField _ttlField;
    private final JSlider UPLOAD_SLIDER = new JSlider(25, 100);
    private final JLabel SLIDER_LABEL = new JLabel();
    private int _uploadThrottle;

    public UploadBandwidthPaneItem(String string) {
        super(string);
        this.UPLOAD_SLIDER.setMajorTickSpacing(10);
        this.UPLOAD_SLIDER.setPaintTicks(true);
        Hashtable hashtable = new Hashtable();
        JLabel jLabel = new JLabel("25%");
        JLabel jLabel2 = new JLabel("100%");
        Font font = new Font("Helvetica", 1, 10);
        jLabel.setFont(font);
        jLabel2.setFont(font);
        hashtable.put(new Integer(25), jLabel);
        hashtable.put(new Integer(100), jLabel2);
        this.UPLOAD_SLIDER.setLabelTable(hashtable);
        this.UPLOAD_SLIDER.setPaintLabels(true);
        this.UPLOAD_SLIDER.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                UploadBandwidthPaneItem.this.handleThrottleLabel();
            }
        });
        LabeledComponent labeledComponent = new LabeledComponent("OPTIONS_UPLOAD_BANDWIDTH_SLIDER_LABEL_LABEL", this.SLIDER_LABEL, 120);
        this.add(this.UPLOAD_SLIDER);
        this.add(this.getVerticalSeparator());
        this.add(labeledComponent.getComponent());
    }

    private void handleThrottleLabel() {
        float f = this.UPLOAD_SLIDER.getValue();
        String string = "";
        if (f == 100.0f) {
            string = AbstractPaneItem.MEDIATOR.getString("OPTIONS_UPLOAD_BANDWIDTH_SLIDER_MAX_LABEL");
        } else {
            Float f2 = new Float((double)this.UPLOAD_SLIDER.getValue() / 100.0 * (double)AbstractPaneItem.SETTINGS.getConnectionSpeed() / 8.0);
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(2);
            string = String.valueOf(numberFormat.format(f2)) + " KB/s";
        }
        this.SLIDER_LABEL.setText(string);
    }

    public void initOptions() {
        this._uploadThrottle = AbstractPaneItem.SETTINGS.getUploadSpeed();
        this.UPLOAD_SLIDER.setValue(this._uploadThrottle);
        this.handleThrottleLabel();
    }

    public void applyOptions() throws IOException {
        int n = this.UPLOAD_SLIDER.getValue();
        if (n != this._uploadThrottle) {
            AbstractPaneItem.SETTINGS.setUploadSpeed(n);
            this._uploadThrottle = n;
        }
    }
}

