/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.sun.java.util.collections.HashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;

public class DisplayManager {
    private static DisplayManager instance;
    private Properties props;
    private final String DISP_FILE = "Display.props";
    private HashMap schemaURIToDispProps = new HashMap();
    static final int QUALITY_COL = 0;
    static final int GROUP_COUNT = 1;
    static final int NAME_COL = 2;
    static final int EXTENSION_COL = 3;
    static final int SIZE_COL = 4;
    static final int SPEED_COL = 5;
    static final int SCORE_COL = 6;
    static final int CHAT_COL = 7;
    static final int LOCATION_COL = 8;

    private DisplayManager() {
        Object object;
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        String[] stringArray = limeXMLSchemaRepository.getAvailableSchemaURIs();
        int n = 0;
        while (n < stringArray.length) {
            object = limeXMLSchemaRepository.getSchema(stringArray[n]);
            Properties properties = new Properties();
            this.loadDisplayProperties(stringArray[n], properties);
            this.schemaURIToDispProps.put(stringArray[n], properties);
            ++n;
        }
        this.props = new Properties();
        try {
            object = new FileInputStream(new File(CommonUtils.getUserSettingsDir(), "Display.props"));
            this.props.load((InputStream)object);
            if (((Hashtable)this.props).size() == 0) {
                this.loadDefaults();
            }
        }
        catch (Exception exception) {
            this.loadDefaults();
        }
    }

    public static DisplayManager instance() {
        if (instance == null) {
            instance = new DisplayManager();
            return instance;
        }
        return instance;
    }

    public Properties getProperties(String string) {
        Properties properties = (Properties)this.schemaURIToDispProps.get(string);
        if (properties == null) {
            return new Properties();
        }
        return properties;
    }

    public String getDisplayName(String string, String string2) {
        Properties properties = this.getProperties(string2);
        String string3 = properties.getProperty(string, "null");
        if (string3.equals("null")) {
            string3 = LimeXMLUtils.processColName(string);
            return string3;
        }
        string3 = DisplayManager.stripPreferredSize(string3);
        return string3;
    }

    public void addColumn(String string, int n) {
        ((Hashtable)this.props).put(string, "" + n);
        this.commit();
    }

    public void setValue(String string, int n) {
        ((Hashtable)this.props).put(string, "" + n);
    }

    public void removeColumn(String string) {
        ((Hashtable)this.props).remove(string);
        this.commit();
    }

    public String getValue(String string) {
        return this.props.getProperty(string, "-1");
    }

    public void commit() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(CommonUtils.getUserSettingsDir(), "Display.props"));
            this.props.save(fileOutputStream, "");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getKeyString(int n) {
        switch (n) {
            case 0: {
                return "QUALITY";
            }
            case 1: {
                return "COUNT";
            }
            case 2: {
                return "NAME";
            }
            case 3: {
                return "TYPE";
            }
            case 4: {
                return "SIZE";
            }
            case 5: {
                return "SPEED";
            }
            case 6: {
                return "SCORE";
            }
            case 7: {
                return "CHAT";
            }
            case 8: {
                return "LOCATION";
            }
        }
        Assert.that(false, "Cannot get column value greater than 8");
        return "";
    }

    public static int getDefaultWidth(int n) {
        switch (n) {
            case 0: {
                return 40;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 230;
            }
            case 3: {
                return 30;
            }
            case 4: {
                return 60;
            }
            case 5: {
                return 30;
            }
            case 6: {
                return 30;
            }
            case 7: {
                return 10;
            }
            case 8: {
                return 20;
            }
        }
        Assert.that(false, "Cannot have greater column value than 7");
        return 0;
    }

    public static String stripPreferredSize(String string) {
        int n = string.indexOf("^");
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    private void loadDisplayProperties(String string, Properties properties) {
        String string2 = LimeXMLSchema.getDisplayString(string);
        LimeXMLProperties limeXMLProperties = LimeXMLProperties.instance();
        String string3 = limeXMLProperties.getXMLDisplayPropsDir();
        try {
            File file = new File(string3, string2 + ".props");
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadDefaults() {
        ((Hashtable)this.props).put("QUALITY", "40");
        ((Hashtable)this.props).put("COUNT", "3");
        ((Hashtable)this.props).put("NAME", "230");
        ((Hashtable)this.props).put("TYPE", "30");
        ((Hashtable)this.props).put("SIZE", "60");
        ((Hashtable)this.props).put("SPEED", "30");
        ((Hashtable)this.props).put("CHAT", "10");
        ((Hashtable)this.props).put("audios__audio__bitrate__", "20");
        this.commit();
    }
}

