/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.JMultilineToolTipTreeTable;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.TreeTableModelAdapter;
import com.limegroup.gnutella.gui.search.BitziLookupAction;
import com.limegroup.gnutella.gui.search.BrowseHostAction;
import com.limegroup.gnutella.gui.search.CachingEndpointRenderer;
import com.limegroup.gnutella.gui.search.CancelAction;
import com.limegroup.gnutella.gui.search.ChatListener;
import com.limegroup.gnutella.gui.search.ColumnSizeChangeListener;
import com.limegroup.gnutella.gui.search.DisplayManager;
import com.limegroup.gnutella.gui.search.DownloadAllAction;
import com.limegroup.gnutella.gui.search.QualityRenderer;
import com.limegroup.gnutella.gui.search.ResultSpeedRenderer;
import com.limegroup.gnutella.gui.search.SearchButtons;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.StopListener;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineGrouper;
import com.limegroup.gnutella.gui.search.TableRowFilter;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.ChatRenderer;
import com.limegroup.gnutella.gui.tables.HeaderMouseListener;
import com.limegroup.gnutella.gui.tables.HeaderMouseObserver;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Pair;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.NoSuchElementException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ResultPanel
extends JPanel
implements ThemeObserver {
    private String query;
    private String richQuery;
    private MediaType type;
    private volatile GUID guid;
    private long timeLastResultReceived;
    private final long REPEAT_SEARCH_DELAY = 0L;
    private TableRowFilter dataModel;
    private JMultilineToolTipTreeTable table;
    private boolean grouped;
    private boolean ascending = true;
    private boolean isBrowseHostTab = false;
    private final TableLineGrouper grouper = new TableLineGrouper();
    private boolean debug = false;
    private JPanel _tablePanel;
    private JScrollPane scrollpane;
    private JPopupMenu menu = null;
    private JMenuItem chatItem;
    private JMenuItem bitziLookupItem;
    private JMenuItem browseHostItem;
    private JMenuItem launchItem;
    private JMenuItem repeatSearchEntry;
    boolean columnsSizeChanged = false;
    private ColumnSizeChangeListener sizeListener;
    private final SearchButtons SEARCH_BUTTONS = new SearchButtons();
    private static final String GROUP_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_GROUP_STRING");
    private final JCheckBox GROUP_BOX = new JCheckBox(GROUP_STRING, true);
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$ChatHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$QualityHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$CachingEndpoint;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$ResultSpeed;

    ResultPanel() {
        this(new GUID(new byte[16]), "", null, null, false);
        this.SEARCH_BUTTONS.setButtonsEnabled(false);
    }

    ResultPanel(GUID gUID, String string, MediaType mediaType, String string2, boolean bl) {
        this.menu = new JPopupMenu();
        this.type = mediaType;
        this.guid = gUID;
        this.query = string;
        this.richQuery = string2;
        this.grouped = this.GROUP_BOX.isSelected();
        this.setLayout(new BoxLayout(this, 1));
        this.isBrowseHostTab = bl;
        this.dataModel = new TableRowFilter(new TableLine(), this.grouped, this);
        this.timeLastResultReceived = -1L;
        this.createTreeTable();
        JMenuItem jMenuItem = new JMenuItem(SearchMediator.DOWNLOAD_STRING);
        jMenuItem.addActionListener(new DownloadAllAction());
        this.menu.add(jMenuItem);
        this.chatItem = new JMenuItem(SearchMediator.CHAT_STRING);
        this.chatItem.addActionListener(new ChatListener());
        this.menu.add(this.chatItem);
        this.bitziLookupItem = new JMenuItem(SearchMediator.BITZI_LOOKUP_STRING);
        this.bitziLookupItem.addActionListener(new BitziLookupAction());
        this.menu.add(this.bitziLookupItem);
        this.browseHostItem = new JMenuItem(SearchMediator.BROWSE_HOST_STRING);
        this.browseHostItem.addActionListener(new BrowseHostAction());
        this.menu.add(this.browseHostItem);
        this.menu.addSeparator();
        this.repeatSearchEntry = new JMenuItem(SearchMediator.REPEAT_SEARCH_STRING);
        this.repeatSearchEntry.addActionListener(new AbstractAction(){

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ResultPanel.this.repeatSearch();
                }
                catch (Exception exception) {
                    GUIMediator.showInternalError(exception);
                }
            }
        });
        this.menu.add(this.repeatSearchEntry);
        JMenuItem jMenuItem2 = new JMenuItem(SearchMediator.STOP_STRING);
        jMenuItem2.addActionListener(new StopListener());
        this.menu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(SearchMediator.KILL_STRING);
        jMenuItem3.addActionListener(new CancelAction());
        this.menu.add(jMenuItem3);
        this.menu.addSeparator();
        this.launchItem = new JMenuItem(SearchMediator.LAUNCH_STRING);
        this.launchItem.addActionListener(new AbstractAction(){

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ResultPanel.this.launchBrowser();
                }
                catch (Exception exception) {
                    GUIMediator.showInternalError(exception);
                }
            }
        });
        this.menu.add(this.launchItem);
        this.GROUP_BOX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ResultPanel.this.setGrouped(ResultPanel.this.GROUP_BOX.isSelected());
                }
                catch (Exception exception) {
                    GUIMediator.showInternalError(exception);
                }
            }
        });
        this.scrollpane = new JScrollPane(this.table);
        this.createPanel();
        GUIMediator.addThemeObserver(this);
    }

    private void markTimeLastResultReceived() {
        this.timeLastResultReceived = System.currentTimeMillis();
    }

    public boolean isRepeatSearchEnabled() {
        if (this.timeLastResultReceived == -1L) {
            return true;
        }
        long l = System.currentTimeMillis();
        return l - this.timeLastResultReceived > 0L;
    }

    private void repeatSearch() {
        if (this.isRepeatSearchEnabled()) {
            Object object = SearchMediator.REPEAT_SEARCH_LOCK;
            synchronized (object) {
                this.resetPanel();
                SearchMediator.setTabDisplayCount(this);
                if (this.isBrowseHostTab) {
                    this.debug("ResultPanel.repeatSearch(): browse host...");
                    StringTokenizer stringTokenizer = new StringTokenizer(this.query, ":");
                    String string = null;
                    int n = 0;
                    if (stringTokenizer.hasMoreTokens()) {
                        string = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        n = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    if (string != null && n != 0) {
                        SearchMediator.reBrowseHost(string, n, this);
                    }
                } else {
                    this.debug("ResultPanel.repeatSearch(): regular...");
                    SearchMediator.repeatSearch(this.type, this.query, this.richQuery);
                }
            }
        }
    }

    void resetPanel() {
        this.grouper.clear();
        this.dataModel = new TableRowFilter(new TableLine(), this.grouped, this);
        this.createTreeTable();
        this.scrollpane = new JScrollPane(this.table);
        this.createPanel();
    }

    private void createPanel() {
        if (this._tablePanel != null) {
            this.remove(this._tablePanel);
        }
        ResultPanel resultPanel = this;
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                try {
                    if (mouseEvent.isPopupTrigger() || SwingUtilities.isRightMouseButton(mouseEvent)) {
                        ResultPanel.this.handleRightMouseClick(mouseEvent);
                        SearchMediator.showMenu(ResultPanel.this.table, mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getClickCount() >= 2) {
                        SearchMediator.doDownload();
                    }
                }
                catch (Exception exception) {
                    GUIMediator.showInternalError(exception);
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                try {
                    int n = ResultPanel.this.table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    TableLine tableLine = (TableLine)ResultPanel.this.table.nodeForRow(n);
                    if (tableLine == null) {
                        return;
                    }
                    String[] stringArray = tableLine.getMetaText();
                    ResultPanel.this.table.setToolTipText(Integer.toString(n));
                    ResultPanel.this.table.setToolTipArray(stringArray);
                }
                catch (Exception exception) {
                    GUIMediator.showInternalError(exception);
                }
            }
        };
        MouseInputAdapter mouseInputAdapter2 = new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                try {
                    if (!ResultPanel.this.columnsSizeChanged) {
                        return;
                    }
                    ResultPanel.this.commitColumnSizeChange();
                }
                catch (Exception exception) {
                    GUIMediator.showInternalError(exception);
                }
            }
        };
        this.table.addMouseListener(mouseInputAdapter);
        this.table.addMouseMotionListener(mouseInputAdapter);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseListener(mouseInputAdapter2);
        this._tablePanel = new JPanel();
        this._tablePanel.setLayout(new BorderLayout());
        Color color = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        this._tablePanel.setBackground(color);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.table.getTableHeader().getBackground());
        jPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.scrollpane.setCorner("UPPER_RIGHT_CORNER", jPanel);
        this.scrollpane.getViewport().setBackground(color);
        this._tablePanel.add((Component)this.scrollpane, "Center");
        this.SEARCH_BUTTONS.transformDowloadButton();
        this.SEARCH_BUTTONS.setButtonEnabled(1, true);
        this.SEARCH_BUTTONS.setButtonEnabled(1, false);
        this.SEARCH_BUTTONS.setButtonEnabled(2, false);
        BoxPanel boxPanel = new BoxPanel(0);
        boxPanel.add(this.SEARCH_BUTTONS.getComponent());
        boxPanel.add(this.GROUP_BOX);
        this.add(this._tablePanel);
        this.add(boxPanel);
    }

    void handleRightMouseClick(MouseEvent mouseEvent) {
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (n < 0) {
            return;
        }
        if (!this.table.getSelectionModel().isSelectedIndex(n)) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    private void commitColumnSizeChange() {
        HashMap hashMap = new HashMap();
        DisplayManager displayManager = DisplayManager.instance();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnModel.getColumn(n2);
            int n3 = tableColumn.getPreferredWidth();
            hashMap.put(tableColumn, new Integer(n3));
            Pair pair = this.dataModel.getIndexSchemaPairForColumn(n2);
            int n4 = pair.getKey();
            LimeXMLSchema limeXMLSchema = (LimeXMLSchema)pair.getElement();
            String string = "";
            if (limeXMLSchema == null) {
                string = DisplayManager.getKeyString(n4);
            } else {
                SchemaFieldInfo schemaFieldInfo = (SchemaFieldInfo)limeXMLSchema.getCanonicalizedFields().get(n4);
                string = schemaFieldInfo.getCanonicalizedFieldName();
            }
            displayManager.setValue(string, n3);
            ++n2;
        }
        displayManager.commit();
        if (this != SearchMediator.getDummyResultPanel()) {
            SearchMediator.columnSizeChanged(hashMap);
        }
        this.columnsSizeChanged = false;
    }

    void dummyCommitColumnSizeChanged(HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            TableColumn tableColumn = (TableColumn)iterator.next();
            TableColumn tableColumn2 = null;
            try {
                tableColumn2 = this.table.getColumn(tableColumn.getIdentifier());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            int n = (Integer)hashMap.get(tableColumn);
            tableColumn2.setPreferredWidth(n);
        }
    }

    private void createTreeTable() {
        Serializable serializable;
        this.table = new JMultilineToolTipTreeTable(this.dataModel);
        JTree jTree = this.table.getTree();
        if (CommonUtils.isMacOSX()) {
            jTree.setShowsRootHandles(false);
        }
        this.table.setLeafIcon(null);
        this.table.setClosedIcon(null);
        this.table.setOpenIcon(null);
        this.table.setDefaultRenderer(class$com$limegroup$gnutella$gui$ChatHolder == null ? (class$com$limegroup$gnutella$gui$ChatHolder = ResultPanel.class$("com.limegroup.gnutella.gui.ChatHolder")) : class$com$limegroup$gnutella$gui$ChatHolder, new ChatRenderer());
        this.table.setDefaultRenderer(class$com$limegroup$gnutella$gui$search$QualityHolder == null ? (class$com$limegroup$gnutella$gui$search$QualityHolder = ResultPanel.class$("com.limegroup.gnutella.gui.search.QualityHolder")) : class$com$limegroup$gnutella$gui$search$QualityHolder, new QualityRenderer());
        this.table.setDefaultRenderer(class$com$limegroup$gnutella$gui$search$CachingEndpoint == null ? (class$com$limegroup$gnutella$gui$search$CachingEndpoint = ResultPanel.class$("com.limegroup.gnutella.gui.search.CachingEndpoint")) : class$com$limegroup$gnutella$gui$search$CachingEndpoint, new CachingEndpointRenderer());
        this.table.setDefaultRenderer(class$com$limegroup$gnutella$gui$search$ResultSpeed == null ? (class$com$limegroup$gnutella$gui$search$ResultSpeed = ResultPanel.class$("com.limegroup.gnutella.gui.search.ResultSpeed")) : class$com$limegroup$gnutella$gui$search$ResultSpeed, new ResultSpeedRenderer());
        DisplayManager displayManager = DisplayManager.instance();
        this.sizeListener = new ColumnSizeChangeListener(this);
        int n = 0;
        while (n < this.dataModel.getColumnCount()) {
            int n2 = this.dataModel.getPreferredWidth(n);
            serializable = this.table.getColumnModel().getColumn(n);
            ((TableColumn)serializable).setPreferredWidth(n2);
            ((TableColumn)serializable).addPropertyChangeListener(this.sizeListener);
            ((TableColumn)serializable).setHeaderRenderer(AbstractTableMediator.HEADER_RENDERER);
            ((TableColumn)serializable).setIdentifier(this.dataModel.getColumnId(n));
            ++n;
        }
        HeaderMouseListener headerMouseListener = new HeaderMouseListener(new HeaderMouseObserver(){

            private Object getId(int n) {
                return ResultPanel.this.table.getColumnModel().getColumn(n).getIdentifier();
            }

            public void handleHeaderColumnLeftClick(Point point) {
                JTableHeader jTableHeader = ResultPanel.this.table.getTableHeader();
                int n = jTableHeader.columnAtPoint(point);
                int n2 = ResultPanel.this.table.convertColumnIndexToModel(n);
                ResultPanel.this.table.sortColumn(this.getId(n2), !ResultPanel.this.ascending);
                ResultPanel.this.sort(n2);
            }

            public void handleHeaderColumnPressed(Point point) {
                JTableHeader jTableHeader = ResultPanel.this.table.getTableHeader();
                int n = jTableHeader.columnAtPoint(point);
                int n2 = ResultPanel.this.table.convertColumnIndexToModel(n);
                if (n2 != -1) {
                    ResultPanel.this.table.setPressedColumnId(this.getId(n2));
                    jTableHeader.repaint(jTableHeader.getHeaderRect(n));
                }
            }

            public void handleHeaderColumnReleased(Point point) {
                ResultPanel.this.table.setPressedColumnId(null);
                JTableHeader jTableHeader = ResultPanel.this.table.getTableHeader();
                int n = jTableHeader.columnAtPoint(point);
                int n2 = ResultPanel.this.table.convertColumnIndexToModel(n);
                if (n2 != -1) {
                    jTableHeader.repaint(jTableHeader.getHeaderRect(n));
                }
            }

            public void handleHeaderPopupMenu(Point point) {
                JPopupMenu jPopupMenu = ResultPanel.this.dataModel.getColumnSelectionMenu();
                jPopupMenu.show(ResultPanel.this, point.x, point.y);
            }
        });
        serializable = this.table.getTableHeader();
        ((Component)serializable).addMouseListener(headerMouseListener);
        ((Component)serializable).addMouseMotionListener(headerMouseListener);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ResultSelectionListener());
        this.table.addTreeExpansionListener(new ResultExpansionListener());
    }

    void addLine(TableLine tableLine, TableLine tableLine2) {
        if (this.isEmpty()) {
            this.SEARCH_BUTTONS.transformWishlistButton();
        }
        this.markTimeLastResultReceived();
        this.dataModel.addLine(tableLine, tableLine2, this.grouped);
        this.table.sortColumn("", false);
        this.table.revalidate();
    }

    private void setGrouped(boolean bl) {
        if (this.grouped == bl) {
            return;
        }
        this.grouped = bl;
        if (this.grouped) {
            this.dataModel.group();
        } else {
            this.dataModel.ungroup();
        }
        this.table.revalidate();
    }

    private void launchBrowser() {
        String string = "";
        Iterator iterator = this.getSelectedRows();
        TableLine tableLine = null;
        if (!iterator.hasNext()) {
            return;
        }
        tableLine = (TableLine)iterator.next();
        List list = tableLine.getDocuments();
        if (list == null) {
            return;
        }
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            LimeXMLDocument limeXMLDocument = (LimeXMLDocument)iterator2.next();
            string = limeXMLDocument.getAction();
            try {
                GUIMediator.instance();
                GUIMediator.openURL(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    TableLineGrouper getGrouper() {
        return this.grouper;
    }

    boolean matches(GUID gUID) {
        return this.guid.equals(gUID);
    }

    void setGUID(GUID gUID) {
        this.guid = gUID;
    }

    String getQuery() {
        return this.query;
    }

    String getRichQuery() {
        return this.richQuery;
    }

    byte[] getGUID() {
        return this.guid.bytes();
    }

    MediaType getMediaType() {
        return this.type;
    }

    boolean isBrowseHostTab() {
        return this.isBrowseHostTab;
    }

    synchronized void sort(int n) {
        this.dataModel.sort(n, this.ascending);
        this.table.revalidate();
        this.ascending = !this.ascending;
    }

    int numResults() {
        return this.dataModel.numLeaves();
    }

    JPopupMenu getPopup() {
        if (!this.areRowsSelected()) {
            this.chatItem.setEnabled(false);
            this.browseHostItem.setEnabled(false);
        } else {
            TableLine tableLine = this.getFirstSelectedTableLine();
            this.chatItem.setEnabled(tableLine.getChatEnabled());
            this.bitziLookupItem.setEnabled(tableLine.getSHA1() != null);
            this.browseHostItem.setEnabled(tableLine.getBrowseHostEnabled());
        }
        this.repeatSearchEntry.setEnabled(!this.isBrowseHostTab());
        return this.menu;
    }

    Iterator getSelectedRows() {
        return new SelectedRowIterator();
    }

    private void debug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    void columnsChanged() {
        ((TreeTableModelAdapter)this.table.getModel()).fireTableStructureChanged();
        int n = 0;
        while (n < this.dataModel.getColumnCount()) {
            int n2 = this.dataModel.getPreferredWidth(n);
            this.table.getColumnModel().getColumn(n).setPreferredWidth(n2);
            TableColumn tableColumn = this.table.getColumnModel().getColumn(n);
            tableColumn.removePropertyChangeListener(this.sizeListener);
            tableColumn.addPropertyChangeListener(this.sizeListener);
            tableColumn.setHeaderRenderer(AbstractTableMediator.HEADER_RENDERER);
            tableColumn.setIdentifier(this.dataModel.getColumnId(n));
            ++n;
        }
        this.commitColumnSizeChange();
        if (this != SearchMediator.getDummyResultPanel()) {
            SearchMediator.columnsChanged();
        }
        this.table.revalidate();
    }

    void dummyColumnsChanged() {
        this.resetPanel();
        ((TreeTableModelAdapter)this.table.getModel()).fireTableStructureChanged();
        int n = 0;
        while (n < this.dataModel.getColumnCount()) {
            int n2 = this.dataModel.getPreferredWidth(n);
            this.table.getColumnModel().getColumn(n).setPreferredWidth(n2);
            ++n;
        }
        this.table.revalidate();
    }

    void showColumnWarning() {
        GUIMediator.showError("ERROR_REMOVE_LAST_COL");
    }

    final boolean areRowsSelected() {
        return this.table.getSelectedRow() != -1;
    }

    final boolean isEmpty() {
        return this.dataModel.getRowCount() == 0;
    }

    final TableLine getFirstSelectedTableLine() {
        if (!this.areRowsSelected()) {
            return null;
        }
        return (TableLine)this.table.nodeForRow(this.table.getSelectedRow());
    }

    public void updateTheme() {
        Color color = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        this._tablePanel.setBackground(color);
        this.scrollpane.getViewport().setBackground(color);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ResultExpansionListener
    implements TreeExpansionListener {
        private ResultExpansionListener() {
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            try {
                ResultPanel.this.table.removeRowSelectionInterval(0, ResultPanel.this.table.getRowCount() - 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        }
    }

    private class ResultSelectionListener
    implements ListSelectionListener {
        private ResultSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            try {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    ResultPanel.this.SEARCH_BUTTONS.setButtonsEnabled(false);
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                int n = listSelectionModel.getMinSelectionIndex();
                if (n != -1) {
                    TableLine tableLine = (TableLine)ResultPanel.this.table.nodeForRow(n);
                    if (tableLine == null) {
                        return;
                    }
                    ResultPanel.this.SEARCH_BUTTONS.setButtonEnabled(1, tableLine.getChatEnabled());
                    ResultPanel.this.SEARCH_BUTTONS.setButtonEnabled(0, true);
                    ResultPanel.this.SEARCH_BUTTONS.setButtonEnabled(2, tableLine.getBrowseHostEnabled());
                } else {
                    ResultPanel.this.SEARCH_BUTTONS.setButtonsEnabled(false);
                }
                int n2 = listSelectionEvent.getFirstIndex();
                while (n2 <= listSelectionEvent.getLastIndex()) {
                    TableLine tableLine;
                    if (listSelectionModel.isSelectedIndex(n2) && (tableLine = (TableLine)ResultPanel.this.table.nodeForRow(n2)) != null && !ResultPanel.this.dataModel.isLeaf(tableLine) && ResultPanel.this.table.isExpanded(n2)) {
                        int n3 = n2 + 1;
                        int n4 = n2 + ResultPanel.this.dataModel.getChildCount(tableLine);
                        listSelectionModel.addSelectionInterval(n3, n4);
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                GUIMediator.showInternalError(exception);
            }
        }
    }

    private class SelectedRowIterator
    extends UnmodifiableIterator {
        private int next = 0;
        private int[] selectedRows = ResultPanel.access$400(ResultPanel.this).getSelectedRows();

        private SelectedRowIterator() {
        }

        public boolean hasNext() {
            return this.next < this.selectedRows.length;
        }

        public Object next() throws NoSuchElementException {
            try {
                int n = this.selectedRows[this.next];
                ++this.next;
                TableLine tableLine = (TableLine)ResultPanel.this.table.nodeForRow(n);
                return tableLine;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }
    }
}

