/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.AbstractTreeTableModel;
import com.limegroup.gnutella.gui.search.CachingEndpoint;
import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.util.Pair;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;

abstract class ResultPanelModel
extends AbstractTreeTableModel {
    private final TableLine fakeGroupedRoot = new TableLine();
    private int leaves = 0;

    ResultPanelModel(TableLine tableLine, boolean bl) {
        super(tableLine);
        if (bl) {
            this.fakeGroupedRoot.children = tableLine.children;
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        Assert.that(false, "Table not editable!");
    }

    public int getChildCount(Object object) {
        return ((TableLine)object).children.size();
    }

    public Object getChild(Object object, int n) {
        return ((TableLine)object).children.get(n);
    }

    public boolean isLeaf(Object object) {
        return ((TableLine)object).children == null;
    }

    private void add(TableLine tableLine, TableLine tableLine2) {
        if (tableLine.children == null) {
            tableLine.children = new ArrayList();
        }
        tableLine.children.add(tableLine2);
        tableLine2.childName = tableLine.children.size() - 1;
    }

    private TableLine setChildAt(TableLine tableLine, int n, TableLine tableLine2) {
        Assert.that(tableLine.children != null);
        TableLine tableLine3 = (TableLine)tableLine.children.get(n);
        tableLine.children.set(n, tableLine2);
        tableLine2.childName = n;
        return tableLine3;
    }

    void addLine(TableLine tableLine, TableLine tableLine2, boolean bl) {
        if (bl) {
            Assert.that(((TableLine)this.getRoot()).children == this.fakeGroupedRoot.children, "No aliasing of fakedGroupedRoot's children.");
            this.addLineInternal((TableLine)this.getRoot(), tableLine, tableLine2);
        } else {
            Assert.that(((TableLine)this.getRoot()).children != this.fakeGroupedRoot.children, "Aliasing of fakedGroupedRoot's children.");
            this.addLineInternal(this.fakeGroupedRoot, tableLine, tableLine2);
            this.addLineInternal((TableLine)this.getRoot(), tableLine.createClone(), null);
        }
        ++this.leaves;
    }

    private void addLineInternal(TableLine tableLine, TableLine tableLine2, TableLine tableLine3) {
        if (tableLine3 != null) {
            try {
                Assert.that(this.getChild(tableLine, tableLine3.childName) == tableLine3, "Group is not the " + tableLine3.childName + "'th child of root");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Assert.that(false, "Group is not the " + tableLine3.childName + "'th child of root");
            }
        }
        if (tableLine3 != null) {
            int n = tableLine3.childName;
            if (!this.isLeaf(tableLine3)) {
                this.add(tableLine3, tableLine2);
                if (tableLine3.getSpeed().compareTo(tableLine2.getSpeed()) < 0) {
                    tableLine3.setSpeed(tableLine2.getSpeed());
                }
                if (tableLine3.getQuality() < tableLine2.getQuality()) {
                    tableLine3.setQuality(tableLine2.getQuality());
                }
                if (!tableLine3.getChatEnabled() && tableLine2.getChatEnabled()) {
                    tableLine3.setChatEnabled(true);
                }
            } else {
                TableLine tableLine4 = tableLine3.createClone();
                tableLine3.location = new CachingEndpoint(this, tableLine3);
                tableLine3.setSpeed(ResultSpeed.max(tableLine3.getSpeed(), tableLine2.getSpeed()));
                tableLine3.setQuality(Math.max(tableLine3.getQuality(), tableLine2.getQuality()));
                tableLine3.setChatEnabled(tableLine3.getChatEnabled() || tableLine2.getChatEnabled());
                this.add(tableLine3, tableLine4);
                this.add(tableLine3, tableLine2);
            }
        } else {
            this.add(tableLine, tableLine2);
        }
    }

    void group() {
        TableLine tableLine = (TableLine)this.getRoot();
        tableLine.children = this.fakeGroupedRoot.children;
    }

    void ungroup() {
        TableLine tableLine = (TableLine)this.getRoot();
        tableLine.children = new ArrayList(this.leavesCount());
        Iterator iterator = this.fakeGroupedRoot.children.iterator();
        while (iterator.hasNext()) {
            TableLine tableLine2 = (TableLine)iterator.next();
            if (this.isLeaf(tableLine2)) {
                this.addLineInternal(tableLine, tableLine2.createClone(), null);
                continue;
            }
            int n = 0;
            while (n < tableLine2.children.size()) {
                TableLine tableLine3 = (TableLine)tableLine2.children.get(n);
                Assert.that(this.isLeaf(tableLine3));
                this.addLineInternal(tableLine, tableLine3.createClone(), null);
                ++n;
            }
        }
    }

    boolean sort(Pair pair, boolean bl) {
        TableLine tableLine = (TableLine)this.getRoot();
        Collections.sort(tableLine.children, TableLine.newComparator(pair, bl));
        List list = tableLine.children;
        int n = 0;
        while (n < list.size()) {
            TableLine tableLine2 = (TableLine)list.get(n);
            tableLine2.childName = n++;
        }
        return true;
    }

    private int leavesCount() {
        return this.leaves;
    }

    int getRowCount() {
        TableLine tableLine = (TableLine)this.getRoot();
        return tableLine.children.size();
    }

    Object getRow(int n) {
        TableLine tableLine = (TableLine)this.getRoot();
        return tableLine.children.get(n);
    }

    private int repOk(TableLine tableLine) {
        if (tableLine.children == null) {
            return 1;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < tableLine.children.size()) {
            TableLine tableLine2 = (TableLine)tableLine.children.get(n2);
            Assert.that(tableLine2 != null, "Null children");
            Assert.that(tableLine2.childName == n2, "Child's name is " + tableLine2.childName + " but I expected " + n2);
            n += this.repOk(tableLine2);
            ++n2;
        }
        return n;
    }
}

