/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.BrowseHostAction;
import com.limegroup.gnutella.gui.search.ChatListener;
import com.limegroup.gnutella.gui.search.DownloadAllAction;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JButton;

final class SearchButtons {
    private final ButtonRow BUTTONS;
    static final int DOWNLOAD_BUTTON_INDEX = 0;
    static final int CHAT_BUTTON_INDEX = 1;
    static final int BROWSE_BUTTON_INDEX = 2;
    private static final String DOWNLOAD_BUTTON_LABEL = GUIMediator.getStringResource("SEARCH_DOWNLOAD_BUTTON_LABEL");
    private static final String DOWNLOAD_BUTTON_TIP = GUIMediator.getStringResource("SEARCH_DOWNLOAD_BUTTON_TIP");
    private static final String WISHLIST_BUTTON_LABEL = GUIMediator.getStringResource("SEARCH_WISHLIST_BUTTON_LABEL");
    private static final String WISHLIST_BUTTON_TIP = GUIMediator.getStringResource("SEARCH_WISHLIST_BUTTON_TIP");

    SearchButtons() {
        String[] stringArray = new String[]{"SEARCH_WISHLIST_BUTTON_LABEL", "SEARCH_CHAT_BUTTON_LABEL", "SEARCH_BROWSE_HOST_BUTTON_LABEL"};
        String[] stringArray2 = new String[]{"SEARCH_WISHLIST_BUTTON_TIP", "SEARCH_CHAT_BUTTON_TIP", "SEARCH_BROWSE_HOST_BUTTON_TIP"};
        ActionListener[] actionListenerArray = new ActionListener[]{new DownloadAllAction(), new ChatListener(), new BrowseHostAction()};
        this.BUTTONS = new ButtonRow(stringArray, stringArray2, actionListenerArray);
    }

    void setButtonEnabled(int n, boolean bl) {
        this.BUTTONS.setButtonEnabled(n, bl);
    }

    void setButtonsEnabled(boolean bl) {
        this.BUTTONS.setButtonsEnabled(bl);
    }

    Component getComponent() {
        return this.BUTTONS;
    }

    void transformWishlistButton() {
        this.transformButton(0, DOWNLOAD_BUTTON_LABEL, DOWNLOAD_BUTTON_TIP);
        this.setButtonEnabled(0, false);
    }

    void transformDowloadButton() {
        this.transformButton(0, WISHLIST_BUTTON_LABEL, WISHLIST_BUTTON_TIP);
        this.setButtonEnabled(0, true);
    }

    private void transformButton(int n, String string, String string2) {
        JButton jButton = this.BUTTONS.getButtonAtIndex(n);
        if (jButton != null) {
            jButton.setText(string);
            jButton.setToolTipText(string2);
        }
    }
}

