/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.search.DitherPanel;
import com.limegroup.gnutella.gui.search.DitherScrollPane;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.SearchListener;
import com.limegroup.gnutella.gui.search.StopListener;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.gui.InputPanel;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

final class SearchInputManager
implements ThemeObserver {
    static Color _fadeColor = ThemeFileHandler.SEARCH_FADE_COLOR.getValue();
    static final int FADE_STEPS = 62;
    private final JTextField SEARCH_FIELD = new JTextField(15);
    private final JButton SEARCH_BUTTON = new JButton(GUIMediator.getStringResource("SEARCH_SEARCH_BUTTON_LABEL"));
    private final JButton STOP_BUTTON = new JButton(GUIMediator.getStringResource("SEARCH_STOP_BUTTON_LABEL"));
    private final ButtonGroup RADIO_GROUP = new ButtonGroup();
    private final JPanel SEARCH_BOX_PANEL = new BoxPanel(1);
    private final JLabel DEFAULT_SEARCH_LABEL = new JLabel("", 10);
    private final SchemaMapper SCHEMA_MAPPER = new SchemaMapper();
    private static final CardLayout SEARCH_CARDS = new CardLayout();
    private static final JPanel MAIN_PANEL = new JPanel(SEARCH_CARDS);
    static Color _backColor = MAIN_PANEL.getBackground();
    private NamedMediaType[] namedMediaTypes;
    private int mediaIndexToUse;
    private static final String DEFAULT_SEARCH_KEY = "default";
    private static final JPanel RADIO_PANEL = new JPanel();
    private final Ditherer DITHERER = new Ditherer();

    SearchInputManager() {
        Object object;
        Object object2;
        Object object3;
        JComponent jComponent;
        Object object4;
        Object object5;
        List list = NamedMediaType.convertMediaTypes(MediaType.getDefaultMediaTypes());
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        String[] stringArray = limeXMLSchemaRepository.getAvailableSchemaURIs();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            object5 = LimeXMLSchema.getDisplayString(string);
            if (!NamedMediaType.isDefaultType((String)object5)) {
                NamedMediaType namedMediaType = new NamedMediaType(new MediaType((String)object5, null, null));
                list.add(namedMediaType);
            }
            ++n;
        }
        this.namedMediaTypes = new NamedMediaType[list.size()];
        list.toArray(this.namedMediaTypes);
        JPanel[] jPanelArray = new JPanel[this.namedMediaTypes.length];
        int n2 = 0;
        while (n2 < this.namedMediaTypes.length) {
            jPanelArray[n2] = new JPanel(new GridLayout(1, 0, 0, 0));
            jPanelArray[n2].setOpaque(false);
            ++n2;
        }
        object5 = ThemeFileHandler.SEARCH_BUTTON_COLOR.getValue();
        int n3 = 0;
        while (n3 < this.namedMediaTypes.length) {
            object4 = this.namedMediaTypes[n3].toString();
            String string = this.namedMediaTypes[n3].getUnderLyingMediaType().toString();
            jComponent = new JRadioButton((String)object4);
            jComponent.setForeground((Color)object5);
            jComponent.setOpaque(false);
            ((AbstractButton)jComponent).setActionCommand(string);
            ((AbstractButton)jComponent).addActionListener(new RadioButtonListener(n3));
            this.RADIO_GROUP.add((AbstractButton)jComponent);
            jPanelArray[n3 / 2].add(jComponent);
            if (n3 == 0) {
                ((AbstractButton)jComponent).setSelected(true);
            }
            ++n3;
        }
        object4 = new Box(1);
        int n4 = 0;
        while (n4 < jPanelArray.length) {
            ((Container)object4).add(jPanelArray[n4]);
            ++n4;
        }
        RADIO_PANEL.setBackground(_fadeColor);
        RADIO_PANEL.add((Component)object4);
        this.SEARCH_BUTTON.setToolTipText(GUIMediator.getStringResource("SEARCH_SEARCH_BUTTON_TIP"));
        this.STOP_BUTTON.setToolTipText(GUIMediator.getStringResource("SEARCH_STOP_BUTTON_TIP"));
        jComponent = new DitherPanel(this.DITHERER);
        BoxPanel boxPanel = new BoxPanel(1);
        boxPanel.setOpaque(false);
        String string = GUIMediator.getStringResource("SEARCH_DEFAULT_FIELD_TITLE");
        this.DEFAULT_SEARCH_LABEL.setText("" + this.namedMediaTypes[0]);
        this.DEFAULT_SEARCH_LABEL.setOpaque(false);
        BoxPanel boxPanel2 = new BoxPanel(0);
        boxPanel2.setOpaque(false);
        boxPanel2.add(new JLabel(string));
        boxPanel2.add(Box.createHorizontalGlue());
        boxPanel.add(boxPanel2);
        boxPanel.add(Box.createVerticalStrut(3));
        boxPanel.add(this.SEARCH_FIELD);
        jComponent.add(this.DEFAULT_SEARCH_LABEL);
        jComponent.add(Box.createHorizontalStrut(40));
        jComponent.add(boxPanel);
        jComponent.setOpaque(false);
        MAIN_PANEL.add((Component)jComponent, DEFAULT_SEARCH_KEY);
        SearchListener searchListener = new SearchListener();
        int n5 = 0;
        while (n5 < stringArray.length) {
            object3 = stringArray[n5];
            object2 = LimeXMLSchema.getDisplayString((String)object3);
            this.SCHEMA_MAPPER.associateActionWithSchemaURI((String)object2, (String)object3);
            object = limeXMLSchemaRepository.getSchema((String)object3);
            InputPanel inputPanel = new InputPanel((LimeXMLSchema)object, searchListener);
            inputPanel.setOpaque(false);
            DitherScrollPane ditherScrollPane = new DitherScrollPane(inputPanel, this.DITHERER);
            ditherScrollPane.getViewport().setOpaque(false);
            MAIN_PANEL.add((Component)ditherScrollPane, object2);
            this.SCHEMA_MAPPER.associateActionWithInputPanel((String)object2, inputPanel);
            ++n5;
        }
        SEARCH_CARDS.show(MAIN_PANEL, DEFAULT_SEARCH_KEY);
        object3 = new Box(0);
        this.SEARCH_BUTTON.setMargin(new Insets(0, 0, 0, 0));
        this.STOP_BUTTON.setMargin(new Insets(0, 0, 0, 0));
        ((Container)object3).add(this.SEARCH_BUTTON);
        ((Container)object3).add(this.STOP_BUTTON);
        object2 = new BoxPanel(1);
        ((JComponent)object2).setOpaque(false);
        ((JComponent)object2).setBorder(BorderFactory.createEtchedBorder());
        ((Container)object2).add(RADIO_PANEL);
        object = new BoxPanel(1);
        ((Container)object).add(MAIN_PANEL);
        ((Container)object).add((Component)object2);
        this.SEARCH_BOX_PANEL.add((Component)object);
        this.SEARCH_BOX_PANEL.add((Component)object3);
        this.SEARCH_BUTTON.addActionListener(new SearchListener());
        this.SEARCH_FIELD.addActionListener(new SearchListener());
        this.STOP_BUTTON.addActionListener(new StopListener());
    }

    JComponent getSearchBoxPanel() {
        return this.SEARCH_BOX_PANEL;
    }

    String getSearchString() {
        return this.SEARCH_FIELD.getText().trim();
    }

    void setSearchString(String string) {
        this.SEARCH_FIELD.setText(string);
    }

    void setConnected(boolean bl) {
        this.SEARCH_BUTTON.setEnabled(bl);
    }

    MediaType getSelectedMediaType() {
        return this.namedMediaTypes[this.mediaIndexToUse].getUnderLyingMediaType();
    }

    InputPanel getCurrentInputPanel() {
        String string = this.RADIO_GROUP.getSelection().getActionCommand();
        return this.SCHEMA_MAPPER.getActionInputPanelAssociation(string);
    }

    public void updateTheme() {
        _backColor = MAIN_PANEL.getBackground();
        _fadeColor = ThemeFileHandler.SEARCH_FADE_COLOR.getValue();
        RADIO_PANEL.setBackground(_fadeColor);
        Color color = ThemeFileHandler.SEARCH_BUTTON_COLOR.getValue();
        Enumeration<AbstractButton> enumeration = this.RADIO_GROUP.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            abstractButton.setForeground(color);
            abstractButton.setOpaque(false);
        }
        this.DITHERER.updateTheme();
    }

    private class SchemaMapper {
        private Map itemsToSchemaURI = new HashMap();

        private SchemaMapper() {
        }

        private void associateActionWithSchemaURI(String string, String string2) {
            Object[] objectArray = (Object[])this.itemsToSchemaURI.get(string);
            if (objectArray == null) {
                objectArray = new Object[2];
            }
            objectArray[0] = string2;
            this.itemsToSchemaURI.put(string, objectArray);
        }

        private String getActionSchemaAssociation(String string) {
            String string2 = null;
            Object[] objectArray = (Object[])this.itemsToSchemaURI.get(string);
            if (objectArray != null) {
                string2 = (String)objectArray[0];
            }
            return string2;
        }

        private void associateActionWithInputPanel(String string, InputPanel inputPanel) {
            Object[] objectArray = (Object[])this.itemsToSchemaURI.get(string);
            if (objectArray == null) {
                objectArray = new Object[2];
            }
            objectArray[1] = inputPanel;
            this.itemsToSchemaURI.put(string, objectArray);
        }

        private InputPanel getActionInputPanelAssociation(String string) {
            InputPanel inputPanel = null;
            Object[] objectArray = (Object[])this.itemsToSchemaURI.get(string);
            if (objectArray != null) {
                inputPanel = (InputPanel)objectArray[1];
            }
            return inputPanel;
        }
    }

    private class RadioButtonListener
    implements ActionListener {
        private final int MEDIA_INDEX;

        public RadioButtonListener(int n) {
            this.MEDIA_INDEX = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchInputManager.this.mediaIndexToUse = this.MEDIA_INDEX;
            String string = SearchInputManager.this.SCHEMA_MAPPER.getActionSchemaAssociation(actionEvent.getActionCommand());
            if (string != null) {
                SEARCH_CARDS.show(MAIN_PANEL, actionEvent.getActionCommand());
            } else {
                SearchInputManager.this.DEFAULT_SEARCH_LABEL.setText("" + SearchInputManager.this.namedMediaTypes[this.MEDIA_INDEX]);
                SEARCH_CARDS.show(MAIN_PANEL, SearchInputManager.DEFAULT_SEARCH_KEY);
            }
        }
    }
}

