/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchInputManager;
import com.limegroup.gnutella.gui.search.SearchResultDisplayer;
import com.limegroup.gnutella.gui.search.SearchResultPipeliner;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.gui.InputPanel;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class SearchMediator
implements ThemeObserver {
    static final String DOWNLOAD_STRING = GUIMediator.getStringResource("SEARCH_DOWNLOAD_BUTTON_LABEL");
    static final String KILL_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_KILL_STRING");
    static final String STOP_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_STOP_STRING");
    static final String LAUNCH_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_LAUNCH_STRING");
    static final String BROWSE_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_BROWSE_STRING");
    static final String CHAT_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_CHAT_STRING");
    static final String REPEAT_SEARCH_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_REPEAT_SEARCH_STRING");
    static final String BROWSE_HOST_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_BROWSE_STRING");
    static final String BITZI_LOOKUP_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_BITZI_LOOKUP_STRING");
    static final int DOWNLOAD_BUTTON_INDEX = 0;
    static final int CHAT_BUTTON_INDEX = 1;
    public static final Object REPEAT_SEARCH_LOCK = new Object();
    private static final SearchInputManager INPUT_MANAGER = new SearchInputManager();
    private static final SearchResultDisplayer RESULT_DISPLAYER = new SearchResultDisplayer();
    private static final SearchResultPipeliner RESULT_PIPELINER = new SearchResultPipeliner();

    public SearchMediator() {
        String string = GUIMediator.getStringResource("SPLASH_STATUS_SEARCH_WINDOW");
        GUIMediator.setSplashScreenString(string);
        GUIMediator.addThemeObserver(this);
    }

    static void showMenu(Component component, int n, int n2) {
        RESULT_DISPLAYER.showMenu(component, n, n2);
    }

    static Icon getSelectedIcon() {
        return RESULT_DISPLAYER.getSelectedIcon();
    }

    static byte[] repeatSearch(MediaType mediaType, String string, String string2) {
        if (string.equals("")) {
            return null;
        }
        if (!SearchMediator.validateQueryString(string)) {
            return null;
        }
        int n = 0;
        GUIMediator.instance().getRouter();
        byte[] byArray = RouterService.newQueryGUID();
        GUID gUID = new GUID(byArray);
        SearchMediator.setSearchString("");
        ResultPanel resultPanel = RESULT_DISPLAYER.getSelectedResultPanel();
        GUIMediator.instance().getRouter();
        RouterService.stopQuery(new GUID(resultPanel.getGUID()));
        resultPanel.setGUID(gUID);
        GUIMediator.instance().setSearching(true);
        RESULT_DISPLAYER.restartTimer();
        if (string2 == null) {
            GUIMediator.instance().getRouter();
            RouterService.query(byArray, string, n, mediaType);
        } else {
            GUIMediator.instance().getRouter();
            RouterService.query(byArray, string, string2, n, mediaType);
        }
        return byArray;
    }

    private static void addSearchInGui(String string, GUID gUID, boolean bl) {
        if (bl) {
            SearchMediator.addBrowseHostTab(gUID, string);
        } else {
            SearchMediator.addResultTab(gUID, string);
        }
    }

    static void doBrowseHost() {
        ResultPanel resultPanel = RESULT_DISPLAYER.getSelectedResultPanel();
        if (resultPanel == null) {
            return;
        }
        if (!resultPanel.areRowsSelected()) {
            return;
        }
        TableLine tableLine = resultPanel.getFirstSelectedTableLine();
        if (tableLine == null) {
            return;
        }
        byte[] byArray = tableLine.toRemoteFileDesc().getClientGUID();
        final GUID gUID = new GUID(byArray);
        final String string = tableLine.getBrowseHostEnabledHost();
        final int n = tableLine.getBrowseHostEnabledPort();
        if (string == null || n == -1) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                SearchMediator.doBrowseHost2(string, n, gUID);
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public static void doBrowseHost(final RemoteFileDesc remoteFileDesc) {
        Thread thread = new Thread(){

            public void run() {
                SearchMediator.doBrowseHost2(remoteFileDesc.getHost(), remoteFileDesc.getPort(), new GUID(remoteFileDesc.getClientGUID()));
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public static void doBrowseHost(final String string, final int n, final GUID gUID) {
        Thread thread = new Thread(){

            public void run() {
                if (gUID == null) {
                    SearchMediator.doBrowseHost2(string, n, null);
                } else {
                    SearchMediator.doBrowseHost2(string, n, new GUID(gUID.bytes()));
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    static void reBrowseHost(final String string, final int n, ResultPanel resultPanel) {
        final GUID gUID = new GUID(GUID.makeGuid());
        resultPanel.setGUID(gUID);
        final RouterService routerService = GUIMediator.instance().getRouter();
        Thread thread = new Thread(){

            public void run() {
                RouterService.doBrowseHost(string, n, gUID, new GUID(GUID.makeGuid()));
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private static void doBrowseHost2(String string, int n, GUID gUID) {
        GUID gUID2 = new GUID(GUID.makeGuid());
        SearchMediator.addSearchInGui(string + ":" + n, gUID2, true);
        RouterService routerService = GUIMediator.instance().getRouter();
        RouterService.doBrowseHost(string, n, gUID2, gUID);
    }

    public static void browseHostFailed(GUID gUID) {
        RESULT_DISPLAYER.browseHostFailed(gUID);
    }

    public static byte[] triggerSearch(String string) {
        return SearchMediator.triggerSearch();
    }

    private static boolean isGreedy(String string) {
        if (string.equals("*.*")) {
            return true;
        }
        String string2 = string.toLowerCase().replace('*', ' ').replace('.', ' ').trim();
        return string2.equals("mp3") || string2.equals("mpg") || string2.equals("asf") || string2.equals("jpg") || string2.equals("mpeg") || string2.equals("gif");
    }

    static byte[] triggerSearch() {
        String string = INPUT_MANAGER.getSearchString();
        if (string.equals("")) {
            return null;
        }
        if (!SearchMediator.validateQueryString(string)) {
            return null;
        }
        int n = 0;
        GUIMediator.instance().getRouter();
        byte[] byArray = RouterService.newQueryGUID();
        SearchMediator.addResultTab(new GUID(byArray), string);
        MediaType mediaType = INPUT_MANAGER.getSelectedMediaType();
        GUIMediator.instance().getRouter();
        RouterService.query(byArray, string, n, mediaType);
        return byArray;
    }

    static byte[] triggerSearchXML(InputPanel inputPanel) {
        String string = inputPanel.getStandardQuery();
        if (string == null || string.equals("")) {
            return null;
        }
        String string2 = inputPanel.getInput();
        int n = 0;
        GUIMediator.instance().getRouter();
        byte[] byArray = RouterService.newQueryGUID();
        MediaType mediaType = null;
        String string3 = inputPanel.getSchemaURI();
        if (LimeXMLSchema.getDisplayString(string3).equals("audio")) {
            mediaType = MediaType.getAudioMediaType();
        } else if (LimeXMLSchema.getDisplayString(string3).equals("video")) {
            mediaType = MediaType.getVideoMediaType();
        }
        if (string2 == null) {
            GUID gUID = new GUID(byArray);
            SearchMediator.addResultTab(gUID, string);
            GUIMediator.instance().getRouter();
            RouterService.query(byArray, string, n, mediaType);
        } else {
            GUID gUID = new GUID(byArray);
            SearchMediator.addResultTab(gUID, string, string2, false);
            GUIMediator.instance().getRouter();
            RouterService.query(byArray, string, string2, n, mediaType);
        }
        return byArray;
    }

    private static boolean validateQueryString(String string) {
        if (!(string.length() > 2 || string.length() == 2 && (Character.isDigit(string.charAt(0)) && Character.isLetter(string.charAt(1)) || Character.isLetter(string.charAt(0)) && Character.isDigit(string.charAt(1))))) {
            GUIMediator.showError("ERROR_THREE_CHARACTER_SEARCH");
            return false;
        }
        if (SearchMediator.isGreedy(string)) {
            boolean bl = false;
            String string2 = "ERROR_NETWORK_FLOODING";
            int n = GUIMediator.showYesNoMessage(string2);
            if (n != 101) {
                return false;
            }
        }
        return true;
    }

    private static ResultPanel addResultTab(GUID gUID, String string) {
        return SearchMediator.addResultTab(gUID, string, null, false);
    }

    private static ResultPanel addBrowseHostTab(GUID gUID, String string) {
        return SearchMediator.addResultTab(gUID, string, null, true);
    }

    private static ResultPanel addResultTab(GUID gUID, String string, String string2, boolean bl) {
        return RESULT_DISPLAYER.addResultTab(gUID, string, string2, bl);
    }

    static void addQueryResult(byte[] byArray, TableLine tableLine, TableLine tableLine2, ResultPanel resultPanel, int n) {
        RESULT_DISPLAYER.addQueryResult(byArray, tableLine, tableLine2, resultPanel, n);
    }

    static void doDownload() {
        ResultPanel resultPanel = RESULT_DISPLAYER.getSelectedResultPanel();
        if (resultPanel == null) {
            return;
        }
        if (resultPanel.isEmpty()) {
            SearchMediator.doRequeryDownload();
        } else {
            SearchMediator.downloadAll(resultPanel);
        }
    }

    private static void doRequeryDownload() {
        ResultPanel resultPanel = RESULT_DISPLAYER.getSelectedResultPanel();
        if (resultPanel == null) {
            return;
        }
        try {
            RouterService routerService = GUIMediator.instance().getRouter();
            routerService.download(resultPanel.getQuery(), resultPanel.getRichQuery(), resultPanel.getGUID(), resultPanel.getMediaType());
        }
        catch (AlreadyDownloadingException alreadyDownloadingException) {
            GUIMediator.showError("ERROR_ALREADY_DOWNLOADING", "\"" + alreadyDownloadingException.getFilename() + "\".");
        }
    }

    static void doChat() {
        ResultPanel resultPanel = RESULT_DISPLAYER.getSelectedResultPanel();
        if (resultPanel == null) {
            return;
        }
        if (!resultPanel.areRowsSelected()) {
            return;
        }
        TableLine tableLine = resultPanel.getFirstSelectedTableLine();
        if (tableLine == null) {
            return;
        }
        tableLine.doChat();
    }

    static void doBitziLookup() {
        ResultPanel resultPanel = RESULT_DISPLAYER.getSelectedResultPanel();
        if (resultPanel == null) {
            return;
        }
        if (!resultPanel.areRowsSelected()) {
            return;
        }
        TableLine tableLine = resultPanel.getFirstSelectedTableLine();
        if (tableLine == null) {
            return;
        }
        tableLine.doBitziLookup();
    }

    private static void downloadAll(ResultPanel resultPanel) {
        Iterator iterator;
        ArrayList arrayList = new ArrayList();
        ResultPanel resultPanel2 = resultPanel;
        synchronized (resultPanel2) {
            iterator = resultPanel.getSelectedRows();
            while (iterator.hasNext()) {
                Object object;
                int n;
                RemoteFileDesc[] remoteFileDescArray;
                TableLine tableLine = (TableLine)iterator.next();
                if (tableLine == null) continue;
                if (tableLine.children != null) {
                    remoteFileDescArray = new RemoteFileDesc[tableLine.children.size()];
                    n = 0;
                    while (n < remoteFileDescArray.length) {
                        RemoteFileDesc remoteFileDesc;
                        object = (TableLine)tableLine.children.get(n);
                        remoteFileDescArray[n] = remoteFileDesc = ((TableLine)object).toRemoteFileDesc();
                        ++n;
                    }
                    arrayList.add(remoteFileDescArray);
                    continue;
                }
                remoteFileDescArray = tableLine.toRemoteFileDesc();
                n = 0;
                if (!arrayList.isEmpty()) {
                    object = (RemoteFileDesc[])arrayList.get(arrayList.size() - 1);
                    int n2 = 0;
                    while (n2 < ((Object)object).length) {
                        if (((RemoteFileDesc)object[n2]).equals(remoteFileDescArray)) {
                            n = 1;
                            break;
                        }
                        ++n2;
                    }
                }
                if (n != 0) continue;
                arrayList.add(new RemoteFileDesc[]{remoteFileDescArray});
            }
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            SearchMediator.downloadWithOverwritePrompt((RemoteFileDesc[])iterator.next());
        }
    }

    static void downloadWithOverwritePrompt(RemoteFileDesc[] remoteFileDescArray) {
        Object object;
        String string;
        if (remoteFileDescArray.length < 1) {
            return;
        }
        if (SearchMediator.containsExe(remoteFileDescArray) && !SearchMediator.userWantsExeDownload()) {
            return;
        }
        int n = 0;
        boolean bl = false;
        while (n < remoteFileDescArray.length) {
            if (remoteFileDescArray[n].getIndex() == 0xFFFFFFFFL) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl && (string = ((LimeXMLDocument)(object = remoteFileDescArray[n].getXMLDoc())).getAction()) != null && !string.equals("")) {
            try {
                GUIMediator.instance();
                GUIMediator.openURL(string);
            }
            catch (IOException iOException) {
                return;
            }
            return;
        }
        object = GUIMediator.instance().getRouter();
        try {
            try {
                RouterService.download(remoteFileDescArray, false);
            }
            catch (FileExistsException fileExistsException) {
                String string2 = fileExistsException.getFileName();
                String string3 = "MESSAGE_OVERWRITE_EXISTING_FILE";
                String string4 = "(" + string2 + ")?";
                int n2 = GUIMediator.showYesNoMessage(string3, string4);
                if (n2 != 101) {
                    return;
                }
                try {
                    RouterService.download(remoteFileDescArray, true);
                }
                catch (FileExistsException fileExistsException2) {
                    Assert.that(false, "download(rfd, true) threw unexpected exception");
                }
            }
        }
        catch (AlreadyDownloadingException alreadyDownloadingException) {
            GUIMediator.showError("ERROR_ALREADY_DOWNLOADING", "\"" + alreadyDownloadingException.getFilename() + "\".");
        }
        catch (FileNotFoundException fileNotFoundException) {
            GUIMediator.showError("ERROR_ACCESSING_SAVE_DIRECTORY");
        }
    }

    private static boolean containsExe(RemoteFileDesc[] remoteFileDescArray) {
        int n = 0;
        while (n < remoteFileDescArray.length) {
            if (remoteFileDescArray[n].getFileName().toLowerCase().endsWith("exe")) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean userWantsExeDownload() {
        SettingsManager settingsManager = SettingsManager.instance();
        if (!settingsManager.getPromptExeDownload()) {
            return true;
        }
        String string = GUIMediator.getStringResource("SEARCH_VIRUS_MSG_ONE") + " " + GUIMediator.getStringResource("SEARCH_VIRUS_MSG_TWO") + " " + GUIMediator.getStringResource("SEARCH_VIRUS_MSG_THREE");
        MultiLineLabel multiLineLabel = GUIUtils.getSizedLabel(string);
        JCheckBox jCheckBox = new JCheckBox(GUIMediator.getStringResource("SEARCH_SHOW_MESSAGE_MSG"), false);
        jCheckBox.setForeground((Color)UIManager.get("Label.foreground"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)multiLineLabel, "Center");
        jPanel.add((Component)jCheckBox, "South");
        int n = JOptionPane.showConfirmDialog(SearchMediator.getComponent(), jPanel, GUIMediator.getStringResource("SEARCH_DOWNLOAD_DIALOG_CONFIRM"), 0);
        SettingsManager.instance().setPromptExeDownload(!jCheckBox.isSelected());
        return n == 0;
    }

    static void setTabDisplayCount(ResultPanel resultPanel) {
        RESULT_DISPLAYER.setTabDisplayCount(resultPanel);
    }

    static void columnsChanged() {
        SearchMediator.getDummyResultPanel().dummyColumnsChanged();
    }

    static void columnSizeChanged(HashMap hashMap) {
        SearchMediator.getDummyResultPanel().dummyCommitColumnSizeChanged(hashMap);
    }

    static ResultPanel getDummyResultPanel() {
        return RESULT_DISPLAYER.getDummyResultPanel();
    }

    static void killSearch() {
        RESULT_DISPLAYER.killSearch();
    }

    static void stopSearch() {
        RESULT_DISPLAYER.stopSearch();
    }

    static ResultPanel getPanelAtIndex(int n) {
        return RESULT_DISPLAYER.getPanelAtIndex(n);
    }

    static int getIndexForGUID(GUID gUID) {
        return RESULT_DISPLAYER.getIndexForGUID(gUID);
    }

    static MediaType getSelectedMediaType() {
        return INPUT_MANAGER.getSelectedMediaType();
    }

    static void setSearchString(String string) {
        INPUT_MANAGER.setSearchString(string);
    }

    public static void setConnected(boolean bl) {
        INPUT_MANAGER.setConnected(bl);
    }

    public static JComponent getSearchBoxPanel() {
        return INPUT_MANAGER.getSearchBoxPanel();
    }

    public static InputPanel getCurrentInputPanel() {
        return INPUT_MANAGER.getCurrentInputPanel();
    }

    public static void handleQueryResult(QueryReply queryReply) {
        RESULT_PIPELINER.handleQueryResult(queryReply);
    }

    public static JComponent getComponent() {
        return RESULT_DISPLAYER.getComponent();
    }

    public void updateTheme() {
        INPUT_MANAGER.updateTheme();
        RESULT_DISPLAYER.updateTheme();
    }
}

