/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.search.CancelSearchIconProxy;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.TabbedPaneMouseListener;
import com.limegroup.gnutella.gui.search.TableLine;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.Timer;

final class SearchResultDisplayer
implements ThemeObserver {
    private JLabel searchLabel = new JLabel("        ");
    private final JPanel MAIN_PANEL = new BoxPanel(1);
    private final JTabbedPane TABBED_PANE = new JTabbedPane();
    private final Timer ANIMATION_TIMER;
    private final CancelSearchIconProxy KILL_ICON = new CancelSearchIconProxy();
    private static final List entries = new LinkedList();
    private static final int LABEL_SIZE = 10;
    private final JPanel results = new JPanel();
    private final CardLayout switcher = new CardLayout();
    private JPopupMenu menu;
    private ResultPanel dummyResultPanel;
    private static final GUID stoppedGUID = new GUID(GUID.makeGuid());

    SearchResultDisplayer() {
        this.MAIN_PANEL.setMinimumSize(new Dimension(0, 0));
        this.ANIMATION_TIMER = new Timer(25000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    GUIMediator.instance().setSearching(false);
                }
                catch (Exception exception) {
                    GUIMediator.showInternalError(exception);
                }
            }
        });
        this.ANIMATION_TIMER.setRepeats(false);
        this.results.setPreferredSize(new Dimension(10000, 10000));
        this.results.setLayout(this.switcher);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(GUIMediator.getStringResource("SEARCH_RESULT_TABLE_LABEL"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.dummyResultPanel = new ResultPanel();
        jPanel.add((Component)this.dummyResultPanel, "Center");
        this.results.add("dummy", jPanel);
        this.results.add("tabbedPane", this.TABBED_PANE);
        this.switcher.first(this.results);
        this.MAIN_PANEL.add(this.results);
        this.TABBED_PANE.addMouseListener(new TabbedPaneMouseListener());
    }

    ResultPanel addResultTab(GUID gUID, String string, String string2, boolean bl) {
        MediaType mediaType = SearchMediator.getSelectedMediaType();
        String string3 = string;
        ResultPanel resultPanel = new ResultPanel(gUID, string, mediaType, string2, bl);
        this.searchLabel.setText(GUIMediator.getStringResource("SEARCH_SEARCHING_LABEL"));
        SearchMediator.setSearchString("");
        List list = entries;
        synchronized (list) {
            entries.add(resultPanel);
            this.TABBED_PANE.addTab(string3, this.KILL_ICON, resultPanel);
            this.TABBED_PANE.setSelectedIndex(entries.size() - 1);
            if (entries.size() > SettingsManager.instance().getParallelSearchMax()) {
                entries.remove(0);
                this.TABBED_PANE.removeTabAt(0);
            }
        }
        GUIMediator.instance().setSearching(true);
        this.ANIMATION_TIMER.restart();
        this.switcher.last(this.results);
        this.MAIN_PANEL.revalidate();
        return resultPanel;
    }

    void addQueryResult(byte[] byArray, TableLine tableLine, TableLine tableLine2, ResultPanel resultPanel, int n) {
        ResultPanel resultPanel2 = resultPanel;
        synchronized (resultPanel2) {
            if (!resultPanel.matches(new GUID(byArray))) {
                return;
            }
            resultPanel.addLine(tableLine, tableLine2);
        }
        List list = entries;
        synchronized (list) {
            try {
                if (entries.get(n) != resultPanel) {
                    n = -1;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                n = -1;
            }
            if (n == -1) {
                int n2 = 0;
                while (n2 < entries.size()) {
                    Object object = entries.get(n2);
                    if (object == resultPanel) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
            }
            if (n == -1) {
                return;
            }
            this.TABBED_PANE.setTitleAt(n, resultPanel.getQuery() + " (" + resultPanel.numResults() + ")");
        }
        this.ANIMATION_TIMER.restart();
    }

    void showMenu(Component component, int n, int n2) {
        ResultPanel resultPanel;
        List list = entries;
        synchronized (list) {
            int n3 = this.TABBED_PANE.getSelectedIndex();
            if (n3 == -1) {
                return;
            }
            try {
                resultPanel = (ResultPanel)entries.get(n3);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return;
            }
        }
        this.menu = resultPanel.getPopup();
        this.menu.show(component, n, n2);
    }

    ResultPanel getSelectedResultPanel() {
        return (ResultPanel)this.TABBED_PANE.getSelectedComponent();
    }

    ResultPanel getPanelAtIndex(int n) {
        List list = entries;
        synchronized (list) {
            ResultPanel resultPanel = (ResultPanel)entries.get(n);
            return resultPanel;
        }
    }

    int getIndexForGUID(GUID gUID) {
        List list = entries;
        synchronized (list) {
            int n = 0;
            while (n < entries.size()) {
                ResultPanel resultPanel = (ResultPanel)entries.get(n);
                if (resultPanel.matches(gUID)) {
                    int n2 = n;
                    return n2;
                }
                ++n;
            }
        }
        return -1;
    }

    void killSearch() {
        List list = entries;
        synchronized (list) {
            int n = this.TABBED_PANE.getSelectedIndex();
            if (n == -1) {
                return;
            }
            this.killSearchAtIndex(n);
        }
    }

    void killSearchAtIndex(int n) {
        List list = entries;
        synchronized (list) {
            ResultPanel resultPanel = (ResultPanel)entries.remove(n);
            GUIMediator.instance().getRouter();
            RouterService.stopQuery(new GUID(resultPanel.getGUID()));
            this.TABBED_PANE.removeTabAt(n);
            if (entries.size() == 0) {
                this.switcher.first(this.results);
                GUIMediator.instance().setSearching(false);
            } else {
                this.checkToStopLime();
            }
        }
    }

    void browseHostFailed(GUID gUID) {
        int n = this.getIndexForGUID(gUID);
        if (n > -1) {
            ResultPanel resultPanel = this.getPanelAtIndex(n);
            GUIMediator.showError("ERROR_BROWSE_HOST_FAILED_BEGIN_KEY", resultPanel.getQuery(), "ERROR_BROWSE_HOST_FAILED_END_KEY");
            this.killSearchAtIndex(n);
        }
    }

    void stopSearch() {
        List list = entries;
        synchronized (list) {
            int n = this.TABBED_PANE.getSelectedIndex();
            if (n == -1) {
                return;
            }
            ResultPanel resultPanel = (ResultPanel)entries.get(n);
            GUIMediator.instance().getRouter();
            RouterService.stopQuery(new GUID(resultPanel.getGUID()));
            resultPanel.setGUID(stoppedGUID);
            this.checkToStopLime();
        }
    }

    private void checkToStopLime() {
        boolean bl = true;
        int n = 0;
        while (n < entries.size()) {
            ResultPanel resultPanel = (ResultPanel)entries.get(n);
            bl &= resultPanel.matches(stoppedGUID);
            ++n;
        }
        if (bl) {
            GUIMediator.instance().setSearching(false);
        }
    }

    void setTabDisplayCount(ResultPanel resultPanel) {
        int n = 0;
        boolean bl = false;
        List list = entries;
        synchronized (list) {
            while (n < entries.size()) {
                Object object = entries.get(n);
                if (object == resultPanel) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) {
                this.TABBED_PANE.setTitleAt(n, resultPanel.getQuery() + " (" + resultPanel.numResults() + ")");
            }
        }
    }

    Icon getSelectedIcon() {
        return this.TABBED_PANE.getIconAt(this.TABBED_PANE.getSelectedIndex());
    }

    ResultPanel getDummyResultPanel() {
        return this.dummyResultPanel;
    }

    void restartTimer() {
        this.ANIMATION_TIMER.restart();
    }

    JComponent getComponent() {
        return this.MAIN_PANEL;
    }

    public void updateTheme() {
        this.dummyResultPanel.updateTheme();
        int n = this.TABBED_PANE.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            ResultPanel resultPanel = (ResultPanel)this.TABBED_PANE.getComponentAt(n2);
            resultPanel.updateTheme();
            ++n2;
        }
    }
}

