/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineGrouper;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import javax.swing.SwingUtilities;

final class SearchResultPipeliner {
    private static final int BUFFER_SIZE = 2000;
    private static final int MAX_RATE = 200;
    private static final int DELAY_TIME = 5;
    private static int PlatformSpecificNumRows = 3000;
    private LinkedList buffer = new LinkedList();
    private long lastTime;
    private static final int YES = 1;
    private static final int NO = 2;
    private static final int MAYBE = 3;
    private final boolean debugOn = false;

    SearchResultPipeliner() {
        SearchViewRunner searchViewRunner = new SearchViewRunner();
        searchViewRunner.setDaemon(true);
        searchViewRunner.start();
    }

    void handleQueryResult(QueryReply queryReply) {
        LinkedList linkedList = this.buffer;
        synchronized (linkedList) {
            this.parseQHD(queryReply);
            this.buffer.addLast(queryReply);
            if (this.buffer.size() > 2000) {
                this.buffer.removeFirst();
            }
            this.buffer.notify();
        }
    }

    private boolean handleQueryReplyInternal(QueryReply queryReply) {
        Object object = SearchMediator.REPEAT_SEARCH_LOCK;
        synchronized (object) {
            Object object2;
            int n = SearchMediator.getIndexForGUID(new GUID(queryReply.getGUID()));
            if (n == -1) {
                boolean bl = false;
                return bl;
            }
            ResultPanel resultPanel = SearchMediator.getPanelAtIndex(n);
            if (resultPanel == null) {
                boolean bl = false;
                return bl;
            }
            byte[] byArray = queryReply.getClientGUID();
            byte[] byArray2 = queryReply.getGUID();
            final byte[] byArray3 = (byte[])byArray2.clone();
            List list = null;
            try {
                list = queryReply.getResultsAsList();
            }
            catch (BadPacketException badPacketException) {
                boolean bl = false;
                return bl;
            }
            TableLineGrouper tableLineGrouper = resultPanel.getGrouper();
            RouterService routerService = GUIMediator.instance().getRouter();
            SettingsManager settingsManager = SettingsManager.instance();
            String string = "";
            try {
                this.debug("Trying to do uncompress.....");
                object2 = queryReply.getXMLBytes();
                if (((byte[])object2).length > 1) {
                    byte[] byArray4 = LimeXMLUtils.uncompress((byte[])object2);
                    string = new String(byArray4);
                }
            }
            catch (Exception exception) {
                string = "";
            }
            this.debug("xmlCollectionString = " + string);
            object2 = LimeXMLDocumentHelper.getDocuments(string, list.size());
            int n2 = object2.size();
            int n3 = list.size();
            int n4 = -1;
            boolean bl = RouterService.isSpecificXMLSearch(byArray2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object3;
                Object object4;
                ++n4;
                Response response = (Response)iterator.next();
                if (resultPanel.numResults() >= PlatformSpecificNumRows) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (!RouterService.matchesType(byArray2, response) || RouterService.isMandragoreWorm(byArray2, response)) continue;
                long l = response.getSize();
                long l2 = response.getIndex();
                long l3 = 0xFFFFFFFFL;
                if (l > Integer.MAX_VALUE || l2 > l3) continue;
                int n5 = ByteOrder.long2int(queryReply.getSpeed());
                boolean bl3 = false;
                try {
                    bl3 = queryReply.getIsMeasuredSpeed();
                }
                catch (BadPacketException badPacketException) {
                    // empty catch block
                }
                boolean bl4 = false;
                boolean bl5 = false;
                try {
                    bl5 = queryReply.getSupportsBrowseHost();
                }
                catch (BadPacketException badPacketException) {
                    // empty catch block
                }
                try {
                    bl4 = queryReply.getSupportsChat() && !queryReply.getNeedsPush();
                }
                catch (BadPacketException badPacketException) {
                    // empty catch block
                }
                boolean bl6 = !RouterService.acceptedIncomingConnection();
                int n6 = RouterService.score(byArray2, response);
                int n7 = queryReply.calculateQualityOfService(bl6);
                if (n7 < settingsManager.getMinimumSearchQuality() || n5 < settingsManager.getMinimumSearchSpeed() || bl && n6 == 0) continue;
                ArrayList arrayList = null;
                if (string == null || string.equals("")) {
                    try {
                        object4 = response.getMetadata();
                        object3 = new LimeXMLDocument((String)object4);
                    }
                    catch (Exception exception) {
                        object3 = null;
                    }
                    if (object3 == null) {
                        arrayList = null;
                    } else {
                        arrayList = new ArrayList();
                        arrayList.add(object3);
                    }
                } else {
                    arrayList = new ArrayList(n2);
                    int n8 = 0;
                    while (n8 < n2) {
                        object3 = (LimeXMLDocument[])object2.get(n8);
                        if (object3 != null && object3[n4] != null) {
                            arrayList.add(object3[n4]);
                        }
                        ++n8;
                    }
                }
                object3 = new TableLine(response.getName(), new Integer((int)l), new Integer(n5), queryReply.getIP(), new Integer(queryReply.getPort()), byArray, new Long(l2), new Integer(n7), new Integer(n6), bl3, bl4, arrayList, bl5, response.getUrns());
                object4 = tableLineGrouper.match((TableLine)object3);
                if (object4 == null) {
                    tableLineGrouper.add((TableLine)object3);
                }
                SwingUtilities.invokeLater(new Runnable((TableLine)object3, (TableLine)object4, resultPanel, n){
                    private final /* synthetic */ TableLine val$line;
                    private final /* synthetic */ TableLine val$group;
                    private final /* synthetic */ ResultPanel val$rp;
                    private final /* synthetic */ int val$i;
                    {
                        this.val$line = tableLine;
                        this.val$group = tableLine2;
                        this.val$rp = resultPanel;
                        this.val$i = n;
                    }

                    public void run() {
                        try {
                            SearchMediator.addQueryResult(byArray3, this.val$line, this.val$group, this.val$rp, this.val$i);
                        }
                        catch (Exception exception) {
                            GUIMediator.showInternalError(exception);
                        }
                    }
                });
            }
        }
        return true;
    }

    private void parseQHD(QueryReply queryReply) {
        this.parseBusy(queryReply);
        this.parseIncoming(queryReply);
    }

    private int parseBusy(QueryReply queryReply) {
        boolean bl;
        try {
            bl = queryReply.getIsBusy();
        }
        catch (BadPacketException badPacketException) {
            return 3;
        }
        if (bl) {
            return 1;
        }
        return 2;
    }

    private int parseIncoming(QueryReply queryReply) {
        boolean bl;
        try {
            bl = queryReply.getNeedsPush();
        }
        catch (BadPacketException badPacketException) {
            return 3;
        }
        if (bl) {
            return 1;
        }
        return 2;
    }

    private void debug(String string) {
    }

    static {
        if (CommonUtils.isMacClassic()) {
            PlatformSpecificNumRows = 1000;
        }
    }

    private class SearchViewRunner
    extends Thread {
        private SearchViewRunner() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (true) {
                    boolean bl;
                    QueryReply queryReply = null;
                    LinkedList linkedList = SearchResultPipeliner.this.buffer;
                    synchronized (linkedList) {
                        while (true) {
                            if (!SearchResultPipeliner.this.buffer.isEmpty()) {
                                queryReply = (QueryReply)SearchResultPipeliner.this.buffer.removeLast();
                                // MONITOREXIT @DISABLED, blocks:[0, 4, 8, 9, 10] lbl9 : MonitorExitStatement: MONITOREXIT : var2_3
                                long l = System.currentTimeMillis();
                                long l2 = l - SearchResultPipeliner.this.lastTime;
                                long l3 = (long)(5 * queryReply.getResultCount()) - l2;
                                if (l3 <= 0L) break;
                                try {
                                    Thread.sleep(l3);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                break;
                            }
                            try {
                                SearchResultPipeliner.this.buffer.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (!(bl = SearchResultPipeliner.this.handleQueryReplyInternal(queryReply))) continue;
                    SearchResultPipeliner.this.lastTime = System.currentTimeMillis();
                }
            }
            catch (Exception exception) {
                GUIMediator.showInternalError(exception);
                return;
            }
        }
    }
}

