/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.DisplayManager;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.ResultPanelModel;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.util.Pair;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

abstract class TableColumnFilter
extends ResultPanelModel {
    private ArrayList schemas;
    private ArrayList columnNames;
    private ArrayList selectedColIndices;
    private final int normalCols = 9;
    private DisplayManager dispManager;
    private JPopupMenu menu;
    private HashMap itemToPair;
    private ResultPanel rp;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$TreeTableModel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$ResultSpeed;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$CachingEndpoint;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$QualityHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$ChatHolder;

    public TableColumnFilter(TableLine tableLine, boolean bl, ResultPanel resultPanel) {
        super(tableLine, bl);
        this.rp = resultPanel;
        this.columnNames = new ArrayList();
        this.columnNames.add(GUIMediator.getStringResource("RESULT_PANEL_QUALITY"));
        this.columnNames.add(GUIMediator.getStringResource("RESULT_PANEL_COUNT"));
        this.columnNames.add(GUIMediator.getStringResource("RESULT_PANEL_NAME"));
        this.columnNames.add(GUIMediator.getStringResource("RESULT_PANEL_TYPE"));
        this.columnNames.add(GUIMediator.getStringResource("RESULT_PANEL_SIZE"));
        this.columnNames.add(GUIMediator.getStringResource("RESULT_PANEL_SPEED"));
        this.columnNames.add(GUIMediator.getStringResource("RESULT_PANEL_SCORE"));
        this.columnNames.add(GUIMediator.getStringResource("RESULT_PANEL_CHAT"));
        this.columnNames.add(GUIMediator.getStringResource("RESULT_PANEL_LOCATION"));
        this.schemas = new ArrayList();
        this.dispManager = DisplayManager.instance();
        this.selectedColIndices = new ArrayList();
        int n = 0;
        while (n < 9) {
            String string = this.dispManager.getValue(DisplayManager.getKeyString(n));
            if (Integer.parseInt(string) > -1) {
                this.selectedColIndices.add(new Integer(n));
            }
            ++n;
        }
    }

    public Object getValueAt(Object object, int n) {
        TableLine tableLine = (TableLine)object;
        Pair pair = this.getIndexSchemaPairForColumn(n);
        if (pair == null) {
            return "";
        }
        n = pair.getKey();
        LimeXMLSchema limeXMLSchema = (LimeXMLSchema)pair.getElement();
        return tableLine.getValue(limeXMLSchema, n);
    }

    public int getColumnCount() {
        return this.selectedColIndices.size();
    }

    public String getColumnName(int n) {
        int n2 = this.translateColumnValue(n);
        return (String)this.columnNames.get(n2);
    }

    public Class getColumnClass(int n) {
        if (n >= this.columnNames.size()) {
            Assert.that(false, "Bad column in table");
            return null;
        }
        n = this.translateColumnValue(n);
        switch (n) {
            case 2: {
                return class$com$limegroup$gnutella$gui$TreeTableModel == null ? (class$com$limegroup$gnutella$gui$TreeTableModel = TableColumnFilter.class$("com.limegroup.gnutella.gui.TreeTableModel")) : class$com$limegroup$gnutella$gui$TreeTableModel;
            }
            case 3: {
                return class$java$lang$String == null ? (class$java$lang$String = TableColumnFilter.class$("java.lang.String")) : class$java$lang$String;
            }
            case 4: {
                return class$java$lang$String == null ? (class$java$lang$String = TableColumnFilter.class$("java.lang.String")) : class$java$lang$String;
            }
            case 5: {
                return class$com$limegroup$gnutella$gui$search$ResultSpeed == null ? (class$com$limegroup$gnutella$gui$search$ResultSpeed = TableColumnFilter.class$("com.limegroup.gnutella.gui.search.ResultSpeed")) : class$com$limegroup$gnutella$gui$search$ResultSpeed;
            }
            case 6: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = TableColumnFilter.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 8: {
                return class$com$limegroup$gnutella$gui$search$CachingEndpoint == null ? (class$com$limegroup$gnutella$gui$search$CachingEndpoint = TableColumnFilter.class$("com.limegroup.gnutella.gui.search.CachingEndpoint")) : class$com$limegroup$gnutella$gui$search$CachingEndpoint;
            }
            case 0: {
                return class$com$limegroup$gnutella$gui$search$QualityHolder == null ? (class$com$limegroup$gnutella$gui$search$QualityHolder = TableColumnFilter.class$("com.limegroup.gnutella.gui.search.QualityHolder")) : class$com$limegroup$gnutella$gui$search$QualityHolder;
            }
            case 7: {
                return class$com$limegroup$gnutella$gui$ChatHolder == null ? (class$com$limegroup$gnutella$gui$ChatHolder = TableColumnFilter.class$("com.limegroup.gnutella.gui.ChatHolder")) : class$com$limegroup$gnutella$gui$ChatHolder;
            }
        }
        return class$java$lang$String == null ? (class$java$lang$String = TableColumnFilter.class$("java.lang.String")) : class$java$lang$String;
    }

    public void addSchema(LimeXMLSchema limeXMLSchema) {
        this.schemas.add(limeXMLSchema);
        Properties properties = this.dispManager.getProperties(limeXMLSchema.getSchemaURI());
        Iterator iterator = limeXMLSchema.getCanonicalizedFields().iterator();
        while (iterator.hasNext()) {
            String string = ((SchemaFieldInfo)iterator.next()).getCanonicalizedFieldName();
            String string2 = this.dispManager.getDisplayName(string, limeXMLSchema.getSchemaURI());
            this.columnNames.add(string2);
            String string3 = this.dispManager.getValue(string);
            if (Integer.parseInt(string3) <= -1) continue;
            this.selectedColIndices.add(new Integer(this.columnNames.size() - 1));
        }
    }

    public Object getColumnId(int n) {
        String string;
        Pair pair = this.getIndexSchemaPairForColumn(n);
        LimeXMLSchema limeXMLSchema = (LimeXMLSchema)pair.getElement();
        n = pair.getKey();
        if (limeXMLSchema == null) {
            string = DisplayManager.getKeyString(n);
        } else {
            List list = limeXMLSchema.getCanonicalizedFields();
            SchemaFieldInfo schemaFieldInfo = (SchemaFieldInfo)list.get(n);
            string = schemaFieldInfo.getCanonicalizedFieldName();
        }
        return string;
    }

    public int getPreferredWidth(int n) {
        String string;
        Pair pair = this.getIndexSchemaPairForColumn(n);
        LimeXMLSchema limeXMLSchema = (LimeXMLSchema)pair.getElement();
        n = pair.getKey();
        if (limeXMLSchema == null) {
            string = DisplayManager.getKeyString(n);
        } else {
            List list = limeXMLSchema.getCanonicalizedFields();
            SchemaFieldInfo schemaFieldInfo = (SchemaFieldInfo)list.get(n);
            string = schemaFieldInfo.getCanonicalizedFieldName();
        }
        return Integer.parseInt(this.dispManager.getValue(string));
    }

    public JPopupMenu getColumnSelectionMenu() {
        this.menu = new JPopupMenu();
        this.itemToPair = new HashMap();
        JMenu jMenu = null;
        int n = 0;
        int n2 = (Integer)this.selectedColIndices.get(n);
        int n3 = -1;
        LimeXMLSchema limeXMLSchema = null;
        int n4 = 0;
        int n5 = 9;
        int n6 = 0;
        Iterator iterator = this.columnNames.iterator();
        int n7 = 0;
        while (iterator.hasNext()) {
            if (n7 == n5) {
                limeXMLSchema = (LimeXMLSchema)this.schemas.get(++n3);
                jMenu = new JMenu(LimeXMLSchema.getDisplayString(limeXMLSchema.getSchemaURI()));
                this.menu.add(jMenu);
                n4 = n5;
                int n8 = limeXMLSchema.getCanonicalizedFields().size();
                n5 += n8;
                n6 = 0;
            }
            String string = (String)iterator.next();
            boolean bl = false;
            if (n7 == n2) {
                bl = true;
                if (n < this.selectedColIndices.size() - 1) {
                    n2 = (Integer)this.selectedColIndices.get(++n);
                }
            }
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string, bl);
            Pair pair = new Pair(n6, limeXMLSchema);
            this.itemToPair.put(jCheckBoxMenuItem, pair);
            ++n6;
            if (jMenu == null) {
                this.menu.add(jCheckBoxMenuItem);
            } else {
                jMenu.add(jCheckBoxMenuItem);
            }
            jCheckBoxMenuItem.addActionListener(new SelectionActionListener());
            ++n7;
        }
        return this.menu;
    }

    void sort(int n, boolean bl) {
        Pair pair = this.getIndexSchemaPairForColumn(n);
        super.sort(pair, bl);
    }

    private int getDefaultWidth(String string) {
        int n = string.indexOf("^");
        if (n < 0) {
            return 30;
        }
        return Integer.parseInt(string.substring(n + 1));
    }

    private int translateColumnValue(int n) {
        return (Integer)this.selectedColIndices.get(n);
    }

    Pair getIndexSchemaPairForColumn(int n) {
        if ((n = this.translateColumnValue(n)) < 9) {
            return new Pair(n, null);
        }
        Iterator iterator = this.schemas.iterator();
        int n2 = 9;
        while (iterator.hasNext()) {
            LimeXMLSchema limeXMLSchema = (LimeXMLSchema)iterator.next();
            int n3 = limeXMLSchema.getCanonicalizedFields().size();
            int n4 = n2;
            if (n >= (n2 += n3)) continue;
            return new Pair(n - n4, limeXMLSchema);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SelectionActionListener
    implements ActionListener {
        private SelectionActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Iterator iterator;
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            Pair pair = (Pair)TableColumnFilter.this.itemToPair.get(jCheckBoxMenuItem);
            int n = pair.getKey();
            LimeXMLSchema limeXMLSchema = (LimeXMLSchema)pair.getElement();
            int n2 = -1;
            if (limeXMLSchema == null) {
                n2 = n;
            } else {
                n2 = 9;
                iterator = TableColumnFilter.this.schemas.iterator();
                while (iterator.hasNext()) {
                    LimeXMLSchema limeXMLSchema2 = (LimeXMLSchema)iterator.next();
                    if (limeXMLSchema == limeXMLSchema2) break;
                    n2 += limeXMLSchema2.getCanonicalizedFields().size();
                }
                n2 += n;
            }
            if (jCheckBoxMenuItem.getState()) {
                iterator = TableColumnFilter.this.selectedColIndices.iterator();
                boolean bl = false;
                boolean bl2 = false;
                int n3 = -1;
                int n4 = (Integer)iterator.next();
                int n5 = 0;
                while (iterator.hasNext()) {
                    n3 = n4;
                    n4 = (Integer)iterator.next();
                    ++n5;
                    if (n2 == n3 || n2 == n4) {
                        bl2 = true;
                        break;
                    }
                    if (n2 <= n3 || n2 >= n4) continue;
                    bl = true;
                    break;
                }
                if (bl2) {
                    TableColumnFilter.this.menu = null;
                    TableColumnFilter.this.itemToPair = null;
                    return;
                }
                if (bl) {
                    TableColumnFilter.this.selectedColIndices.add(n5, new Integer(n2));
                } else {
                    TableColumnFilter.this.selectedColIndices.add(new Integer(n2));
                }
                String string = "";
                int n6 = -1;
                if (limeXMLSchema == null) {
                    string = DisplayManager.getKeyString(n);
                    n6 = DisplayManager.getDefaultWidth(n);
                } else {
                    Properties properties = TableColumnFilter.this.dispManager.getProperties(limeXMLSchema.getSchemaURI());
                    List list = limeXMLSchema.getCanonicalizedFields();
                    SchemaFieldInfo schemaFieldInfo = (SchemaFieldInfo)list.get(n);
                    string = schemaFieldInfo.getCanonicalizedFieldName();
                    String string2 = properties.getProperty(string, "null");
                    n6 = TableColumnFilter.this.getDefaultWidth(string2);
                }
                TableColumnFilter.this.dispManager.addColumn(string, n6);
                TableColumnFilter.this.rp.columnsChanged();
            } else {
                if (TableColumnFilter.this.selectedColIndices.size() == 1) {
                    TableColumnFilter.this.rp.showColumnWarning();
                    return;
                }
                iterator = TableColumnFilter.this.selectedColIndices.iterator();
                boolean bl = false;
                int n7 = -1;
                while (iterator.hasNext()) {
                    int n8 = (Integer)iterator.next();
                    ++n7;
                    if (n8 != n2) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    TableColumnFilter.this.selectedColIndices.remove(n7);
                    String string = "";
                    if (limeXMLSchema == null) {
                        string = DisplayManager.getKeyString(n);
                    } else {
                        List list = limeXMLSchema.getCanonicalizedFields();
                        SchemaFieldInfo schemaFieldInfo = (SchemaFieldInfo)list.get(n);
                        string = schemaFieldInfo.getCanonicalizedFieldName();
                    }
                    TableColumnFilter.this.dispManager.removeColumn(string);
                    TableColumnFilter.this.rp.columnsChanged();
                }
            }
            TableColumnFilter.this.menu = null;
            TableColumnFilter.this.itemToPair = null;
        }
    }
}

