/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.search.CachingEndpoint;
import com.limegroup.gnutella.gui.search.DisplayManager;
import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.TableLineComparator;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.util.Launcher;
import com.limegroup.gnutella.util.Pair;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.util.StringTokenizer;

public class TableLine {
    Integer size;
    byte[] clientGUID;
    Long index;
    private String processedFilename = null;
    volatile List children;
    int childName = 0;
    String filenameWithoutExtension;
    String extension;
    String sizeString;
    ResultSpeed speed;
    Integer score;
    Integer quality;
    CachingEndpoint location;
    Boolean chatEnabled;
    Boolean browseHostEnabled;
    List xmlDocuments;
    final Set urns;
    private static final Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());

    TableLine() {
        this.children = new ArrayList();
        this.urns = EMPTY_SET;
    }

    TableLine(String string, Integer n, Integer n2, String string2, Integer n3, byte[] byArray, Long l, Integer n4, Integer n5, boolean bl, boolean bl2, List list, boolean bl3, Set set) {
        this.speed = new ResultSpeed(n2, bl);
        this.size = n;
        this.clientGUID = byArray;
        this.index = l;
        this.children = null;
        this.score = n5;
        this.quality = n4;
        this.chatEnabled = new Boolean(bl2);
        this.xmlDocuments = list;
        this.urns = set == null ? EMPTY_SET : Collections.unmodifiableSet(set);
        this.browseHostEnabled = new Boolean(bl3);
        int n6 = string.lastIndexOf(46);
        if (n6 == -1) {
            this.filenameWithoutExtension = string;
            this.extension = "";
        } else {
            this.filenameWithoutExtension = string.substring(0, n6);
            this.extension = string.substring(n6 + 1);
        }
        this.sizeString = GUIUtils.toKilobytes(n.intValue());
        this.location = new CachingEndpoint(string2, (int)n3);
    }

    TableLine createClone() {
        return new TableLine(this.getFilename(), this.size, new Integer(this.speed.intValue()), this.location.getHostname(), new Integer(this.location.getPort()), this.clientGUID, this.index, this.quality, this.score, this.speed.isMeasured(), this.chatEnabled, this.xmlDocuments, this.browseHostEnabled, this.urns);
    }

    static Comparator newComparator(Pair pair, boolean bl) {
        return new TableLineComparator(pair, bl);
    }

    void setSpeed(ResultSpeed resultSpeed) {
        this.speed = resultSpeed;
    }

    LimeXMLDocument getDocumentAt(int n) {
        if (this.xmlDocuments == null) {
            return null;
        }
        if (n < this.xmlDocuments.size()) {
            return (LimeXMLDocument)this.xmlDocuments.get(n);
        }
        return null;
    }

    List getDocuments() {
        return this.xmlDocuments;
    }

    ResultSpeed getSpeed() {
        return this.speed;
    }

    void setQuality(int n) {
        this.quality = new Integer(n);
    }

    int getQuality() {
        return this.quality;
    }

    final boolean getChatEnabled() {
        return this.chatEnabled;
    }

    final boolean getBrowseHostEnabled() {
        return this.browseHostEnabled;
    }

    final void setChatEnabled(boolean bl) {
        this.chatEnabled = new Boolean(bl);
    }

    String getFilename() {
        if (this.extension.equals("")) {
            return this.filenameWithoutExtension;
        }
        return this.filenameWithoutExtension + "." + this.extension;
    }

    String getSHA1() {
        if (this.urns == null) {
            return null;
        }
        Iterator iterator = this.urns.iterator();
        while (iterator.hasNext()) {
            URN uRN = (URN)iterator.next();
            if (!uRN.isSHA1()) continue;
            return uRN.toString();
        }
        return null;
    }

    public Object getValue(LimeXMLSchema limeXMLSchema, int n) {
        if (limeXMLSchema == null) {
            switch (n) {
                case 2: {
                    return this.filenameWithoutExtension;
                }
                case 3: {
                    return this.extension;
                }
                case 4: {
                    return this.sizeString;
                }
                case 5: {
                    return this.getSpeed();
                }
                case 6: {
                    return this.score;
                }
                case 8: {
                    return this.location;
                }
                case 0: {
                    return this.quality;
                }
                case 7: {
                    return this.chatEnabled;
                }
                case 1: {
                    return this.location.numLocations() > 1 ? "" + this.location.numLocations() : "";
                }
            }
            Assert.that(false, "Bad column in table");
            return null;
        }
        if (this.xmlDocuments == null) {
            return "";
        }
        Iterator iterator = this.xmlDocuments.iterator();
        LimeXMLDocument limeXMLDocument = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            limeXMLDocument = (LimeXMLDocument)iterator.next();
            if (limeXMLDocument.getSchemaURI().equals(limeXMLSchema.getSchemaURI())) break;
            limeXMLDocument = null;
        }
        if (limeXMLDocument == null) {
            return "";
        }
        List list = limeXMLSchema.getCanonicalizedFields();
        String string = ((SchemaFieldInfo)list.get(n)).getCanonicalizedFieldName();
        String string2 = limeXMLDocument.getValue(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    String getRequest() {
        String string;
        String string2 = "";
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        LimeXMLSchema limeXMLSchema = null;
        limeXMLSchema = limeXMLSchemaRepository.getSchema("http://www.limewire.com/schemas/audio.xsd");
        if (limeXMLSchema != null) {
            String string3 = (String)this.getValue(limeXMLSchema, 1);
            string = (String)this.getValue(limeXMLSchema, 2);
            if (string3 != null && !string3.equals("")) {
                string2 = string2 + this.breakString(string3);
            }
            if (string != null && !string.equals("")) {
                string2 = string2 + "+";
                string2 = string2 + this.breakString(string);
            }
            if (!string2.equals("")) {
                return string2 + "&mode=music";
            }
        }
        if ((limeXMLSchema = limeXMLSchemaRepository.getSchema("http://www.limewire.com/schemas/video.xsd")) != null) {
            string = (String)this.getValue(limeXMLSchema, 0);
            if (string != null && !string.equals("")) {
                string2 = string2 + this.breakString(string);
            }
            if (!string2.equals("")) {
                return string2 + "mode=vhs";
            }
        }
        string2 = string2 + this.breakString(this.filenameWithoutExtension);
        return string2 + "&mode=music";
    }

    private String breakString(String string) {
        String string2 = "-_*~ ";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string3 = string3 + "%20" + stringTokenizer.nextToken();
        }
        return string3;
    }

    int match(TableLine tableLine, ApproximateMatcher approximateMatcher) {
        return this.matchInternal(tableLine, approximateMatcher);
    }

    protected int matchInternal(TableLine tableLine, ApproximateMatcher approximateMatcher) {
        float f;
        if (this.processedFilename == null) {
            this.processedFilename = approximateMatcher.process(this.filenameWithoutExtension);
        }
        if (tableLine.processedFilename == null) {
            tableLine.processedFilename = approximateMatcher.process(tableLine.filenameWithoutExtension);
        }
        if (!this.extension.equals(tableLine.extension)) {
            return 1;
        }
        float f2 = this.size.intValue();
        float f3 = Math.abs(f2 - (f = (float)tableLine.size.intValue()));
        if (f3 > 60000.0f) {
            return 2;
        }
        int n = Math.round(Math.min(0.1f * (float)this.filenameWithoutExtension.length(), 0.1f * (float)tableLine.filenameWithoutExtension.length()));
        if (!approximateMatcher.matches(this.processedFilename, tableLine.processedFilename, n = Math.min(n, 4))) {
            return 3;
        }
        return 0;
    }

    public RemoteFileDesc toRemoteFileDesc() {
        return new RemoteFileDesc(this.location.getHostname(), this.location.getPort(), this.index, this.getFilename(), this.size, this.clientGUID, this.speed.intValue(), this.chatEnabled, this.getQuality(), this.browseHostEnabled, this.xmlDocuments != null && this.xmlDocuments.size() > 0 ? (LimeXMLDocument)this.xmlDocuments.get(0) : null, this.urns);
    }

    public String toString() {
        return this.filenameWithoutExtension;
    }

    final boolean hasChildren() {
        return this.children != null;
    }

    final void doChat() {
        if (!this.getChatEnabled()) {
            return;
        }
        String string = this.getChatEnabledHost();
        if (string == null) {
            return;
        }
        int n = this.getChatEnabledPort();
        if (n == -1) {
            return;
        }
        RouterService routerService = GUIMediator.instance().getRouter();
        RouterService.createChat(string, n);
    }

    final void doBitziLookup() {
        String string = this.getSHA1();
        if (string == null) {
            return;
        }
        int n = 1 + string.indexOf(":", 4);
        String string2 = "http://bitzi.com/lookup/" + string.substring(n) + "?ref=limewire";
        try {
            Launcher.openURL(string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final String getChatEnabledHost() {
        if (!this.getChatEnabled()) {
            return null;
        }
        if (!this.hasChildren()) {
            return this.location.getHostname();
        }
        int n = 0;
        while (n < this.children.size()) {
            TableLine tableLine = (TableLine)this.children.get(n);
            if (tableLine.getChatEnabled()) {
                return tableLine.location.getHostname();
            }
            ++n;
        }
        return null;
    }

    String[] getMetaText() {
        Object object;
        if (this.xmlDocuments == null) {
            return new String[0];
        }
        ArrayList arrayList = new ArrayList();
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        Iterator iterator = this.xmlDocuments.iterator();
        DisplayManager displayManager = DisplayManager.instance();
        while (iterator.hasNext()) {
            object = (LimeXMLDocument)iterator.next();
            LimeXMLSchema limeXMLSchema = limeXMLSchemaRepository.getSchema(object.getSchemaURI());
            if (limeXMLSchema == null) continue;
            Iterator iterator2 = limeXMLSchema.getCanonicalizedFields().iterator();
            while (iterator2.hasNext()) {
                SchemaFieldInfo schemaFieldInfo = (SchemaFieldInfo)iterator2.next();
                String string = schemaFieldInfo.getCanonicalizedFieldName();
                String string2 = object.getValue(string);
                if (string2 == null || string2.equals("")) continue;
                arrayList.add(displayManager.getDisplayName(string, limeXMLSchema.getSchemaURI()) + ": " + string2);
            }
        }
        object = new String[arrayList.size()];
        arrayList.toArray((Object[])object);
        return object;
    }

    final String getBrowseHostEnabledHost() {
        if (!this.getBrowseHostEnabled()) {
            return null;
        }
        if (!this.hasChildren()) {
            return this.location.getHostname();
        }
        int n = 0;
        while (n < this.children.size()) {
            TableLine tableLine = (TableLine)this.children.get(n);
            if (tableLine.getBrowseHostEnabled()) {
                return tableLine.location.getHostname();
            }
            ++n;
        }
        return null;
    }

    private final int getChatEnabledPort() {
        if (!this.getChatEnabled()) {
            return -1;
        }
        if (!this.hasChildren()) {
            return this.location.getPort();
        }
        int n = 0;
        while (n < this.children.size()) {
            TableLine tableLine = (TableLine)this.children.get(n);
            if (tableLine.getChatEnabled()) {
                return tableLine.location.getPort();
            }
            ++n;
        }
        return -1;
    }

    final int getBrowseHostEnabledPort() {
        if (!this.getBrowseHostEnabled()) {
            return -1;
        }
        if (!this.hasChildren()) {
            return this.location.getPort();
        }
        int n = 0;
        while (n < this.children.size()) {
            TableLine tableLine = (TableLine)this.children.get(n);
            if (tableLine.getBrowseHostEnabled()) {
                return tableLine.location.getPort();
            }
            ++n;
        }
        return -1;
    }
}

